/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.notickvd.common;

import com.ishland.c2me.base.common.structs.DynamicPriorityQueue;
import com.ishland.c2me.base.mixin.access.IChunkTicketManager;
import com.ishland.c2me.base.mixin.access.IThreadedAnvilChunkStorage;
import com.ishland.c2me.notickvd.common.Config;
import com.ishland.c2me.notickvd.common.NoTickSystem;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import java.util.Comparator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkTracker;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import org.slf4j.Logger;

public class PlayerNoTickDistanceMap
extends ChunkTracker {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final TicketType<ChunkPos> TICKET_TYPE = TicketType.m_9462_((String)"c2me_no_tick_vd", Comparator.comparingLong(ChunkPos::m_45588_));
    private final LongSet sourceChunks = new LongOpenHashSet();
    private final Long2IntOpenHashMap distanceFromNearestPlayer = new Long2IntOpenHashMap();
    private final DynamicPriorityQueue<ChunkPos> pendingTicketAdds = new DynamicPriorityQueue(251);
    private final LongOpenHashSet pendingTicketRemoves = new LongOpenHashSet();
    private final LongOpenHashSet managedChunkTickets = new LongOpenHashSet();
    private final ReferenceArrayList<CompletableFuture<Void>> chunkLoadFutures = new ReferenceArrayList();
    private final DistanceManager chunkTicketManager;
    private final NoTickSystem noTickSystem;
    private volatile int viewDistance;
    private volatile int pendingTicketUpdatesCount = 0;
    private boolean hasPendingTicketUpdatesAsync = false;

    public PlayerNoTickDistanceMap(DistanceManager chunkTicketManager, NoTickSystem noTickSystem) {
        super(251, 16, 256);
        this.chunkTicketManager = chunkTicketManager;
        this.noTickSystem = noTickSystem;
        this.distanceFromNearestPlayer.defaultReturnValue(251);
        this.setViewDistance(12);
    }

    protected int m_7031_(long chunkPos) {
        ObjectSet players = (ObjectSet)((IChunkTicketManager)this.chunkTicketManager).getPlayersByChunkPos().get(chunkPos);
        return players != null && !players.isEmpty() ? 249 - this.viewDistance : Integer.MAX_VALUE;
    }

    protected int m_6172_(long chunkPos) {
        return this.distanceFromNearestPlayer.get(chunkPos);
    }

    protected void m_7351_(long chunkPos, int level) {
        if (level > 249) {
            if (this.distanceFromNearestPlayer.containsKey(chunkPos)) {
                this.pendingTicketRemoves.add(chunkPos);
                this.pendingTicketAdds.remove((Object)new ChunkPos(chunkPos));
                this.distanceFromNearestPlayer.remove(chunkPos);
            }
        } else {
            if (!this.distanceFromNearestPlayer.containsKey(chunkPos)) {
                this.pendingTicketRemoves.remove(chunkPos);
                this.pendingTicketAdds.enqueue((Object)new ChunkPos(chunkPos), level);
            }
            this.pendingTicketAdds.changePriority((Object)new ChunkPos(chunkPos), level);
            this.distanceFromNearestPlayer.put(chunkPos, level);
        }
    }

    public void addSource(ChunkPos chunkPos) {
        this.m_140715_(chunkPos.m_45588_(), 249 - this.viewDistance, true);
        this.sourceChunks.add(chunkPos.m_45588_());
    }

    public void removeSource(ChunkPos chunkPos) {
        this.m_140715_(chunkPos.m_45588_(), Integer.MAX_VALUE, false);
        this.sourceChunks.remove(chunkPos.m_45588_());
    }

    public boolean update() {
        boolean hasUpdates = this.m_75588_(Integer.MAX_VALUE) != Integer.MAX_VALUE;
        this.pendingTicketUpdatesCount = this.pendingTicketAdds.size() + this.pendingTicketRemoves.size();
        return hasUpdates;
    }

    boolean runPendingTicketUpdates(ChunkMap tacs) {
        boolean hasUpdatesNow = this.runPendingTicketUpdatesInternal(tacs);
        boolean hasUpdatesEarlier = this.hasPendingTicketUpdatesAsync;
        this.hasPendingTicketUpdatesAsync = false;
        return hasUpdatesNow || hasUpdatesEarlier;
    }

    private boolean runPendingTicketUpdatesInternal(ChunkMap tacs) {
        ChunkPos pos;
        boolean hasUpdates = false;
        LongIterator it = this.pendingTicketRemoves.longIterator();
        while (it.hasNext()) {
            long chunkPos = it.nextLong();
            if (!this.managedChunkTickets.remove(chunkPos)) continue;
            this.removeTicket0(new ChunkPos(chunkPos));
            hasUpdates = true;
        }
        this.pendingTicketRemoves.clear();
        this.chunkLoadFutures.removeIf(CompletableFuture::isDone);
        while (this.chunkLoadFutures.size() < Config.maxConcurrentChunkLoads && (pos = (ChunkPos)this.pendingTicketAdds.dequeue()) != null) {
            if (!this.managedChunkTickets.add(pos.m_45588_())) continue;
            CompletableFuture<Void> ticketFuture = this.addTicket0(pos);
            this.chunkLoadFutures.add(this.getChunkLoadFuture(tacs, pos, ticketFuture));
            hasUpdates = true;
        }
        this.pendingTicketUpdatesCount = this.pendingTicketAdds.size() + this.pendingTicketRemoves.size();
        return hasUpdates;
    }

    private void removeTicket0(ChunkPos pos) {
        this.noTickSystem.mainBeforeTicketTicks.add(() -> this.chunkTicketManager.m_140823_(TICKET_TYPE, pos, 33, (Object)pos));
    }

    private CompletableFuture<Void> addTicket0(ChunkPos pos) {
        return CompletableFuture.runAsync(() -> this.chunkTicketManager.m_140792_(TICKET_TYPE, pos, 33, (Object)pos), this.noTickSystem.mainBeforeTicketTicks::add);
    }

    private CompletableFuture<Void> getChunkLoadFuture(ChunkMap tacs, ChunkPos pos, CompletableFuture<Void> ticketFuture) {
        CompletionStage future = ticketFuture.thenComposeAsync(unused -> {
            ChunkHolder holder = (ChunkHolder)((IThreadedAnvilChunkStorage)tacs).getCurrentChunkHolders().get(pos.m_45588_());
            if (holder == null) {
                return CompletableFuture.completedFuture(null);
            }
            return ((CompletableFuture)holder.m_140082_().exceptionally(unused1 -> null)).thenAccept(unused1 -> {});
        }, this.noTickSystem.mainAfterTicketTicks::add);
        ((CompletableFuture)future).thenRunAsync(() -> this.lambda$getChunkLoadFuture$5((CompletableFuture)future, tacs), this.noTickSystem.executor);
        return future;
    }

    public void setViewDistance(int viewDistance) {
        this.viewDistance = Mth.m_14045_((int)viewDistance, (int)3, (int)249);
        this.sourceChunks.forEach(value -> {
            this.removeSource(new ChunkPos(value));
            this.addSource(new ChunkPos(value));
        });
    }

    public int getPendingTicketUpdatesCount() {
        return this.pendingTicketUpdatesCount;
    }

    public LongSet getChunks() {
        return this.managedChunkTickets;
    }

    private /* synthetic */ void lambda$getChunkLoadFuture$5(CompletableFuture future, ChunkMap tacs) {
        this.chunkLoadFutures.remove((Object)future);
        boolean hasUpdates = this.runPendingTicketUpdatesInternal(tacs);
        if (hasUpdates) {
            this.hasPendingTicketUpdatesAsync = true;
        }
    }
}

