/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.notickvd.common;

import com.ishland.c2me.base.mixin.access.IChunkTicket;
import com.ishland.c2me.notickvd.common.PlayerNoTickDistanceMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import net.minecraft.server.level.ChunkTracker;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.Ticket;
import net.minecraft.util.SortedArraySet;

public class NormalTicketDistanceMap
extends ChunkTracker {
    private final DistanceManager chunkTicketManager;
    private final Long2IntOpenHashMap distanceMap = new Long2IntOpenHashMap();
    private final Long2ObjectOpenHashMap<SortedArraySet<Ticket<?>>> ticketsByPosition = new Long2ObjectOpenHashMap();

    public NormalTicketDistanceMap(DistanceManager chunkTicketManager) {
        super(35, 16, 256);
        this.chunkTicketManager = chunkTicketManager;
        this.distanceMap.defaultReturnValue(35);
    }

    protected int m_7031_(long id) {
        SortedArraySet sortedArraySet = (SortedArraySet)this.ticketsByPosition.get(id);
        if (sortedArraySet != null) {
            if (sortedArraySet.isEmpty()) {
                return Integer.MAX_VALUE;
            }
            for (Ticket next : sortedArraySet) {
                if (next.m_9428_() == PlayerNoTickDistanceMap.TICKET_TYPE) continue;
                return next.m_9433_();
            }
        }
        return Integer.MAX_VALUE;
    }

    protected int m_6172_(long id) {
        return this.distanceMap.get(id);
    }

    protected void m_7351_(long id, int level) {
        if (level > 33) {
            this.distanceMap.remove(id);
        } else {
            this.distanceMap.put(id, level);
        }
    }

    private static int getLevel(SortedArraySet<Ticket<?>> sortedArraySet) {
        return !sortedArraySet.isEmpty() ? ((Ticket)sortedArraySet.m_14262_()).m_9433_() : Integer.MAX_VALUE;
    }

    public void addTicket(long position, Ticket<?> ticket) {
        if (ticket.m_9428_() == PlayerNoTickDistanceMap.TICKET_TYPE) {
            return;
        }
        SortedArraySet<Ticket<?>> sortedArraySet = this.getTicketSet(position);
        int i = NormalTicketDistanceMap.getLevel(sortedArraySet);
        sortedArraySet.add(ticket);
        if (ticket.m_9433_() < i) {
            this.m_140715_(position, ticket.m_9433_(), true);
        }
    }

    public void removeTicket(long pos, Ticket<?> ticket) {
        if (ticket.m_9428_() == PlayerNoTickDistanceMap.TICKET_TYPE) {
            return;
        }
        SortedArraySet<Ticket<?>> sortedArraySet = this.getTicketSet(pos);
        sortedArraySet.remove(ticket);
        if (sortedArraySet.isEmpty()) {
            this.ticketsByPosition.remove(pos);
        }
        this.m_140715_(pos, NormalTicketDistanceMap.getLevel(sortedArraySet), false);
    }

    public void purge(long age) {
        ObjectIterator iterator = this.ticketsByPosition.long2ObjectEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)iterator.next();
            boolean isModified = ((SortedArraySet)entry.getValue()).removeIf(chunkTicket -> ((IChunkTicket)chunkTicket).invokeIsExpired(age));
            if (isModified) {
                this.m_140715_(entry.getLongKey(), NormalTicketDistanceMap.getLevel((SortedArraySet)entry.getValue()), false);
            }
            if (!((SortedArraySet)entry.getValue()).isEmpty()) continue;
            iterator.remove();
        }
    }

    public SortedArraySet<Ticket<?>> getTicketSet(long pos) {
        return (SortedArraySet)this.ticketsByPosition.computeIfAbsent(pos, l -> SortedArraySet.m_14246_((int)4));
    }

    public boolean update() {
        return Integer.MAX_VALUE - this.m_75588_(Integer.MAX_VALUE) != 0;
    }

    public LongSet getChunks() {
        return this.distanceMap.keySet();
    }
}

