/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.anvilrepairing;

import net.minecraft.ResourceLocationException;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class AnvilRepairCommon {
    public static final String MODID = "anvilrepairing";
    private static final ResourceLocation ADVANCEMENT_ID = new ResourceLocation("anvilrepairing", "story/repair");
    public static final TagKey<Item> ANVIL_REPAIR_ITEMS = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("anvilrepairing", "anvil_repair_items"));

    public static InteractionResult attemptAnvilRepair(Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        BlockPos pos;
        BlockState blockState;
        if (!level.f_46443_ && !player.m_5833_() && AnvilRepairCommon.isRepairable(blockState = level.m_8055_(pos = hitResult.m_82425_())) && player.m_21120_(hand).m_204117_(ANVIL_REPAIR_ITEMS)) {
            if (!player.m_150110_().f_35937_) {
                player.m_21120_(hand).m_41774_(1);
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                AnvilRepairCommon.awardAdvancement(serverPlayer, ADVANCEMENT_ID);
            }
            AnvilRepairCommon.repairAnvil(level, pos, blockState.m_60734_(), (Direction)blockState.m_61143_((Property)AnvilBlock.f_48764_));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private static boolean isRepairable(BlockState state) {
        return state.m_60713_(Blocks.f_50323_) || state.m_60713_(Blocks.f_50324_);
    }

    private static void repairAnvil(Level level, BlockPos pos, Block block, Direction direction) {
        if (block == Blocks.f_50323_) {
            level.m_7731_(pos, (BlockState)Blocks.f_50322_.m_49966_().m_61124_((Property)AnvilBlock.f_48764_, (Comparable)direction), 2);
            level.m_46796_(1030, pos, 0);
        } else if (block == Blocks.f_50324_) {
            level.m_7731_(pos, (BlockState)Blocks.f_50323_.m_49966_().m_61124_((Property)AnvilBlock.f_48764_, (Comparable)direction), 2);
            level.m_46796_(1030, pos, 0);
        }
    }

    private static void awardAdvancement(ServerPlayer player, ResourceLocation advancementId) {
        Advancement toGrant = player.m_20194_().m_129889_().m_136041_(advancementId);
        if (toGrant != null) {
            AdvancementProgress progress = player.m_8960_().m_135996_(toGrant);
            if (!progress.m_8193_()) {
                for (String remainingCriteria : progress.m_8219_()) {
                    player.m_8960_().m_135988_(toGrant, remainingCriteria);
                }
            }
        } else {
            throw new ResourceLocationException("No advancement found for ID: " + advancementId);
        }
    }
}

