/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.customvillagertrades.forge;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.registries.ForgeRegistries;
import uk.co.dotcode.customvillagertrades.TradeUtil;

public class TradeUtilImpl {
    public static List<VillagerProfession> getAllProfessions() {
        return ForgeRegistries.VILLAGER_PROFESSIONS.getValues().stream().collect(Collectors.toList());
    }

    public static VillagerProfession getProfessionFromKey(String professionKey) {
        Object actualKey = professionKey;
        if (!professionKey.contains(":")) {
            actualKey = "minecraft:" + professionKey;
        }
        return (VillagerProfession)ForgeRegistries.VILLAGER_PROFESSIONS.getValue(TradeUtil.getResourceLocation((String)actualKey));
    }

    public static String getKeyFromProfession(VillagerProfession profession) {
        return ForgeRegistries.VILLAGER_PROFESSIONS.getKey((Object)profession).toString();
    }

    public static Item getItemFromKey(String itemKey) {
        return (Item)ForgeRegistries.ITEMS.getValue(TradeUtil.getResourceLocation(itemKey));
    }

    public static Enchantment getEnchantmentFromKey(String enchantmentKey) {
        return (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(TradeUtil.getResourceLocation(enchantmentKey));
    }

    public static Potion getPotionFromKey(String potionKey) {
        return (Potion)ForgeRegistries.POTIONS.getValue(TradeUtil.getResourceLocation(potionKey));
    }

    public static MobEffect getEffectFromKey(String effectKey) {
        return (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(TradeUtil.getResourceLocation(effectKey));
    }

    public static List<Potion> getRegisteredPotions() {
        return ForgeRegistries.POTIONS.getValues().stream().collect(Collectors.toList());
    }

    public static List<MobEffect> getRegisteredMobEffects() {
        return ForgeRegistries.MOB_EFFECTS.getValues().stream().collect(Collectors.toList());
    }

    public static List<Enchantment> getRegisteredEnchantments() {
        return ForgeRegistries.ENCHANTMENTS.getValues().stream().collect(Collectors.toList());
    }

    public static ResourceLocation getRegistryNameItem(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item);
    }

    public static ResourceLocation getPotionKey(Potion potion) {
        return ForgeRegistries.POTIONS.getKey((Object)potion);
    }

    public static ResourceLocation getRegistryNameEffect(MobEffect effect) {
        return ForgeRegistries.MOB_EFFECTS.getKey((Object)effect);
    }

    public static ResourceLocation getRegistryNameEnchantment(Enchantment enchantment) {
        return ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment);
    }
}

