/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.spells.fire;

import com.github.L_Ender.cataclysm.init.ModEntities;
import com.github.L_Ender.cataclysm.init.ModParticle;
import com.github.L_Ender.cataclysm.init.ModSounds;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.CameraShakeData;
import io.redspace.ironsspellbooks.api.util.CameraShakeManager;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class LavaBombSpell
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("traveloptics", "lava_bomb");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.EPIC).setSchoolResource(SchoolRegistry.FIRE_RESOURCE).setMaxLevel(3).setCooldownSeconds(18.0).build();

    public LavaBombSpell() {
        this.baseManaCost = 40;
        this.manaCostPerLevel = 20;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 50;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public AnimationHolder getCastStartAnimation() {
        return SpellAnimations.CHARGE_SPIT_ANIMATION;
    }

    public AnimationHolder getCastFinishAnimation() {
        return SpellAnimations.SPIT_FINISH_ANIMATION;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)ModSounds.MONSTROSITYGROWL.get());
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)ModSounds.MONSTROSITYSHOOT.get());
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        int projectileCount = (int)this.getProjectileCount(spellLevel, caster);
        double motionScale = this.getMotionScale();
        return List.of(Component.m_237110_((String)"ui.traveloptics.lava_bomb_projectile_count", (Object[])new Object[]{projectileCount}), Component.m_237110_((String)"ui.traveloptics.motion_scale", (Object[])new Object[]{motionScale}), Component.m_237113_((String)"\u00a79T.O Magic 'n Extras"));
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
        if (!level.m_5776_()) {
            int projectileCount = (int)this.getProjectileCount(spellLevel, entity);
            double angleBetween = projectileCount > 1 ? 0.7853981633974483 / (double)(projectileCount - 1) : 0.0;
            for (int i = 0; i < projectileCount; ++i) {
                double angle = projectileCount > 1 ? -0.39269908169872414 + angleBetween * (double)i : 0.0;
                Vec3 lookVec = entity.m_20154_();
                double x = lookVec.f_82479_ * Math.cos(angle) - lookVec.f_82481_ * Math.sin(angle);
                double z = lookVec.f_82479_ * Math.sin(angle) + lookVec.f_82481_ * Math.cos(angle);
                double motionScale = this.getMotionScale();
                Vec3 motion = new Vec3(x, lookVec.f_82480_, z).m_82541_().m_82490_(motionScale);
                EntityType entityType = (EntityType)ModEntities.LAVA_BOMB.get();
                Projectile projectile = (Projectile)entityType.m_20615_(level);
                if (projectile == null) continue;
                projectile.m_7678_(entity.m_20185_(), entity.m_20186_() + 1.5, entity.m_20189_(), 0.0f, 0.0f);
                projectile.m_20334_(motion.m_7096_(), motion.m_7098_(), motion.m_7094_());
                CameraShakeManager.addCameraShake((CameraShakeData)new CameraShakeData(entity.m_9236_(), 18, entity.m_20182_(), 25.0f));
                level.m_7967_((Entity)projectile);
            }
            int radius = 32;
            BlockPos pos = entity.m_20183_();
            int posX = pos.m_123341_();
            int posY = pos.m_123342_();
            int posZ = pos.m_123343_();
            int absorbedCount = 0;
            int maxAbsorbed = (int)this.getProjectileCount(spellLevel, entity);
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dy = -radius; dy <= radius; ++dy) {
                    for (int dz = -radius; dz <= radius && absorbedCount < maxAbsorbed; ++dz) {
                        BlockPos blockPos = new BlockPos(posX + dx, posY + dy, posZ + dz);
                        BlockState state = level.m_8055_(blockPos);
                        FluidState fluidState = level.m_6425_(blockPos);
                        Fluid fluid = fluidState.m_76152_();
                        if (fluid != Fluids.f_76195_ || !fluidState.m_76170_()) continue;
                        level.m_46597_(blockPos, Blocks.f_50016_.m_49966_());
                        ++absorbedCount;
                    }
                }
                if (absorbedCount >= maxAbsorbed) break;
            }
            Vec3 lookVec = entity.m_20154_();
            double offsetDistance = 1.0;
            Vec3 handPosition = new Vec3(entity.m_20185_(), entity.m_20186_() + (double)entity.m_20192_() - 0.5, entity.m_20189_());
            Vec3 offsetPosition = handPosition.m_82549_(lookVec.m_82490_(offsetDistance));
            ParticleOptions particleType = (ParticleOptions)ModParticle.TRAP_FLAME.get();
            MagicManager.spawnParticles((Level)level, (ParticleOptions)particleType, (double)offsetPosition.m_7096_(), (double)offsetPosition.m_7098_(), (double)offsetPosition.m_7094_(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
        }
    }

    private float getProjectileCount(int spellLevel, LivingEntity caster) {
        return this.getSpellPower(spellLevel, (Entity)caster);
    }

    private double getMotionScale() {
        return 1.0;
    }
}

