/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.spells.ender;

import com.gametechbc.traveloptics.api.particle.OrbitingParticleManager;
import com.gametechbc.traveloptics.api.spells.AbstractUniqueSpell;
import com.gametechbc.traveloptics.api.utils.TOGeneralUtils;
import com.gametechbc.traveloptics.entity.summons.SummonedVoidTome;
import com.gametechbc.traveloptics.init.TravelopticsEntities;
import com.gametechbc.traveloptics.init.TravelopticsSounds;
import com.gametechbc.traveloptics.util.TravelopticsParticleHelper;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastDataSerializable;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.CameraShakeData;
import io.redspace.ironsspellbooks.api.util.CameraShakeManager;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.capabilities.magic.PlayerRecasts;
import io.redspace.ironsspellbooks.capabilities.magic.RecastInstance;
import io.redspace.ironsspellbooks.capabilities.magic.RecastResult;
import io.redspace.ironsspellbooks.capabilities.magic.SummonManager;
import io.redspace.ironsspellbooks.capabilities.magic.SummonedEntitiesCastData;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;

@AutoSpellConfig
public class ConjureVoidTomesSpell
extends AbstractUniqueSpell {
    private final ResourceLocation spellId = new ResourceLocation("traveloptics", "conjure_void_tomes");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.UNCOMMON).setSchoolResource(SchoolRegistry.ENDER_RESOURCE).setMaxLevel(5).setCooldownSeconds(150.0).build();

    public ConjureVoidTomesSpell() {
        this.manaCostPerLevel = 30;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 50;
        this.baseManaCost = 30;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)TravelopticsSounds.FLYING_BOOK_HURT.get());
    }

    public void onServerCastTick(Level level, int spellLevel, LivingEntity entity, @Nullable MagicData playerMagicData) {
        OrbitingParticleManager.spawnOrbitingParticle((Entity)entity, TravelopticsParticleHelper.LIGHT_PURPLE_GLOWING_ENCHANT, 8.0f, 1.5, 1.5, OrbitingParticleManager.OrbitDirection.CLOCKWISE, false, true);
        super.onServerCastTick(level, spellLevel, entity, playerMagicData);
    }

    public int getRecastCount(int spellLevel, @Nullable LivingEntity entity) {
        return 2;
    }

    public void onRecastFinished(ServerPlayer serverPlayer, RecastInstance recastInstance, RecastResult recastResult, ICastDataSerializable castDataSerializable) {
        if (SummonManager.recastFinishedHelper((ServerPlayer)serverPlayer, (RecastInstance)recastInstance, (RecastResult)recastResult, (ICastDataSerializable)castDataSerializable)) {
            super.onRecastFinished(serverPlayer, recastInstance, recastResult, castDataSerializable);
        }
    }

    public ICastDataSerializable getEmptyCastData() {
        return new SummonedEntitiesCastData();
    }

    public void onCast(Level world, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        PlayerRecasts recasts = playerMagicData.getPlayerRecasts();
        if (!recasts.hasRecastForSpell(this.getSpellId())) {
            SummonedEntitiesCastData summonedEntitiesCastData = new SummonedEntitiesCastData();
            int summonTime = 12000;
            int tomeCount = this.getTomeCount();
            double radius = 5.0;
            double angleIncrement = Math.PI * 2 / (double)tomeCount;
            for (int i = 0; i < tomeCount; ++i) {
                double angle = (double)i * angleIncrement;
                double xOffset = radius * Math.cos(angle);
                double zOffset = radius * Math.sin(angle);
                SummonedVoidTome voidTome = new SummonedVoidTome(world, entity);
                voidTome.m_6034_(entity.m_20185_() + xOffset, entity.m_20186_() + 10.0, entity.m_20189_() + zOffset);
                voidTome.m_21204_().m_22146_((Attribute)AttributeRegistry.SPELL_POWER.get()).m_22100_((double)this.getTomeDamage(spellLevel, entity));
                voidTome.m_21204_().m_22146_(Attributes.f_22276_).m_22100_((double)this.getTomeHealth(spellLevel));
                voidTome.m_21153_(voidTome.m_21233_());
                world.m_7967_((Entity)voidTome);
                SummonManager.initSummon((Entity)entity, (Entity)voidTome, (int)summonTime, (SummonedEntitiesCastData)summonedEntitiesCastData);
                MagicManager.spawnParticles((Level)world, (ParticleOptions)TravelopticsParticleHelper.LIGHT_PURPLE_GLOWING_ENCHANT, (double)(entity.m_20185_() + xOffset), (double)(entity.m_20186_() + 10.0), (double)(entity.m_20189_() + zOffset), (int)30, (double)0.0, (double)0.0, (double)0.0, (double)0.03, (boolean)false);
            }
            RecastInstance recastInstance = new RecastInstance(this.getSpellId(), spellLevel, this.getRecastCount(spellLevel, entity), summonTime, castSource, (ICastDataSerializable)summonedEntitiesCastData);
            recasts.addRecast(recastInstance, playerMagicData);
            CameraShakeManager.addCameraShake((CameraShakeData)new CameraShakeData(entity.m_9236_(), 15, entity.m_20182_(), 25.0f));
        }
        super.onCast(world, spellLevel, entity, castSource, playerMagicData);
    }

    private int getTomeCount() {
        return 3;
    }

    private float getTomeHealth(int spellLevel) {
        return 15 + spellLevel * 5;
    }

    private float getTomeDamage(int spellLevel, LivingEntity caster) {
        float baseSpellPower = this.getSpellPower(spellLevel, (Entity)caster) * 0.2f;
        double summonDamageMultiplier = caster.m_21204_().m_22171_((Attribute)AttributeRegistry.SUMMON_DAMAGE.get()) ? caster.m_21133_((Attribute)AttributeRegistry.SUMMON_DAMAGE.get()) : 1.0;
        return (float)((double)baseSpellPower * summonDamageMultiplier);
    }

    private String getTomeDamageText(int spellLevel, @Nullable LivingEntity caster) {
        float spellPower = 0.0f;
        double summonDamageMultiplier = 1.0;
        if (caster != null) {
            spellPower += this.getSpellPower(spellLevel, (Entity)caster) * 0.2f;
            if (caster.m_21204_().m_22171_((Attribute)AttributeRegistry.SUMMON_DAMAGE.get())) {
                summonDamageMultiplier = caster.m_21133_((Attribute)AttributeRegistry.SUMMON_DAMAGE.get());
            }
        }
        float totalScaling = spellPower * (float)summonDamageMultiplier;
        String percent = Utils.stringTruncation((double)(totalScaling * 100.0f), (int)1);
        return percent + "%";
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return TOGeneralUtils.buildSummonInfo(List.of((EntityType)TravelopticsEntities.VOID_TOME_ENTITY.get()), false, this.getTomeCount(), Component.m_237110_((String)"ui.traveloptics.hp", (Object[])new Object[]{Float.valueOf(this.getTomeHealth(spellLevel))}), Component.m_237110_((String)"ui.traveloptics.spell_power", (Object[])new Object[]{this.getTomeDamageText(spellLevel, caster)}), Component.m_237113_((String)"\u00a79T.O Magic 'n Extras"));
    }
}

