/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.spells.blood;

import com.gametechbc.traveloptics.api.particle.CylinderParticleManager;
import com.gametechbc.traveloptics.api.particle.ParticleDirection;
import com.gametechbc.traveloptics.api.utils.TOGeneralUtils;
import com.gametechbc.traveloptics.entity.summons.SummonedVesper;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastDataSerializable;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.CameraShakeData;
import io.redspace.ironsspellbooks.api.util.CameraShakeManager;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.capabilities.magic.PlayerRecasts;
import io.redspace.ironsspellbooks.capabilities.magic.RecastInstance;
import io.redspace.ironsspellbooks.capabilities.magic.RecastResult;
import io.redspace.ironsspellbooks.capabilities.magic.SummonManager;
import io.redspace.ironsspellbooks.capabilities.magic.SummonedEntitiesCastData;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;

@AutoSpellConfig
public class NocturnalSwarmSpell
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("traveloptics", "nocturnal_swarm");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.COMMON).setSchoolResource(SchoolRegistry.BLOOD_RESOURCE).setMaxLevel(8).setCooldownSeconds(150.0).build();

    public NocturnalSwarmSpell() {
        this.manaCostPerLevel = 15;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 35;
        this.baseManaCost = 45;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)ACSoundRegistry.VESPER_SCREAM.get());
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)ACSoundRegistry.VESPER_IDLE.get());
    }

    public void onServerCastTick(Level level, int spellLevel, LivingEntity entity, @Nullable MagicData playerMagicData) {
        CylinderParticleManager.spawnParticles(level, (Entity)entity, 3, ParticleHelper.BLOOD, ParticleDirection.UPWARD, 2.0, 2.0, -1.0);
        super.onServerCastTick(level, spellLevel, entity, playerMagicData);
    }

    public int getRecastCount(int spellLevel, @Nullable LivingEntity entity) {
        return 2;
    }

    public void onRecastFinished(ServerPlayer serverPlayer, RecastInstance recastInstance, RecastResult recastResult, ICastDataSerializable castDataSerializable) {
        if (SummonManager.recastFinishedHelper((ServerPlayer)serverPlayer, (RecastInstance)recastInstance, (RecastResult)recastResult, (ICastDataSerializable)castDataSerializable)) {
            super.onRecastFinished(serverPlayer, recastInstance, recastResult, castDataSerializable);
        }
    }

    public ICastDataSerializable getEmptyCastData() {
        return new SummonedEntitiesCastData();
    }

    public void onCast(Level world, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        PlayerRecasts recasts = playerMagicData.getPlayerRecasts();
        if (!recasts.hasRecastForSpell(this.getSpellId())) {
            SummonedEntitiesCastData summonedEntitiesCastData = new SummonedEntitiesCastData();
            int summonTime = 12000;
            int vesperCount = this.getVesperCount(spellLevel);
            double radius = 5.0;
            double angleIncrement = Math.PI * 2 / (double)vesperCount;
            for (int i = 0; i < vesperCount; ++i) {
                double angle = (double)i * angleIncrement;
                double xOffset = radius * Math.cos(angle);
                double zOffset = radius * Math.sin(angle);
                SummonedVesper vesper = new SummonedVesper(world, entity);
                vesper.m_6034_(entity.m_20185_() + xOffset, entity.m_20186_() + 10.0, entity.m_20189_() + zOffset);
                vesper.m_21204_().m_22146_(Attributes.f_22281_).m_22100_((double)this.getVesperDamage(spellLevel, entity));
                vesper.m_21204_().m_22146_(Attributes.f_22276_).m_22100_((double)this.getVesperHealth(spellLevel));
                vesper.m_21153_(vesper.m_21233_());
                world.m_7967_((Entity)vesper);
                SummonManager.initSummon((Entity)entity, (Entity)vesper, (int)summonTime, (SummonedEntitiesCastData)summonedEntitiesCastData);
                MagicManager.spawnParticles((Level)world, (ParticleOptions)ParticleHelper.BLOOD, (double)(entity.m_20185_() + xOffset), (double)(entity.m_20186_() + 10.0), (double)(entity.m_20189_() + zOffset), (int)30, (double)0.0, (double)0.0, (double)0.0, (double)0.03, (boolean)false);
            }
            RecastInstance recastInstance = new RecastInstance(this.getSpellId(), spellLevel, this.getRecastCount(spellLevel, entity), summonTime, castSource, (ICastDataSerializable)summonedEntitiesCastData);
            recasts.addRecast(recastInstance, playerMagicData);
            CameraShakeManager.addCameraShake((CameraShakeData)new CameraShakeData(15, entity.m_20182_(), 25.0f));
        }
        super.onCast(world, spellLevel, entity, castSource, playerMagicData);
    }

    private int getVesperCount(int spellLevel) {
        return spellLevel + 2;
    }

    private float getVesperHealth(int spellLevel) {
        return 3.0f + (float)spellLevel * 1.5f;
    }

    private float getVesperDamage(int spellLevel, LivingEntity caster) {
        float baseDamage = 1.0f + this.getSpellPower(spellLevel, (Entity)caster) * 0.5f;
        double summonedDamageMultiplier = 1.0;
        if (caster.m_21204_().m_22171_((Attribute)AttributeRegistry.SUMMON_DAMAGE.get())) {
            summonedDamageMultiplier = caster.m_21133_((Attribute)AttributeRegistry.SUMMON_DAMAGE.get());
        }
        return (float)((double)baseDamage * summonedDamageMultiplier);
    }

    private String getVesperDamageText(int spellLevel, LivingEntity caster) {
        if (caster != null) {
            float baseDamage = 1.0f + this.getSpellPower(spellLevel, (Entity)caster) * 0.5f;
            double summonedDamageMultiplier = caster.m_21204_().m_22171_((Attribute)AttributeRegistry.SUMMON_DAMAGE.get()) ? caster.m_21133_((Attribute)AttributeRegistry.SUMMON_DAMAGE.get()) : 1.0;
            float finalDamage = (float)((double)baseDamage * summonedDamageMultiplier);
            String baseDamageText = Utils.stringTruncation((double)baseDamage, (int)1);
            String finalDamageText = Utils.stringTruncation((double)finalDamage, (int)1);
            if (summonedDamageMultiplier > 1.0) {
                return String.format("%s -> %s", baseDamageText, finalDamageText);
            }
            return baseDamageText;
        }
        return "" + this.getSpellPower(spellLevel, (Entity)caster);
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return TOGeneralUtils.buildSummonInfo(List.of((EntityType)ACEntityRegistry.VESPER.get()), false, this.getVesperCount(spellLevel), Component.m_237110_((String)"ui.traveloptics.hp", (Object[])new Object[]{Float.valueOf(this.getVesperHealth(spellLevel))}), Component.m_237110_((String)"ui.traveloptics.damage", (Object[])new Object[]{this.getVesperDamageText(spellLevel, caster)}), Component.m_237113_((String)"\u00a79T.O Magic 'n Extras"));
    }
}

