/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.spells.aqua;

import com.gametechbc.traveloptics.api.init.TravelopticsSchools;
import com.gametechbc.traveloptics.api.utils.TOCurioUtils;
import com.gametechbc.traveloptics.api.utils.TOGeneralUtils;
import com.gametechbc.traveloptics.entity.misc.TOScreenShakeEntity;
import com.gametechbc.traveloptics.entity.projectiles.overflow.BrinePoolEntity;
import com.gametechbc.traveloptics.entity.projectiles.overflow.FloodPoolEntity;
import com.gametechbc.traveloptics.init.TravelopticsItems;
import com.gametechbc.traveloptics.init.TravelopticsSounds;
import com.gametechbc.traveloptics.spells.TravelopticsSpellAnimations;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

@AutoSpellConfig
public class OverflowSpell
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"traveloptics", (String)"overflow");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.UNCOMMON).setSchoolResource(TravelopticsSchools.AQUA_RESOURCE).setMaxLevel(4).setCooldownSeconds(60.0).build();

    public OverflowSpell() {
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 0;
        this.baseManaCost = 40;
        this.manaCostPerLevel = 30;
        this.castTime = 17;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)TravelopticsSounds.AQUA_MISSILES_CAST.get());
    }

    public AnimationHolder getCastStartAnimation() {
        return TravelopticsSpellAnimations.OVERFLOW_CHARGE;
    }

    public AnimationHolder getCastFinishAnimation() {
        return TravelopticsSpellAnimations.OVERFLOW_CAST;
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        boolean hasRing = TOCurioUtils.getWearingCurio(entity, (Item)TravelopticsItems.SALTED_DEPTHS_RING.get());
        if (hasRing) {
            BrinePoolEntity floodPool = new BrinePoolEntity(level);
            floodPool.m_5602_((Entity)entity);
            floodPool.setDuration(this.getDuration(spellLevel));
            floodPool.setRadius(this.getRadius(spellLevel));
            floodPool.setCircular();
            floodPool.setMinWetAmplifier(this.getMinWetAmplifier(spellLevel, entity));
            floodPool.setMaxWetAmplifier(this.getMaxWetAmplifier(spellLevel, entity));
            floodPool.setDamage(this.getDamage(spellLevel, entity));
            floodPool.m_20219_(entity.m_20182_());
            level.m_7967_((Entity)floodPool);
        } else {
            FloodPoolEntity floodPool = new FloodPoolEntity(level);
            floodPool.m_5602_((Entity)entity);
            floodPool.setDuration(this.getDuration(spellLevel));
            floodPool.setRadius(this.getRadius(spellLevel));
            floodPool.setCircular();
            floodPool.setMinWetAmplifier(this.getMinWetAmplifier(spellLevel, entity));
            floodPool.setMaxWetAmplifier(this.getMaxWetAmplifier(spellLevel, entity));
            floodPool.m_20219_(entity.m_20182_());
            level.m_7967_((Entity)floodPool);
        }
        TOScreenShakeEntity.createScreenShake(level, entity.m_20182_(), this.getRadius(spellLevel), 0.02f, 10, 0, 5, true);
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    private float getDamage(int spellLevel, LivingEntity entity) {
        float baseSpellPower = this.getSpellPower(spellLevel, (Entity)entity);
        float lightningPower = (float)entity.m_21133_((Attribute)AttributeRegistry.LIGHTNING_SPELL_POWER.get());
        float aquaContribution = baseSpellPower * 1.5f;
        float lightningContribution = baseSpellPower * (lightningPower - 1.0f) * 0.75f;
        return 6.0f + aquaContribution + lightningContribution;
    }

    private String getDamageText(int spellLevel, LivingEntity caster) {
        if (caster != null) {
            float baseSpellPower = this.getSpellPower(spellLevel, (Entity)caster);
            float lightningPower = (float)caster.m_21133_((Attribute)AttributeRegistry.LIGHTNING_SPELL_POWER.get());
            float baseDamage = 6.0f + baseSpellPower * 1.5f;
            float lightningBonus = baseSpellPower * (lightningPower - 1.0f) * 0.75f;
            float finalDamage = baseDamage + lightningBonus;
            String baseDamageText = Utils.stringTruncation((double)baseDamage, (int)1);
            String finalDamageText = Utils.stringTruncation((double)finalDamage, (int)1);
            if ((double)lightningPower > 1.0) {
                return String.format("%s -> %s", baseDamageText, finalDamageText);
            }
            return baseDamageText;
        }
        return "" + this.getSpellPower(spellLevel, (Entity)caster);
    }

    public float getRadius(int spellLevel) {
        return 5.0f + (float)spellLevel * 5.0f;
    }

    public int getDuration(int spellLevel) {
        return 200 + spellLevel * 100;
    }

    private int getMinWetAmplifier(int spellLevel, LivingEntity caster) {
        return (int)(1.0f + this.getSpellPower(spellLevel, (Entity)caster) * 2.25f);
    }

    private int getMaxWetAmplifier(int spellLevel, LivingEntity caster) {
        return (int)(3.0f + this.getSpellPower(spellLevel, (Entity)caster) * 6.5f);
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        boolean hasRing = TOCurioUtils.getWearingCurio(caster, (Item)TravelopticsItems.SALTED_DEPTHS_RING.get());
        if (hasRing) {
            return TOGeneralUtils.buildAquaSpellInfoRanged(this.getMinWetAmplifier(spellLevel, caster), this.getMaxWetAmplifier(spellLevel, caster), true, Component.m_237110_((String)"ui.traveloptics.damage", (Object[])new Object[]{this.getDamageText(spellLevel, caster)}), Component.m_237110_((String)"ui.traveloptics.radius", (Object[])new Object[]{Utils.stringTruncation((double)this.getRadius(spellLevel), (int)2)}), Component.m_237110_((String)"ui.traveloptics.duration", (Object[])new Object[]{Utils.timeFromTicks((float)this.getDuration(spellLevel), (int)2)}));
        }
        return TOGeneralUtils.buildAquaSpellInfoRanged(this.getMinWetAmplifier(spellLevel, caster), this.getMaxWetAmplifier(spellLevel, caster), true, Component.m_237110_((String)"ui.traveloptics.radius", (Object[])new Object[]{Utils.stringTruncation((double)this.getRadius(spellLevel), (int)2)}), Component.m_237110_((String)"ui.traveloptics.duration", (Object[])new Object[]{Utils.timeFromTicks((float)this.getDuration(spellLevel), (int)2)}));
    }
}

