/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.item.bossweapon.charged_sands;

import com.gametechbc.traveloptics.config.WeaponConfig;
import com.gametechbc.traveloptics.entity.item.charged_sands.ChargedSandsItemRenderer;
import com.gametechbc.traveloptics.entity.projectiles.lightning_sandstorm_projectile.LightningSandstormPierceProjectileEntity;
import com.gametechbc.traveloptics.init.TravelopticsItems;
import com.gametechbc.traveloptics.item.UnbreakableGeoMagicSword;
import com.github.L_Ender.cataclysm.init.ModItems;
import com.github.L_Ender.cataclysm.items.ILeftClick;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.api.registry.SpellDataRegistryHolder;
import io.redspace.ironsspellbooks.util.ItemPropertiesHelper;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;

public class ChargedSandsItem
extends UnbreakableGeoMagicSword
implements ILeftClick {
    private static ItemDisplayContext transformType;

    public ChargedSandsItem(SpellDataRegistryHolder[] imbuedSpells) {
        super(new Tier(){

            public int m_6609_() {
                return (Integer)WeaponConfig.chargedSandsDurability.get();
            }

            public float m_6624_() {
                return 2.0f;
            }

            public float m_6631_() {
                return -0.0f;
            }

            public int m_6604_() {
                return 1;
            }

            public int m_6601_() {
                return 20;
            }

            public Ingredient m_6282_() {
                return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ModItems.LACRIMA.get())});
            }
        }, 13.0 * (Double)WeaponConfig.chargedSandsDamageMultiplier.get(), -2.6 * (Double)WeaponConfig.chargedSandsAttackSpeedMultiplier.get(), imbuedSpells, Map.of((Attribute)ForgeMod.ENTITY_REACH.get(), new AttributeModifier(UUID.fromString("3a7cd16e-2685-46dd-851f-dc9404c619f1"), "Weapon Modifier", 1.0, AttributeModifier.Operation.ADDITION), (Attribute)AttributeRegistry.LIGHTNING_SPELL_POWER.get(), new AttributeModifier(UUID.fromString("412b5a66-2b43-4c18-ab05-6de0bb4d64d3"), "Weapon Modifier", 0.1 * (Double)WeaponConfig.chargedSandsLightningSpellPowerMultiplier.get(), AttributeModifier.Operation.MULTIPLY_BASE), (Attribute)AttributeRegistry.HOLY_SPELL_POWER.get(), new AttributeModifier(UUID.fromString("412b5a66-2b43-4c18-ab05-6de0bb4d64d3"), "Weapon Modifier", 0.1 * (Double)WeaponConfig.chargedSandsHolySpellPowerMultiplier.get(), AttributeModifier.Operation.MULTIPLY_BASE), (Attribute)AttributeRegistry.MAX_MANA.get(), new AttributeModifier(UUID.fromString("412b5a66-2b43-4c18-ab05-6de0bb4d64d3"), "Weapon Modifier", 0.15 * (Double)WeaponConfig.chargedSandsMaxManaMultiplier.get(), AttributeModifier.Operation.MULTIPLY_BASE)), ItemPropertiesHelper.hidden((int)1).m_41497_(TravelopticsItems.RARITY_SCYLLA));
    }

    private boolean isCharged(Player player, ItemStack stack) {
        return player.m_36403_(0.5f) > 0.9f;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity entity, LivingEntity player) {
        Player player1;
        if (player instanceof Player && this.isCharged(player1 = (Player)player, stack)) {
            this.launchLightningSandstorm(stack, player);
        }
        return true;
    }

    public boolean onLeftClick(ItemStack stack, LivingEntity playerIn) {
        if (stack.m_41720_() instanceof ChargedSandsItem && playerIn.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof ChargedSandsItem && (!(playerIn instanceof Player) || this.isCharged((Player)playerIn, stack))) {
            return this.launchLightningSandstorm(stack, playerIn);
        }
        return false;
    }

    public boolean launchLightningSandstorm(ItemStack stack, LivingEntity playerIn) {
        Level worldIn = playerIn.m_9236_();
        if (!worldIn.f_46443_) {
            float d7 = playerIn.m_146908_();
            float d = playerIn.m_146909_();
            float d1 = -Mth.m_14031_((float)(d7 * ((float)Math.PI / 180))) * Mth.m_14089_((float)(d * ((float)Math.PI / 180)));
            float d2 = -Mth.m_14031_((float)(d * ((float)Math.PI / 180)));
            float d3 = Mth.m_14089_((float)(d7 * ((float)Math.PI / 180))) * Mth.m_14089_((float)(d * ((float)Math.PI / 180)));
            this.spawnProjectiles(worldIn, playerIn, d1, d2, d3);
            return true;
        }
        return false;
    }

    protected void spawnProjectiles(Level world, LivingEntity owner, float dirX, float dirY, float dirZ) {
        double theta = (double)owner.m_146908_() * (Math.PI / 180);
        double vecX = Math.cos(theta += 1.5707963267948966);
        double vecZ = Math.sin(theta);
        double x = owner.m_20185_() + vecX;
        double z = owner.m_20189_() + vecZ;
        LightningSandstormPierceProjectileEntity projectile = new LightningSandstormPierceProjectileEntity(world, owner, dirX, dirY, dirZ, this.getProjectileDamage(owner));
        projectile.m_6034_(x, owner.m_20188_() - 0.5, z);
        projectile.setMaxLife(this.getProjectileLifetime());
        this.configureProjectile(projectile, owner);
        world.m_7967_((Entity)projectile);
    }

    protected float getProjectileDamage(LivingEntity owner) {
        return 6.0f * ((Double)WeaponConfig.chargedSandsArcStormDamageMultiplier.get()).floatValue();
    }

    protected int getProjectileLifetime() {
        return 200;
    }

    protected void configureProjectile(LightningSandstormPierceProjectileEntity projectile, LivingEntity owner) {
        projectile.setHomingEnabled(false);
    }

    @Nullable
    protected LivingEntity getPlayerLookTarget(Level level, LivingEntity living) {
        LivingEntity pointedEntity = null;
        double range = 40.0;
        Vec3 srcVec = living.m_146892_();
        Vec3 lookVec = living.m_20252_(1.0f);
        Vec3 destVec = srcVec.m_82520_(lookVec.f_82479_ * range, lookVec.f_82480_ * range, lookVec.f_82481_ * range);
        float var9 = 2.0f;
        List possibleList = level.m_45933_((Entity)living, living.m_20191_().m_82363_(lookVec.f_82479_ * range, lookVec.f_82480_ * range, lookVec.f_82481_ * range).m_82377_((double)var9, (double)var9, (double)var9));
        double hitDist = 0.0;
        for (Entity possibleEntity : possibleList) {
            double possibleDist;
            if (!(possibleEntity instanceof LivingEntity)) continue;
            AABB collisionBB = possibleEntity.m_20191_().m_82377_(1.0, 1.0, 1.0);
            Optional interceptPos = collisionBB.m_82371_(srcVec, destVec);
            if (collisionBB.m_82390_(srcVec)) {
                if (!(0.0 < hitDist) && hitDist != 0.0) continue;
                pointedEntity = (LivingEntity)possibleEntity;
                hitDist = 0.0;
                continue;
            }
            if (!interceptPos.isPresent() || !((possibleDist = srcVec.m_82554_((Vec3)interceptPos.get())) < hitDist) && hitDist != 0.0) continue;
            pointedEntity = (LivingEntity)possibleEntity;
            hitDist = possibleDist;
        }
        return pointedEntity;
    }

    public void getTransformType(ItemDisplayContext type) {
        transformType = type;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected BlockEntityWithoutLevelRenderer getRenderer() {
        return new ChargedSandsItemRenderer();
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.charged_sands.tooltip").m_130940_(ChatFormatting.GREEN));
        tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.charged_sands.tooltip1"));
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237113_((String)""));
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.weapons.evolution_benefits.tooltip").m_130940_(ChatFormatting.YELLOW));
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.charged_sands.evo_one.inactive.tooltip"));
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.charged_sands.evo_two.inactive.tooltip"));
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.charged_sands.evo_three.inactive.tooltip"));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.weapons.evolution.stars_zero.tooltip"));
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.shift_hold.advanced_tooltips"));
        }
        tooltip.add((Component)Component.m_237113_((String)""));
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }
}

