/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.item.armor;

import com.gametechbc.traveloptics.api.item.armor.IKeybindArmor;
import com.gametechbc.traveloptics.data_manager.CooldownsManager;
import com.gametechbc.traveloptics.data_manager.SwitchManager;
import com.gametechbc.traveloptics.entity.armor.abyssal_hide_armor.AbyssalHideArmorModel;
import com.gametechbc.traveloptics.entity.armor.abyssal_hide_armor.AbyssalHideArmorRenderer;
import com.gametechbc.traveloptics.init.TravelopticsKeybinds;
import com.gametechbc.traveloptics.init.TravelopticsMessages;
import com.gametechbc.traveloptics.init.TravelopticsSounds;
import com.gametechbc.traveloptics.item.TravelopticsArmorMaterials;
import com.gametechbc.traveloptics.item.UnbreakableImbueableArmor;
import com.gametechbc.traveloptics.network.ArmorKeyPacket;
import com.gametechbc.traveloptics.util.TravelopticsKeybindManager;
import com.github.L_Ender.cataclysm.entity.AnimationMonster.BossMonsters.The_Leviathan.Abyss_Orb_Entity;
import com.github.L_Ender.cataclysm.init.ModSounds;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.geckolib.renderer.GeoArmorRenderer;

public class AbyssalHideArmorItem
extends UnbreakableImbueableArmor
implements IKeybindArmor {
    private static final double TRACKING_RANGE = 15.0;
    private static final String ABILITY_ORBITAL_VOID = "orbital_void";
    public static final String COOLDOWN_ORBITAL_VOID = "orbital_void";
    private static final String COOLDOWN_ORBITAL_VOID_TOGGLE = "orbital_void_toggle";
    public static final int COOLDOWN_ORBITAL_VOID_TICKS = 400;
    private static final int COOLDOWN_ORBITAL_VOID_TOGGLE_TICKS = 20;

    public AbyssalHideArmorItem(ArmorItem.Type slot, Item.Properties settings) {
        super(TravelopticsArmorMaterials.ABYSSAL_HIDE, slot, settings);
    }

    @Override
    protected Set<ArmorItem.Type> getImbuableArmorTypes() {
        return Set.of(ArmorItem.Type.CHESTPLATE);
    }

    @Override
    protected Map<ArmorItem.Type, Integer> getMaxSpellSlots() {
        return Map.of(ArmorItem.Type.CHESTPLATE, 1);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, world, entity, slot, selected);
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!this.isWearingFullSet(player)) {
            return;
        }
        ItemStack chestplate = player.m_6844_(ArmorItem.Type.CHESTPLATE.m_266308_());
        if (stack != chestplate || chestplate.m_41720_() != this) {
            return;
        }
        CooldownsManager.tickCooldown(chestplate);
        if (world.f_46443_ && TravelopticsKeybindManager.getClientSidePlayer() == player && TravelopticsKeybindManager.isKeyDown(4)) {
            TravelopticsMessages.sendToServer(new ArmorKeyPacket(EquipmentSlot.CHEST.ordinal(), player.m_19879_(), 4));
            this.onKeyPacket(player, stack, 4);
        }
        if (!world.f_46443_) {
            if (CooldownsManager.getCooldown(chestplate, "orbital_void") > 0) {
                return;
            }
            if (SwitchManager.isEnabled(chestplate, "orbital_void") && (double)player.m_21223_() <= (double)player.m_21233_() * 0.75) {
                this.shootAbyssOrbs(world, (LivingEntity)player);
                world.m_5594_(null, player.m_20183_(), (SoundEvent)TravelopticsSounds.ORBITAL_VOID_PULSE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                CooldownsManager.setCooldown(chestplate, "orbital_void", 400, 400);
            }
        }
    }

    @Override
    public void onKeyPacket(Player player, ItemStack itemStack, int key) {
        ItemStack chestplate = player.m_6844_(EquipmentSlot.CHEST);
        if (chestplate.m_41619_() || chestplate.m_41720_() != this) {
            return;
        }
        if (key == 4) {
            int toggleCooldown = CooldownsManager.getCooldown(chestplate, COOLDOWN_ORBITAL_VOID_TOGGLE);
            if (toggleCooldown > 0) {
                return;
            }
            boolean wasEnabled = SwitchManager.isEnabled(chestplate, "orbital_void");
            SwitchManager.toggleSwitch(chestplate, "orbital_void");
            boolean isNowEnabled = !wasEnabled;
            player.m_9236_().m_5594_(null, player.m_20183_(), (SoundEvent)ModSounds.LEVIATHAN_IDLE.get(), SoundSource.PLAYERS, 1.0f, 0.8f + player.m_9236_().m_213780_().m_188501_() * 0.4f);
            if (isNowEnabled) {
                player.m_5661_((Component)Component.m_237115_((String)"item.traveloptics.abyssal_hide_armor.message.orbital_void_enabled").m_130940_(ChatFormatting.GREEN), true);
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"item.traveloptics.abyssal_hide_armor.message.orbital_void_disabled").m_130940_(ChatFormatting.RED), true);
            }
            CooldownsManager.setCooldown(chestplate, COOLDOWN_ORBITAL_VOID_TOGGLE, 20, 20);
        }
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237110_((String)"item.traveloptics.abyssal_hide_armor.tooltip.orbital_void_keybind", (Object[])new Object[]{TravelopticsKeybinds.KEY_B.m_90863_()}));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.abyssal_hide_armor.tooltip").m_130940_(ChatFormatting.GREEN));
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.abyssal_hide_armor.tooltip1"));
            tooltip.add((Component)Component.m_237115_((String)"item.traveloptics.shift_hold.advanced_tooltips"));
        }
        if (this.f_265916_ == ArmorItem.Type.CHESTPLATE) {
            tooltip.add((Component)Component.m_237113_((String)""));
            boolean isEnabled = SwitchManager.isEnabled(stack, "orbital_void");
            String statusKey = isEnabled ? "enabled" : "disabled";
            tooltip.add((Component)Component.m_237113_((String)"[").m_7220_(TravelopticsKeybinds.KEY_B.m_90863_()).m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237115_((String)("item.traveloptics.abyssal_hide_armor.ability.orbital_void.status." + statusKey))));
        }
        tooltip.add((Component)Component.m_237113_((String)""));
    }

    private float calculateAbyssOrbDamage(LivingEntity entity) {
        float enderSpellPower = (float)entity.m_21133_((Attribute)AttributeRegistry.ENDER_SPELL_POWER.get());
        float eldritchSpellPower = (float)entity.m_21133_((Attribute)AttributeRegistry.ELDRITCH_SPELL_POWER.get());
        return (enderSpellPower + eldritchSpellPower) * 3.0f;
    }

    private void shootAbyssOrbs(Level level, LivingEntity entity) {
        int orbCount = 6;
        float getDamage = this.calculateAbyssOrbDamage(entity);
        double angleBetween = Math.PI * 2 / (double)orbCount;
        for (int i = 0; i < orbCount; ++i) {
            Projectile projectile;
            double angle = angleBetween * (double)i;
            double offsetX = Math.sin(angle) * 6.0;
            double offsetZ = Math.cos(angle) * 6.0;
            double motionScale = 3.0;
            Vec3 motion = new Vec3(offsetX, 0.0, offsetZ).m_82541_().m_82490_(motionScale);
            EntityType entityType = EntityType.m_20632_((String)"cataclysm:abyss_orb").orElse(null);
            if (entityType == null || (projectile = (Projectile)entityType.m_20615_(level)) == null) continue;
            projectile.m_7678_(entity.m_20185_(), entity.m_20186_() + 1.5, entity.m_20189_(), 0.0f, 0.0f);
            projectile.m_20334_(motion.m_7096_(), motion.m_7098_(), motion.m_7094_());
            LivingEntity target = this.findNearestTarget(level, entity);
            if (target != null && projectile instanceof Abyss_Orb_Entity) {
                Abyss_Orb_Entity abyssOrb = (Abyss_Orb_Entity)projectile;
                abyssOrb.setTracking(true);
                abyssOrb.m_5602_((Entity)entity);
                abyssOrb.setDamage(getDamage);
                try {
                    Field finalTargetField = Abyss_Orb_Entity.class.getDeclaredField("finalTarget");
                    finalTargetField.setAccessible(true);
                    finalTargetField.set(abyssOrb, target);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    e.printStackTrace();
                }
            }
            level.m_7967_((Entity)projectile);
        }
    }

    private LivingEntity findNearestTarget(Level level, LivingEntity caster) {
        AABB boundingBox = new AABB(caster.m_20185_() - 15.0, caster.m_20186_() - 15.0, caster.m_20189_() - 15.0, caster.m_20185_() + 15.0, caster.m_20186_() + 15.0, caster.m_20189_() + 15.0);
        List possibleTargets = level.m_6443_(LivingEntity.class, boundingBox, entity -> {
            TamableAnimal tamable;
            if (entity == caster) {
                return false;
            }
            if (caster.m_7307_((Entity)entity)) {
                return false;
            }
            return !(entity instanceof TamableAnimal) || !(tamable = (TamableAnimal)entity).m_21824_() || tamable.m_269323_() != caster;
        });
        if (possibleTargets.isEmpty()) {
            return null;
        }
        return possibleTargets.stream().min(Comparator.comparingDouble(arg_0 -> ((LivingEntity)caster).m_20280_(arg_0))).orElse(null);
    }

    private boolean isWearingFullSet(Player player) {
        return player.m_6844_(ArmorItem.Type.HELMET.m_266308_()).m_41720_() instanceof AbyssalHideArmorItem && player.m_6844_(ArmorItem.Type.CHESTPLATE.m_266308_()).m_41720_() instanceof AbyssalHideArmorItem && player.m_6844_(ArmorItem.Type.LEGGINGS.m_266308_()).m_41720_() instanceof AbyssalHideArmorItem && player.m_6844_(ArmorItem.Type.BOOTS.m_266308_()).m_41720_() instanceof AbyssalHideArmorItem;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GeoArmorRenderer<?> supplyRenderer() {
        return new AbyssalHideArmorRenderer(new AbyssalHideArmorModel());
    }
}

