/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class TravelopticsTemplate
extends Item {
    private static final ChatFormatting TITLE_FORMAT = ChatFormatting.GRAY;
    private static final ChatFormatting DESCRIPTION_FORMAT = ChatFormatting.BLUE;
    private static final String DESCRIPTION_ID = Util.m_137492_((String)"item", (ResourceLocation)new ResourceLocation("smithing_template"));
    private static final Component INGREDIENTS_TITLE = Component.m_237115_((String)Util.m_137492_((String)"item", (ResourceLocation)new ResourceLocation("smithing_template.ingredients"))).m_130940_(TITLE_FORMAT);
    private static final Component APPLIES_TO_TITLE = Component.m_237115_((String)Util.m_137492_((String)"item", (ResourceLocation)new ResourceLocation("smithing_template.applies_to"))).m_130940_(TITLE_FORMAT);
    private static final Component BASE_SLOT_DESCRIPTION = Component.m_237115_((String)"item.traveloptics.abyssal_upgrade.base_slot.desc");
    private static final Component ADDITIONS_SLOT_DESCRIPTION = Component.m_237115_((String)"item.traveloptics.abyssal_upgrade.additions_slot.desc");
    private static final List<ResourceLocation> UPGRADE_ICONS = List.of(new ResourceLocation("item/empty_armor_slot_helmet"), new ResourceLocation("item/empty_armor_slot_chestplate"), new ResourceLocation("item/empty_armor_slot_leggings"), new ResourceLocation("item/empty_armor_slot_boots"));
    private static final List<ResourceLocation> MATERIAL_ICONS = List.of(new ResourceLocation("item/empty_slot_ingot"));
    private final Component appliesTo;
    private final Component ingredients;
    private final Component upgradeDescription;
    private final Component baseSlotDescription;
    private final Component additionsSlotDescription;
    private final List<ResourceLocation> baseSlotEmptyIcons;
    private final List<ResourceLocation> additionalSlotEmptyIcons;

    public TravelopticsTemplate(Component appliesTo, Component ingredients, Component upgradeDescription, Component baseSlotDescription, Component additionsSlotDescription, List<ResourceLocation> baseSlotEmptyIcons, List<ResourceLocation> additionalSlotEmptyIcons) {
        super(new Item.Properties().m_41486_());
        this.appliesTo = appliesTo;
        this.ingredients = ingredients;
        this.upgradeDescription = upgradeDescription;
        this.baseSlotDescription = baseSlotDescription;
        this.additionsSlotDescription = additionsSlotDescription;
        this.baseSlotEmptyIcons = baseSlotEmptyIcons;
        this.additionalSlotEmptyIcons = additionalSlotEmptyIcons;
    }

    public static TravelopticsTemplate createUpgradeTemplate(String upgradeType) {
        return new TravelopticsTemplate((Component)Component.m_237115_((String)("item.traveloptics." + upgradeType + "_upgrade.applies_to.desc")).m_130940_(DESCRIPTION_FORMAT), (Component)Component.m_237115_((String)("item.traveloptics." + upgradeType + "_upgrade.ingredients.desc")).m_130940_(DESCRIPTION_FORMAT), (Component)Component.m_237115_((String)("item.traveloptics." + upgradeType + "_upgrade.desc")).m_130940_(TITLE_FORMAT), BASE_SLOT_DESCRIPTION, ADDITIONS_SLOT_DESCRIPTION, UPGRADE_ICONS, MATERIAL_ICONS);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        tooltip.add(this.upgradeDescription);
        tooltip.add(CommonComponents.f_237098_);
        tooltip.add(APPLIES_TO_TITLE);
        tooltip.add((Component)CommonComponents.m_264333_().m_7220_(this.appliesTo));
        tooltip.add(INGREDIENTS_TITLE);
        tooltip.add((Component)CommonComponents.m_264333_().m_7220_(this.ingredients));
    }

    public Component getBaseSlotDescription() {
        return this.baseSlotDescription;
    }

    public Component getAdditionSlotDescription() {
        return this.additionsSlotDescription;
    }

    public List<ResourceLocation> getBaseSlotEmptyIcons() {
        return this.baseSlotEmptyIcons;
    }

    public List<ResourceLocation> getAdditionalSlotEmptyIcons() {
        return this.additionalSlotEmptyIcons;
    }

    public String m_5524_() {
        return DESCRIPTION_ID;
    }
}

