/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.item;

import com.gametechbc.traveloptics.api.init.TravelopticsAttributes;
import com.gametechbc.traveloptics.api.item.armor.TravelopticsArmorMaterial;
import com.gametechbc.traveloptics.config.ArmorConfig;
import com.gametechbc.traveloptics.init.TravelopticsItems;
import com.github.L_Ender.cataclysm.init.ModItems;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import dev.shadowsoffire.attributeslib.api.ALObjects;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public enum TravelopticsArmorMaterials implements TravelopticsArmorMaterial
{
    ABYSSAL_HIDE("abyssal_hide", 80, TravelopticsArmorMaterials.abyssalHideArmorMap(), 15, SoundEvents.f_11678_, ((Double)ArmorConfig.abyssalHideArmorToughness.get()).floatValue(), 0.05f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TravelopticsItems.ABYSSAL_SPELLWEAVE_INGOT.get()}), Map.of((Attribute)AttributeRegistry.MAX_MANA.get(), new AttributeModifier("Max Mana", 150.0, AttributeModifier.Operation.ADDITION), (Attribute)AttributeRegistry.ELDRITCH_SPELL_POWER.get(), new AttributeModifier("Eldritch Power", 0.1, AttributeModifier.Operation.MULTIPLY_BASE), (Attribute)AttributeRegistry.ENDER_SPELL_POWER.get(), new AttributeModifier("Ender Power", 0.05, AttributeModifier.Operation.MULTIPLY_BASE), (Attribute)AttributeRegistry.SPELL_POWER.get(), new AttributeModifier("Spell Power", 0.05, AttributeModifier.Operation.MULTIPLY_BASE), (Attribute)ALObjects.Attributes.ARMOR_PIERCE.get(), new AttributeModifier("Armor Pierce", 0.05, AttributeModifier.Operation.ADDITION))),
    PRIMORDIAL_CREST("primordial_crest", 40, TravelopticsArmorMaterials.primordialCrestArmorMap(), 15, SoundEvents.f_11679_, ((Double)ArmorConfig.primordialCrestArmorToughness.get()).floatValue(), 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ACItemRegistry.HEAVY_BONE.get()}), Map.of((Attribute)AttributeRegistry.MAX_MANA.get(), new AttributeModifier("Max Mana", 125.0, AttributeModifier.Operation.ADDITION), (Attribute)AttributeRegistry.NATURE_SPELL_POWER.get(), new AttributeModifier("Nature Power", 0.1, AttributeModifier.Operation.MULTIPLY_BASE), (Attribute)AttributeRegistry.SPELL_POWER.get(), new AttributeModifier("Spell Power Power", 0.05, AttributeModifier.Operation.MULTIPLY_BASE))),
    TECTONIC_CREST("tectonic_crest", 80, TravelopticsArmorMaterials.tectonicCrestArmorMap(), 15, SoundEvents.f_11679_, ((Double)ArmorConfig.tectonicCrestArmorToughness.get()).floatValue(), 0.15f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TravelopticsItems.TECTONIC_INGOT.get()}), Map.of((Attribute)AttributeRegistry.MAX_MANA.get(), new AttributeModifier("Max Mana", 150.0, AttributeModifier.Operation.ADDITION), (Attribute)AttributeRegistry.FIRE_SPELL_POWER.get(), new AttributeModifier("Fire Power", 0.1, AttributeModifier.Operation.MULTIPLY_BASE), (Attribute)AttributeRegistry.NATURE_SPELL_POWER.get(), new AttributeModifier("Nature Power", 0.05, AttributeModifier.Operation.MULTIPLY_BASE), (Attribute)AttributeRegistry.SPELL_POWER.get(), new AttributeModifier("Spell Power", 0.05, AttributeModifier.Operation.MULTIPLY_BASE))),
    CURSED_WRAITHGUARD("cursed_wraithguard", 80, TravelopticsArmorMaterials.cursedWraithguardArmorMap(), 15, SoundEvents.f_11679_, ((Double)ArmorConfig.cursedWraithguardArmorToughness.get()).floatValue(), 0.05f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CURSIUM_INGOT.get()}), Map.of((Attribute)AttributeRegistry.MAX_MANA.get(), new AttributeModifier("Max Mana", 150.0, AttributeModifier.Operation.ADDITION), (Attribute)AttributeRegistry.ICE_SPELL_POWER.get(), new AttributeModifier("Ice Power", 0.1, AttributeModifier.Operation.MULTIPLY_BASE), (Attribute)AttributeRegistry.ELDRITCH_SPELL_POWER.get(), new AttributeModifier("Eldritch Power", 0.05, AttributeModifier.Operation.MULTIPLY_BASE), (Attribute)AttributeRegistry.SPELL_POWER.get(), new AttributeModifier("Spell Power", 0.05, AttributeModifier.Operation.MULTIPLY_BASE), (Attribute)ALObjects.Attributes.ARROW_DAMAGE.get(), new AttributeModifier("Arrow Damage", 0.05, AttributeModifier.Operation.MULTIPLY_BASE))),
    DEEPLING_MAGE("deepling_mage", 38, TravelopticsArmorMaterials.deeplingMageArmorMap(), 15, SoundEvents.f_11678_, ((Double)ArmorConfig.deeplingMageArmorToughness.get()).floatValue(), 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.MAGIC_CLOTH.get()}), Map.of((Attribute)AttributeRegistry.MAX_MANA.get(), new AttributeModifier("Max Mana", 125.0, AttributeModifier.Operation.ADDITION), (Attribute)TravelopticsAttributes.AQUA_SPELL_POWER.get(), new AttributeModifier("Aqua Power", 0.1, AttributeModifier.Operation.MULTIPLY_BASE), (Attribute)AttributeRegistry.SPELL_POWER.get(), new AttributeModifier("Base Power", 0.05, AttributeModifier.Operation.MULTIPLY_BASE))),
    MECHANIZED_EXOSKELETON("mechanized_exoskeleton", 80, TravelopticsArmorMaterials.mechanizedExoskeletonArmorMap(), 15, SoundEvents.f_11679_, ((Double)ArmorConfig.mechanizedExoskeletonArmorToughness.get()).floatValue(), 0.1f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.WITHERITE_INGOT.get()}), Map.of((Attribute)AttributeRegistry.MAX_MANA.get(), new AttributeModifier("Max Mana", 150.0, AttributeModifier.Operation.ADDITION), (Attribute)AttributeRegistry.LIGHTNING_SPELL_POWER.get(), new AttributeModifier("Lightning Power", 0.1, AttributeModifier.Operation.MULTIPLY_BASE), (Attribute)AttributeRegistry.SPELL_POWER.get(), new AttributeModifier("Spell Power", 0.05, AttributeModifier.Operation.MULTIPLY_BASE), Attributes.f_22279_, new AttributeModifier("Movement speed", 0.05, AttributeModifier.Operation.MULTIPLY_BASE))),
    FORLORN_HARBINGER("forlorn_harbinger", 80, TravelopticsArmorMaterials.forlornHarbingerArmorMap(), 15, SoundEvents.f_11678_, ((Double)ArmorConfig.forlornHarbingerArmorToughness.get()).floatValue(), 0.05f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TravelopticsItems.DARKNESS_CLOTH.get()}), Map.of((Attribute)AttributeRegistry.MAX_MANA.get(), new AttributeModifier("Max Mana", 150.0, AttributeModifier.Operation.ADDITION), (Attribute)AttributeRegistry.BLOOD_SPELL_POWER.get(), new AttributeModifier("Blood Power", 0.1, AttributeModifier.Operation.MULTIPLY_BASE), (Attribute)AttributeRegistry.ELDRITCH_SPELL_POWER.get(), new AttributeModifier("Eldritch Power", 0.05, AttributeModifier.Operation.MULTIPLY_BASE), (Attribute)AttributeRegistry.SPELL_POWER.get(), new AttributeModifier("Spell Power", 0.05, AttributeModifier.Operation.MULTIPLY_BASE))),
    RIPTIDE_SOVEREIGN("riptide_sovereign", 80, TravelopticsArmorMaterials.forlornHarbingerArmorMap(), 15, SoundEvents.f_11677_, ((Double)ArmorConfig.riptideSovereignArmorToughness.get()).floatValue(), 0.05f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.LACRIMA.get()}), Map.of((Attribute)AttributeRegistry.MAX_MANA.get(), new AttributeModifier("Max Mana", 150.0, AttributeModifier.Operation.ADDITION), (Attribute)TravelopticsAttributes.AQUA_SPELL_POWER.get(), new AttributeModifier("Aqua Power", 0.1, AttributeModifier.Operation.MULTIPLY_BASE), (Attribute)AttributeRegistry.LIGHTNING_SPELL_POWER.get(), new AttributeModifier("Lightning Power", 0.05, AttributeModifier.Operation.MULTIPLY_BASE), (Attribute)AttributeRegistry.SPELL_POWER.get(), new AttributeModifier("Spell Power", 0.05, AttributeModifier.Operation.MULTIPLY_BASE)));

    private static final int[] HEALTH_PER_SLOT;
    private final String name;
    private final int durabilityMultiplier;
    private final EnumMap<ArmorItem.Type, Integer> protectionFunctionForType;
    private final int enchantmentValue;
    private final SoundEvent sound;
    private final float toughness;
    private final float knockbackResistance;
    private final LazyLoadedValue<Ingredient> repairIngredient;
    private final Map<Attribute, AttributeModifier> additionalAttributes;
    private static final EnumMap<ArmorItem.Type, Integer> HEALTH_FUNCTION_FOR_TYPE;

    private TravelopticsArmorMaterials(String pName, int pDurabilityMultiplier, EnumMap<ArmorItem.Type, Integer> protectionMap, int pEnchantmentValue, SoundEvent pSound, float pToughness, float pKnockbackResistance, Supplier<Ingredient> pRepairIngredient, Map<Attribute, AttributeModifier> additionalAttributes) {
        this.name = pName;
        this.durabilityMultiplier = pDurabilityMultiplier;
        this.protectionFunctionForType = protectionMap;
        this.enchantmentValue = pEnchantmentValue;
        this.sound = pSound;
        this.toughness = pToughness;
        this.knockbackResistance = pKnockbackResistance;
        this.repairIngredient = new LazyLoadedValue(pRepairIngredient);
        this.additionalAttributes = additionalAttributes;
    }

    public static EnumMap<ArmorItem.Type, Integer> createArmorMap(int helmet, int chestplate, int leggings, int boots) {
        return (EnumMap)Util.m_137469_(new EnumMap(ArmorItem.Type.class), p_266655_ -> {
            p_266655_.put(ArmorItem.Type.BOOTS, boots);
            p_266655_.put(ArmorItem.Type.LEGGINGS, leggings);
            p_266655_.put(ArmorItem.Type.CHESTPLATE, chestplate);
            p_266655_.put(ArmorItem.Type.HELMET, helmet);
        });
    }

    public static EnumMap<ArmorItem.Type, Integer> abyssalHideArmorMap() {
        return TravelopticsArmorMaterials.createArmorMap((Integer)ArmorConfig.abyssalHideHelmetArmorValue.get(), (Integer)ArmorConfig.abyssalHideChestplateArmorValue.get(), (Integer)ArmorConfig.abyssalHideLeggingsArmorValue.get(), (Integer)ArmorConfig.abyssalHideBootsArmorValue.get());
    }

    public static EnumMap<ArmorItem.Type, Integer> primordialCrestArmorMap() {
        return TravelopticsArmorMaterials.createArmorMap((Integer)ArmorConfig.primordialCrestHelmetArmorValue.get(), (Integer)ArmorConfig.primordialCrestChestplateArmorValue.get(), (Integer)ArmorConfig.primordialCrestLeggingsArmorValue.get(), (Integer)ArmorConfig.primordialCrestBootsArmorValue.get());
    }

    public static EnumMap<ArmorItem.Type, Integer> tectonicCrestArmorMap() {
        return TravelopticsArmorMaterials.createArmorMap((Integer)ArmorConfig.tectonicCrestHelmetArmorValue.get(), (Integer)ArmorConfig.tectonicCrestChestplateArmorValue.get(), (Integer)ArmorConfig.tectonicCrestLeggingsArmorValue.get(), (Integer)ArmorConfig.tectonicCrestBootsArmorValue.get());
    }

    public static EnumMap<ArmorItem.Type, Integer> cursedWraithguardArmorMap() {
        return TravelopticsArmorMaterials.createArmorMap((Integer)ArmorConfig.cursedWraithguardHelmetArmorValue.get(), (Integer)ArmorConfig.cursedWraithguardChestplateArmorValue.get(), (Integer)ArmorConfig.cursedWraithguardLeggingsArmorValue.get(), (Integer)ArmorConfig.cursedWraithguardBootsArmorValue.get());
    }

    public static EnumMap<ArmorItem.Type, Integer> mechanizedExoskeletonArmorMap() {
        return TravelopticsArmorMaterials.createArmorMap((Integer)ArmorConfig.mechanizedExoskeletonHelmetArmorValue.get(), (Integer)ArmorConfig.mechanizedExoskeletonChestplateArmorValue.get(), (Integer)ArmorConfig.mechanizedExoskeletonLeggingsArmorValue.get(), (Integer)ArmorConfig.mechanizedExoskeletonBootsArmorValue.get());
    }

    public static EnumMap<ArmorItem.Type, Integer> deeplingMageArmorMap() {
        return TravelopticsArmorMaterials.createArmorMap((Integer)ArmorConfig.deeplingMageHelmetArmorValue.get(), (Integer)ArmorConfig.deeplingMageChestplateArmorValue.get(), (Integer)ArmorConfig.deeplingMageLeggingsArmorValue.get(), (Integer)ArmorConfig.deeplingMageBootsArmorValue.get());
    }

    public static EnumMap<ArmorItem.Type, Integer> forlornHarbingerArmorMap() {
        return TravelopticsArmorMaterials.createArmorMap((Integer)ArmorConfig.forlornHarbingerHelmetArmorValue.get(), (Integer)ArmorConfig.forlornHarbingerChestplateArmorValue.get(), (Integer)ArmorConfig.forlornHarbingerLeggingsArmorValue.get(), (Integer)ArmorConfig.forlornHarbingerBootsArmorValue.get());
    }

    public static EnumMap<ArmorItem.Type, Integer> riptideSovereignArmorMap() {
        return TravelopticsArmorMaterials.createArmorMap((Integer)ArmorConfig.riptideSovereignHelmetArmorValue.get(), (Integer)ArmorConfig.riptideSovereignChestplateArmorValue.get(), (Integer)ArmorConfig.riptideSovereignLeggingsArmorValue.get(), (Integer)ArmorConfig.riptideSovereignBootsArmorValue.get());
    }

    public int getDurabilityForSlot(EquipmentSlot pSlot) {
        return HEALTH_PER_SLOT[pSlot.m_20749_()] * this.durabilityMultiplier;
    }

    public int m_266425_(ArmorItem.Type p_266745_) {
        return HEALTH_FUNCTION_FOR_TYPE.get(p_266745_) * this.durabilityMultiplier;
    }

    public int m_7366_(ArmorItem.Type p_266752_) {
        return this.protectionFunctionForType.get(p_266752_);
    }

    public int m_6646_() {
        return this.enchantmentValue;
    }

    public SoundEvent m_7344_() {
        return this.sound;
    }

    public Ingredient m_6230_() {
        return (Ingredient)this.repairIngredient.m_13971_();
    }

    public String m_6082_() {
        return this.name;
    }

    public float m_6651_() {
        return this.toughness;
    }

    @Override
    public Map<Attribute, AttributeModifier> getAdditionalAttributes() {
        return this.additionalAttributes;
    }

    public float m_6649_() {
        return this.knockbackResistance;
    }

    static {
        HEALTH_PER_SLOT = new int[]{13, 15, 16, 11};
        HEALTH_FUNCTION_FOR_TYPE = (EnumMap)Util.m_137469_(new EnumMap(ArmorItem.Type.class), p_266653_ -> {
            p_266653_.put(ArmorItem.Type.BOOTS, 13);
            p_266653_.put(ArmorItem.Type.LEGGINGS, 15);
            p_266653_.put(ArmorItem.Type.CHESTPLATE, 16);
            p_266653_.put(ArmorItem.Type.HELMET, 11);
        });
    }
}

