/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.entity.mobs.nightwarden_boss.misc;

import com.gametechbc.traveloptics.init.TravelopticsEntities;
import com.gametechbc.traveloptics.init.TravelopticsParticles;
import com.gametechbc.traveloptics.init.TravelopticsSounds;
import com.gametechbc.traveloptics.util.TravelopticsParticleHelper;
import com.github.L_Ender.cataclysm.entity.effect.ScreenShake_Entity;
import io.redspace.ironsspellbooks.entity.spells.AoeEntity;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EndEruptionEntity
extends AoeEntity {
    private static final EntityDataAccessor<Integer> WINDUP = SynchedEntityData.m_135353_(EndEruptionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private boolean triggered = false;
    private boolean eruptionStarted = false;

    public EndEruptionEntity(EntityType<? extends Projectile> type, Level level) {
        super(type, level);
    }

    public EndEruptionEntity(Level level) {
        this((EntityType<? extends Projectile>)((EntityType)TravelopticsEntities.END_ERUPTION.get()), level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(WINDUP, (Object)60);
    }

    protected void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("WindupDuration", this.getWindupDuration());
        tag.m_128379_("Triggered", this.triggered);
        tag.m_128379_("EruptionStarted", this.eruptionStarted);
    }

    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("WindupDuration")) {
            this.setWindupDuration(tag.m_128451_("WindupDuration"));
        }
        if (tag.m_128441_("Triggered")) {
            this.triggered = tag.m_128471_("Triggered");
        }
        if (tag.m_128441_("EruptionStarted")) {
            this.eruptionStarted = tag.m_128471_("EruptionStarted");
        }
    }

    public void setWindupDuration(int ticks) {
        this.f_19804_.m_135381_(WINDUP, (Object)ticks);
    }

    public int getWindupDuration() {
        return (Integer)this.f_19804_.m_135370_(WINDUP);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            this.handleClientParticles();
        }
        if (!this.eruptionStarted && this.f_19797_ >= this.getWindupDuration() - 5) {
            this.eruptionStarted = true;
        }
        if (!this.triggered && this.f_19797_ >= this.getWindupDuration()) {
            this.triggerEruption();
            this.m_5496_((SoundEvent)TravelopticsSounds.END_ERUPTION_AMBIENT.get(), 1.0f, 1.0f);
            this.m_5496_((SoundEvent)TravelopticsSounds.END_ERUPTION_BLAST.get(), 1.0f, 1.0f);
        } else if (this.triggered && this.f_19797_ >= this.getWindupDuration() + 20) {
            this.m_5496_((SoundEvent)TravelopticsSounds.END_ERUPTION_BLAST.get(), 1.0f, 1.0f);
            this.triggerEruption();
            this.m_146870_();
        }
    }

    private void handleClientParticles() {
        double radius = this.getRadius();
        Vec3 center = this.m_20182_();
        if (this.f_19797_ < this.getWindupDuration() - 5) {
            if ((double)this.f_19797_ < (double)this.getWindupDuration() * 0.3) {
                this.createMagicCircleFormation(center, radius);
            } else if ((double)this.f_19797_ < (double)this.getWindupDuration() * 0.7) {
                this.createEnergyGathering(center, radius);
            } else {
                this.createIntenseBuildup(center, radius);
            }
        } else if (this.f_19797_ < this.getWindupDuration()) {
            this.createPreEruptionParticles(center, radius);
        } else if (this.f_19797_ < this.getWindupDuration() + 20) {
            this.createEruptionParticles(center, radius);
        }
    }

    private void createMagicCircleFormation(Vec3 center, double radius) {
        float progress = (float)this.f_19797_ / ((float)this.getWindupDuration() * 0.3f);
        int circleCount = 3;
        for (int circle = 0; circle < circleCount; ++circle) {
            double circleRadius = radius * (0.4 + (double)circle * 0.3);
            int particlesPerCircle = 20 * (circle + 1);
            double rotationSpeed = 0.08 * (double)(circle + 1);
            for (int i = 0; i < particlesPerCircle; ++i) {
                double angleStep = Math.PI * 2 * (double)i / (double)particlesPerCircle;
                double angle = angleStep + (double)this.f_19797_ * rotationSpeed;
                double x = center.f_82479_ + Math.cos(angle) * circleRadius;
                double z = center.f_82481_ + Math.sin(angle) * circleRadius;
                double waveOffset = Math.sin(angleStep * 3.0 + (double)this.f_19797_ * 0.15) * 0.08;
                double y = center.f_82480_ + 0.15 + waveOffset;
                if (!(this.f_19796_.m_188501_() < progress)) continue;
                this.m_9236_().m_7106_(TravelopticsParticleHelper.VERY_SHORT_LIGHT_PURPLE_GLOWING_ENCHANT, x, y, z, 0.0, 0.015, 0.0);
            }
        }
        if (this.f_19797_ % 4 == 0) {
            int runeCount = 6;
            for (int i = 0; i < runeCount; ++i) {
                double angle = Math.PI * 2 * (double)i / (double)runeCount + (double)this.f_19797_ * 0.03;
                double runeRadius = radius * 0.2;
                double x = center.f_82479_ + Math.cos(angle) * runeRadius;
                double z = center.f_82481_ + Math.sin(angle) * runeRadius;
                this.m_9236_().m_7106_(TravelopticsParticleHelper.VERY_SHORT_LIGHT_PURPLE_GLOWING_ENCHANT, x, center.f_82480_ + 0.25, z, 0.0, 0.025, 0.0);
            }
        }
    }

    private void createEnergyGathering(Vec3 center, double radius) {
        double gatherProgress = ((double)this.f_19797_ - (double)this.getWindupDuration() * 0.3) / ((double)this.getWindupDuration() * 0.4);
        int spiralCount = 12;
        for (int i = 0; i < spiralCount; ++i) {
            double spiralAngle = (double)this.f_19797_ * 0.2 + (double)i * Math.PI * 2.0 / (double)spiralCount;
            double spiralRadius = radius * 1.8 * (1.0 - gatherProgress * 0.85);
            double x = center.f_82479_ + Math.cos(spiralAngle) * spiralRadius;
            double z = center.f_82481_ + Math.sin(spiralAngle) * spiralRadius;
            double heightOffset = Math.sin(spiralAngle * 2.0 + (double)this.f_19797_ * 0.12) * 0.6;
            double y = center.f_82480_ + 0.8 + heightOffset;
            double velX = (center.f_82479_ - x) * 0.08;
            double velZ = (center.f_82481_ - z) * 0.08;
            double velY = (center.f_82480_ - y) * 0.03;
            this.m_9236_().m_7106_((ParticleOptions)TravelopticsParticles.PURPLE_STAR_INWARD_PARTICLE.get(), x, y, z, velX, velY, velZ);
        }
        if (this.f_19797_ % 8 == 0) {
            int pulseCount = 10;
            for (int i = 0; i < pulseCount; ++i) {
                double angle = Math.PI * 2 * (double)i / (double)pulseCount + this.f_19796_.m_188500_() * 0.3;
                double distance = this.f_19796_.m_188500_() * radius * 0.25;
                double x = center.f_82479_ + Math.cos(angle) * distance;
                double z = center.f_82481_ + Math.sin(angle) * distance;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123810_, x, center.f_82480_ + 0.2, z, 0.0, 0.08, 0.0);
            }
        }
        if (this.f_19797_ % 2 == 0) {
            this.createMagicCircleFormation(center, radius);
        }
    }

    private void createIntenseBuildup(Vec3 center, double radius) {
        double z;
        double x;
        double distance;
        float intensity = (float)(((double)this.f_19797_ - (double)this.getWindupDuration() * 0.7) / ((double)this.getWindupDuration() * 0.3));
        int convergenceCount = 15 + (int)(intensity * 10.0f);
        for (int i = 0; i < convergenceCount; ++i) {
            double angle = this.f_19796_.m_188500_() * 2.0 * Math.PI;
            double pitch = this.f_19796_.m_188500_() * Math.PI * 0.5;
            distance = radius * 2.5 * (1.0 - (double)intensity * 0.8);
            x = center.f_82479_ + Math.cos(angle) * Math.sin(pitch) * distance;
            z = center.f_82481_ + Math.sin(angle) * Math.sin(pitch) * distance;
            double y = center.f_82480_ + Math.cos(pitch) * distance * 0.6 + 0.5;
            double velX = (center.f_82479_ - x) * (0.12 + (double)intensity * 0.05);
            double velZ = (center.f_82481_ - z) * (0.12 + (double)intensity * 0.05);
            double velY = (center.f_82480_ + 0.3 - y) * (0.08 + (double)intensity * 0.04);
            this.m_9236_().m_7106_((ParticleOptions)TravelopticsParticles.PURPLE_STAR_INWARD_PARTICLE.get(), x, y, z, velX, velY, velZ);
        }
        if (this.f_19797_ % 2 == 0) {
            this.createMagicCircleFormation(center, radius * (1.0 + (double)intensity * 0.3));
        }
        int coreCount = (int)(intensity * 15.0f);
        for (int i = 0; i < coreCount; ++i) {
            double coreRadius = radius * 0.4 * (1.0 - (double)intensity * 0.5);
            double angle = this.f_19796_.m_188500_() * 2.0 * Math.PI;
            double x2 = center.f_82479_ + Math.cos(angle) * coreRadius;
            double z2 = center.f_82481_ + Math.sin(angle) * coreRadius;
            double y = center.f_82480_ + this.f_19796_.m_188500_() * 0.6;
            this.m_9236_().m_7106_(TravelopticsParticleHelper.SHORT_LIGHT_PURPLE_GLOWING_ENCHANT, x2, y, z2, 0.0, 0.03 + (double)intensity * 0.08, 0.0);
        }
        if (this.f_19797_ % 3 == 0) {
            int pillarCount = (int)(intensity * 12.0f);
            for (int i = 0; i < pillarCount; ++i) {
                double angle = Math.PI * 2 * (double)i / (double)Math.max(pillarCount, 1) + this.f_19796_.m_188500_() * 0.4;
                distance = this.f_19796_.m_188500_() * radius * 0.5;
                x = center.f_82479_ + Math.cos(angle) * distance;
                z = center.f_82481_ + Math.sin(angle) * distance;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123810_, x, center.f_82480_ + 0.1, z, 0.0, 0.05 + (double)intensity * 0.08, 0.0);
            }
        }
    }

    private void createPreEruptionParticles(Vec3 center, double radius) {
        int i;
        for (int i2 = 0; i2 < 35; ++i2) {
            double angle = this.f_19796_.m_188500_() * 2.0 * Math.PI;
            double distance = this.f_19796_.m_188500_() * radius * 0.8;
            double x = center.f_82479_ + Math.cos(angle) * distance;
            double z = center.f_82481_ + Math.sin(angle) * distance;
            double y = center.f_82480_ + 1.5 + this.f_19796_.m_188500_() * 2.5;
            this.m_9236_().m_7106_(TravelopticsParticleHelper.SHORT_LIGHT_PURPLE_GLOWING_ENCHANT, x, y, z, 0.0, -0.25, 0.0);
            if (i2 % 2 != 0) continue;
            this.m_9236_().m_7106_(TravelopticsParticleHelper.ABYSS_SPIKE_PARTICLE, x, y, z, 0.0, -0.18, 0.0);
        }
        int rippleCount = 40;
        for (i = 0; i < rippleCount; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)rippleCount + this.f_19796_.m_188500_() * 0.2;
            double distance = this.f_19796_.m_188500_() * radius * 1.3;
            double x = center.f_82479_ + Math.cos(angle) * distance;
            double z = center.f_82481_ + Math.sin(angle) * distance;
            this.m_9236_().m_7106_(TravelopticsParticleHelper.VERY_SHORT_LIGHT_PURPLE_GLOWING_ENCHANT, x, center.f_82480_ + 0.05, z, 0.0, 0.08, 0.0);
        }
        for (i = 0; i < 12; ++i) {
            double x = center.f_82479_ + (this.f_19796_.m_188500_() - 0.5) * 0.4;
            double z = center.f_82481_ + (this.f_19796_.m_188500_() - 0.5) * 0.4;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123810_, x, center.f_82480_ + 0.1, z, (this.f_19796_.m_188500_() - 0.5) * 0.1, 0.15, (this.f_19796_.m_188500_() - 0.5) * 0.1);
        }
    }

    private void createEruptionParticles(Vec3 center, double radius) {
        double z;
        double x;
        double z2;
        double x2;
        double angle;
        int eruptionTick = this.f_19797_ - this.getWindupDuration();
        int beamDensity = 50;
        for (int i = 0; i < beamDensity; ++i) {
            double coreRadius = radius * 0.6;
            angle = this.f_19796_.m_188500_() * 2.0 * Math.PI;
            double distance = this.f_19796_.m_188500_() * coreRadius;
            x2 = center.f_82479_ + Math.cos(angle) * distance;
            z2 = center.f_82481_ + Math.sin(angle) * distance;
            double velX = (this.f_19796_.m_188500_() - 0.5) * 0.08;
            double velZ = (this.f_19796_.m_188500_() - 0.5) * 0.08;
            double velY = 1.0 + this.f_19796_.m_188500_() * 1.5;
            this.m_9236_().m_7106_(TravelopticsParticleHelper.ABYSS_SPIKE_PARTICLE, x2, center.f_82480_, z2, velX, velY, velZ);
        }
        int burstCount = 10;
        for (int i = 0; i < burstCount; ++i) {
            double angle2 = Math.PI * 2 * (double)i / (double)burstCount + this.f_19796_.m_188500_() * 0.3;
            double pitch = 0.47123889803846897 + this.f_19796_.m_188500_() * Math.PI * 0.35;
            double speed = 0.8 + this.f_19796_.m_188500_() * 0.7;
            double velX = Math.cos(angle2) * Math.sin(pitch) * speed;
            double velY = Math.cos(pitch) * speed * 1.2;
            double velZ = Math.sin(angle2) * Math.sin(pitch) * speed;
            this.m_9236_().m_7106_((ParticleOptions)TravelopticsParticles.PURPLE_STAR_OUTWARD_PARTICLE.get(), center.f_82479_, center.f_82480_ + 0.5, center.f_82481_, velX, velY, velZ);
        }
        if (eruptionTick < 15) {
            for (int ring = 0; ring < 4; ++ring) {
                double ringRadius = radius * (0.25 + (double)ring * 0.25);
                int spikesInRing = 10 + ring * 5;
                if (eruptionTick <= ring * 2) continue;
                for (int i = 0; i < spikesInRing; ++i) {
                    double angle3 = Math.PI * 2 * (double)i / (double)spikesInRing + this.f_19796_.m_188500_() * 0.25;
                    x = center.f_82479_ + Math.cos(angle3) * ringRadius;
                    z = center.f_82481_ + Math.sin(angle3) * ringRadius;
                    double velY = 0.9 - (double)ring * 0.15 + this.f_19796_.m_188500_() * 0.4;
                    double spread = 0.03 * (double)(ring + 1);
                    double velX = (this.f_19796_.m_188500_() - 0.5) * spread;
                    double velZ = (this.f_19796_.m_188500_() - 0.5) * spread;
                    this.m_9236_().m_7106_(TravelopticsParticleHelper.ABYSS_SPIKE_PARTICLE, x, center.f_82480_, z, velX, velY, velZ);
                }
            }
        }
        int debrisCount = 25;
        for (int i = 0; i < debrisCount; ++i) {
            angle = this.f_19796_.m_188500_() * 2.0 * Math.PI;
            double distance = this.f_19796_.m_188500_() * radius * 1.5;
            x2 = center.f_82479_ + Math.cos(angle) * distance;
            z2 = center.f_82481_ + Math.sin(angle) * distance;
            double outwardVel = 0.15 + this.f_19796_.m_188500_() * 0.1;
            this.m_9236_().m_7106_(TravelopticsParticleHelper.SHORT_LIGHT_PURPLE_GLOWING_ENCHANT, x2, center.f_82480_ + 0.1, z2, Math.cos(angle) * outwardVel, 0.25 + this.f_19796_.m_188500_() * 0.35, Math.sin(angle) * outwardVel);
        }
        if (eruptionTick > 5) {
            int wispCount = 15;
            for (int i = 0; i < wispCount; ++i) {
                double angle4 = this.f_19796_.m_188500_() * 2.0 * Math.PI;
                double distance = this.f_19796_.m_188500_() * radius * 1.2;
                x = center.f_82479_ + Math.cos(angle4) * distance;
                z = center.f_82481_ + Math.sin(angle4) * distance;
                double y = center.f_82480_ + this.f_19796_.m_188500_() * 5.0;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123810_, x, y, z, (this.f_19796_.m_188500_() - 0.5) * 0.04, -0.02 - this.f_19796_.m_188500_() * 0.02, (this.f_19796_.m_188500_() - 0.5) * 0.04);
            }
        }
    }

    private void triggerEruption() {
        this.triggered = true;
        double radius = this.getRadius();
        double maxY = this.m_20186_() + 4.0;
        double minY = this.m_20186_() - 1.0;
        AABB searchBox = new AABB(this.m_20185_() - radius, minY, this.m_20189_() - radius, this.m_20185_() + radius, maxY, this.m_20189_() + radius);
        List targets = this.m_9236_().m_6443_(LivingEntity.class, searchBox, entity -> entity.m_6084_() && entity != this.m_19749_());
        for (LivingEntity target : targets) {
            double dz;
            double dx = target.m_20185_() - this.m_20185_();
            double horizontalDistanceSq = dx * dx + (dz = target.m_20189_() - this.m_20189_()) * dz;
            if (!(horizontalDistanceSq <= radius * radius)) continue;
            DamageSource damageSource = this.m_269291_().m_269104_((Entity)this, this.m_19749_());
            target.m_6469_(damageSource, this.getDamage());
        }
        ScreenShake_Entity.ScreenShake((Level)this.m_9236_(), (Vec3)this.m_20182_(), (float)((float)(radius + 10.0)), (float)0.05f, (int)8, (int)10);
    }

    public void applyEffect(LivingEntity target) {
    }

    public float getParticleCount() {
        return 0.15f;
    }

    public Optional<ParticleOptions> getParticle() {
        return Optional.empty();
    }
}

