/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.elemental_interactions;

import com.gametechbc.traveloptics.api.utils.TOCurioUtils;
import com.gametechbc.traveloptics.init.TravelopticsEffects;
import com.gametechbc.traveloptics.init.TravelopticsItems;
import com.gametechbc.traveloptics.item.armor.RiptideSovereignArmorItem;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.entity.spells.ChainLightning;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class HydrochargeReaction {
    private static final int WET_CHAIN_LIGHTNING_COOLDOWN_TICKS = 30;
    private static final Map<UUID, Long> wetChainLightningCooldownMap = new HashMap<UUID, Long>();

    public static void triggerWetChainLightning(Level world, LivingEntity caster, LivingEntity victim) {
        long lastTrigger;
        if (world.f_46443_) {
            return;
        }
        UUID casterUUID = caster.m_20148_();
        long currentTick = world.m_46467_();
        if (wetChainLightningCooldownMap.containsKey(casterUUID) && currentTick - (lastTrigger = wetChainLightningCooldownMap.get(casterUUID).longValue()) < 30L) {
            return;
        }
        wetChainLightningCooldownMap.put(casterUUID, currentTick);
        ChainLightning chainLightning = new ChainLightning(world, (Entity)caster, (Entity)victim);
        chainLightning.setDamage(HydrochargeReaction.calculateWetChainLightningDamage(caster, victim));
        chainLightning.range = 8.0f;
        chainLightning.maxConnections = HydrochargeReaction.getHydrochargeMaxConnections(caster);
        world.m_7967_((Entity)chainLightning);
        HydrochargeReaction.consumeWetEffectAmplifier(victim);
    }

    private static float calculateWetChainLightningDamage(LivingEntity caster, LivingEntity victim) {
        float baseDamage = 2.79f;
        MobEffectInstance wetEffect = victim.m_21124_((MobEffect)TravelopticsEffects.WET.get());
        int wetAmplifier = wetEffect != null ? wetEffect.m_19564_() : 0;
        float wetBonusDamage = (float)wetAmplifier * 0.86f;
        double lightningSpellPower = caster.m_21133_((Attribute)AttributeRegistry.LIGHTNING_SPELL_POWER.get());
        float chainLightningTotalDamage = (baseDamage + wetBonusDamage) * (float)lightningSpellPower;
        chainLightningTotalDamage *= 0.9f;
        chainLightningTotalDamage = HydrochargeReaction.applyHydrochargeDamageBonus(caster, chainLightningTotalDamage);
        return chainLightningTotalDamage;
    }

    private static void consumeWetEffectAmplifier(LivingEntity entity) {
        MobEffectInstance wetEffect = entity.m_21124_((MobEffect)TravelopticsEffects.WET.get());
        if (wetEffect == null) {
            return;
        }
        int currentAmplifier = wetEffect.m_19564_();
        int currentDuration = wetEffect.m_19557_();
        if (currentAmplifier <= 0) {
            entity.m_21195_((MobEffect)TravelopticsEffects.WET.get());
            return;
        }
        entity.m_21195_((MobEffect)TravelopticsEffects.WET.get());
        MobEffectInstance downgradedWet = new MobEffectInstance((MobEffect)TravelopticsEffects.WET.get(), currentDuration, currentAmplifier - 1, false, false, true);
        entity.m_7292_(downgradedWet);
    }

    private static boolean isHoldingStormEmpressStaff(LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return false;
        }
        Player player = (Player)entity;
        ItemStack mainHand = player.m_21205_();
        ItemStack offHand = player.m_21206_();
        return mainHand.m_150930_((Item)TravelopticsItems.STAFF_OF_THE_STORM_EMPRESS.get()) || offHand.m_150930_((Item)TravelopticsItems.STAFF_OF_THE_STORM_EMPRESS.get());
    }

    public static boolean hasHydrochargeEnabled(LivingEntity caster) {
        if (caster instanceof Player) {
            Player player = (Player)caster;
            return RiptideSovereignArmorItem.isWearingFullSet(player) || TOCurioUtils.getWearingCurio(caster, (Item)TravelopticsItems.HYDROCHARGE_BRACELET.get());
        }
        return TOCurioUtils.getWearingCurio(caster, (Item)TravelopticsItems.HYDROCHARGE_BRACELET.get());
    }

    public static int getHydrochargeMaxConnections(LivingEntity caster) {
        if (HydrochargeReaction.isHoldingStormEmpressStaff(caster)) {
            return 5;
        }
        return 3;
    }

    public static float applyHydrochargeDamageBonus(LivingEntity caster, float baseDamage) {
        Player player;
        if (caster instanceof Player && RiptideSovereignArmorItem.isWearingFullSet(player = (Player)caster) && TOCurioUtils.getWearingCurio(caster, (Item)TravelopticsItems.HYDROCHARGE_BRACELET.get())) {
            return baseDamage * 1.15f;
        }
        return baseDamage;
    }
}

