/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.data_manager;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class StormlineManager {
    public static final int MAX_STORMLINE_POINTS = 400;
    public static final int AQUA_DAMAGE_GAIN = 20;
    public static final int LIGHTNING_DAMAGE_GAIN = 10;
    public static final int RANK_2_THRESHOLD = 40;
    public static final int RANK_3_THRESHOLD = 120;
    public static final int RANK_4_THRESHOLD = 240;
    public static final int RANK_5_THRESHOLD = 400;
    public static final int RANK_2_REQUIREMENT = 40;
    public static final int RANK_3_REQUIREMENT = 80;
    public static final int RANK_4_REQUIREMENT = 120;
    public static final int RANK_5_REQUIREMENT = 160;
    private static final String STORMLINE_TAG = "Stormline";
    public static final String[] RANK_NAMES = new String[]{"Initiate", "Emergent", "Prime", "Ascendant", "Sovereign"};

    public static int getStormline(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_(STORMLINE_TAG)) {
            return stack.m_41783_().m_128451_(STORMLINE_TAG);
        }
        return 0;
    }

    public static void setStormline(ItemStack stack, int points) {
        int cappedPoints = Math.max(0, Math.min(points, 400));
        stack.m_41784_().m_128405_(STORMLINE_TAG, cappedPoints);
    }

    public static void addStormline(ItemStack stack, Player player, int amount) {
        int currentPoints = StormlineManager.getStormline(stack);
        int newPoints = Math.min(currentPoints + amount, 400);
        StormlineManager.setStormline(stack, newPoints);
        int oldRank = StormlineManager.calculateRank(currentPoints);
        int newRank = StormlineManager.calculateRank(newPoints);
        if (newRank > oldRank) {
            StormlineManager.onRankUp(player, newRank);
        }
    }

    public static void addFromAquaDamage(ItemStack stack, Player player) {
        StormlineManager.addStormline(stack, player, 20);
    }

    public static void addFromLightningDamage(ItemStack stack, Player player) {
        StormlineManager.addStormline(stack, player, 10);
    }

    public static int getCurrentRank(ItemStack stack) {
        return StormlineManager.calculateRank(StormlineManager.getStormline(stack));
    }

    private static int calculateRank(int points) {
        if (points >= 400) {
            return 5;
        }
        if (points >= 240) {
            return 4;
        }
        if (points >= 120) {
            return 3;
        }
        if (points >= 40) {
            return 2;
        }
        return 1;
    }

    public static String getRankName(ItemStack stack) {
        int rank = StormlineManager.getCurrentRank(stack);
        return RANK_NAMES[rank - 1];
    }

    public static int[] getRankProgress(ItemStack stack) {
        int points = StormlineManager.getStormline(stack);
        int rank = StormlineManager.calculateRank(points);
        int rankStart = StormlineManager.getRankStartThreshold(rank);
        int currentProgress = points - rankStart;
        int requiredForNext = StormlineManager.getRequirementForRank(rank + 1);
        return new int[]{currentProgress, requiredForNext};
    }

    private static int getRankStartThreshold(int rank) {
        switch (rank) {
            case 1: {
                return 0;
            }
            case 2: {
                return 40;
            }
            case 3: {
                return 120;
            }
            case 4: {
                return 240;
            }
            case 5: {
                return 400;
            }
        }
        return 0;
    }

    private static int getRequirementForRank(int targetRank) {
        switch (targetRank) {
            case 2: {
                return 40;
            }
            case 3: {
                return 80;
            }
            case 4: {
                return 120;
            }
            case 5: {
                return 160;
            }
        }
        return 0;
    }

    public static boolean decreaseRank(ItemStack stack, Player player) {
        int currentPoints = StormlineManager.getStormline(stack);
        int currentRank = StormlineManager.calculateRank(currentPoints);
        if (currentRank <= 1 && currentPoints == 0) {
            return false;
        }
        if (currentRank <= 1) {
            StormlineManager.setStormline(stack, 0);
            StormlineManager.onRankDown(player, 1);
            return true;
        }
        int newRank = currentRank - 1;
        int newPoints = StormlineManager.getRankStartThreshold(newRank);
        StormlineManager.setStormline(stack, newPoints);
        StormlineManager.onRankDown(player, newRank);
        return true;
    }

    public static float getAquaDamageMultiplier(ItemStack stack) {
        int rank = StormlineManager.getCurrentRank(stack);
        switch (rank) {
            case 1: {
                return 1.0f;
            }
            case 2: {
                return 1.05f;
            }
            case 3: {
                return 1.1f;
            }
            case 4: {
                return 1.15f;
            }
            case 5: {
                return 1.35f;
            }
        }
        return 1.0f;
    }

    public static float getLightningDamageMultiplier(ItemStack stack) {
        int rank = StormlineManager.getCurrentRank(stack);
        switch (rank) {
            case 1: {
                return 1.0f;
            }
            case 2: {
                return 1.025f;
            }
            case 3: {
                return 1.05f;
            }
            case 4: {
                return 1.075f;
            }
            case 5: {
                return 1.175f;
            }
        }
        return 1.0f;
    }

    private static void onRankUp(Player player, int newRank) {
    }

    private static void onRankDown(Player player, int newRank) {
        if (!player.m_9236_().f_46443_) {
            String rankName = RANK_NAMES[newRank - 1];
            player.m_5661_((Component)Component.m_237113_((String)("\ud83c\udf0a Stormline Rank Lost: " + rankName)).m_130940_(ChatFormatting.RED), true);
        }
    }
}

