/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.utils;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import org.joml.Vector3f;

public class NBTHelper {
    public static String getString(CompoundTag tag, String key, String defaultValue) {
        return tag.m_128441_(key) ? tag.m_128461_(key) : defaultValue;
    }

    public static int getInt(CompoundTag tag, String key, int defaultValue) {
        return tag.m_128441_(key) ? tag.m_128451_(key) : defaultValue;
    }

    public static float getFloat(CompoundTag tag, String key, float defaultValue) {
        return tag.m_128441_(key) ? tag.m_128457_(key) : defaultValue;
    }

    public static double getDouble(CompoundTag tag, String key, double defaultValue) {
        return tag.m_128441_(key) ? tag.m_128459_(key) : defaultValue;
    }

    public static boolean getBoolean(CompoundTag tag, String key, boolean defaultValue) {
        return tag.m_128441_(key) ? tag.m_128471_(key) : defaultValue;
    }

    public static byte getByte(CompoundTag tag, String key, byte defaultValue) {
        return tag.m_128441_(key) ? tag.m_128445_(key) : defaultValue;
    }

    public static short getShort(CompoundTag tag, String key, short defaultValue) {
        return tag.m_128441_(key) ? tag.m_128448_(key) : defaultValue;
    }

    public static long getLong(CompoundTag tag, String key, long defaultValue) {
        return tag.m_128441_(key) ? tag.m_128454_(key) : defaultValue;
    }

    public static ResourceLocation getResourceLocation(CompoundTag tag, String key, ResourceLocation defaultValue) {
        return tag.m_128441_(key) ? new ResourceLocation(tag.m_128461_(key)) : defaultValue;
    }

    public static <E extends Enum<E>> E getEnum(CompoundTag tag, Class<E> enumClass, String key, E defaultValue) {
        try {
            return Enum.valueOf(enumClass, tag.m_128461_(key).toUpperCase());
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return defaultValue;
        }
    }

    public static ListTag getFloatList(Vector3f vec) {
        ListTag listTag = new ListTag();
        listTag.add((Object)FloatTag.m_128566_((float)vec.x));
        listTag.add((Object)FloatTag.m_128566_((float)vec.y));
        listTag.add((Object)FloatTag.m_128566_((float)vec.z));
        return listTag;
    }

    public static Vector3f getVector3f(ListTag listTag) {
        return new Vector3f(listTag.m_128775_(0), listTag.m_128775_(1), listTag.m_128775_(2));
    }

    public static ListTag getStringList(Set<String> stringSet) {
        ListTag listTag = new ListTag();
        for (String str : stringSet) {
            listTag.add((Object)StringTag.m_129297_((String)str));
        }
        return listTag;
    }

    public static Set<String> getStringSet(ListTag listTag) {
        HashSet<String> stringSet = new HashSet<String>();
        for (Tag tag : listTag) {
            if (!(tag instanceof StringTag)) continue;
            StringTag stringTag = (StringTag)tag;
            stringSet.add(stringTag.m_7916_());
        }
        return stringSet;
    }
}

