/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.item;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.conczin.immersive_furniture.block.BaseFurnitureBlock;
import net.conczin.immersive_furniture.block.Blocks;
import net.conczin.immersive_furniture.block.EntityFurnitureBlock;
import net.conczin.immersive_furniture.block.FurnitureBlock;
import net.conczin.immersive_furniture.block.FurnitureProxyBlock;
import net.conczin.immersive_furniture.block.LightFurnitureBlock;
import net.conczin.immersive_furniture.data.FurnitureData;
import net.conczin.immersive_furniture.data.FurnitureDataManager;
import net.conczin.immersive_furniture.data.ServerFurnitureRegistry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public class FurnitureItem
extends BlockItem {
    public static final String FURNITURE = "Furniture";
    public static final String FURNITURE_HASH = "FurnitureHash";
    private static final Map<Integer, FurnitureData> cache = new LinkedHashMap<Integer, FurnitureData>(100, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Integer, FurnitureData> eldest) {
            return this.size() > 100;
        }
    };

    public FurnitureItem(Item.Properties settings) {
        super(Blocks.FURNITURE, settings);
    }

    public Component m_7626_(ItemStack stack) {
        return Component.m_237113_((String)FurnitureItem.getData((ItemStack)stack).name);
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag context) {
        FurnitureData data = FurnitureItem.getData(stack);
        tooltip.addAll(data.getTooltip(Screen.m_96638_()));
        super.m_7373_(stack, world, tooltip, context);
    }

    public static FurnitureData getData(ItemStack stack) {
        CompoundTag tag = stack.m_41737_("BlockEntityTag");
        if (tag == null) {
            return FurnitureData.EMPTY;
        }
        int hash = System.identityHashCode(tag = tag.m_128469_(FURNITURE));
        if (!cache.containsKey(hash)) {
            cache.put(hash, new FurnitureData(tag));
        }
        return cache.get(hash);
    }

    public static void setData(ItemStack stack, FurnitureData data) {
        CompoundTag tag = stack.m_41698_("BlockEntityTag");
        tag.m_128365_(FURNITURE, (Tag)data.toTag());
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43725_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(context);
    }

    protected boolean m_40610_(BlockPlaceContext context, BlockState state) {
        if (!super.m_40610_(context, state)) {
            return false;
        }
        FurnitureData data = FurnitureItem.getData(context.m_43722_());
        Level level = context.m_43725_();
        BlockPos basePos = context.m_8083_();
        Direction facing = (Direction)state.m_61143_((Property)FurnitureBlock.FACING);
        for (int x = 0; x < data.size.x; ++x) {
            for (int y = 0; y < data.size.y; ++y) {
                for (int z = 0; z < data.size.z; ++z) {
                    BlockPos proxyPos;
                    if (x == 0 && y == 0 && z == 0 || level.m_8055_(proxyPos = BaseFurnitureBlock.getProxyPosition(basePos, facing, x, y, z)).m_60629_(context)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean m_7429_(BlockPlaceContext context, BlockState state) {
        if (!super.m_7429_(context, state)) {
            return false;
        }
        FurnitureData data = FurnitureItem.getData(context.m_43722_());
        Level level = context.m_43725_();
        BlockPos basePos = context.m_8083_();
        Direction facing = (Direction)state.m_61143_((Property)FurnitureBlock.FACING);
        for (int x = 0; x < data.size.x; ++x) {
            for (int y = 0; y < data.size.y; ++y) {
                for (int z = 0; z < data.size.z; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    BlockPos proxyPos = BaseFurnitureBlock.getProxyPosition(basePos, facing, x, y, z);
                    FluidState fluidstate = context.m_43725_().m_6425_(proxyPos);
                    boolean waterlogged = fluidstate.m_76152_() == Fluids.f_76193_;
                    BlockState proxyState = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)Blocks.FURNITURE_PROXY.m_49966_().m_61124_((Property)FurnitureProxyBlock.OFFSET_X, (Comparable)Integer.valueOf(x))).m_61124_((Property)FurnitureProxyBlock.OFFSET_Y, (Comparable)Integer.valueOf(y))).m_61124_((Property)FurnitureProxyBlock.OFFSET_Z, (Comparable)Integer.valueOf(z))).m_61124_((Property)FurnitureProxyBlock.FACING, (Comparable)facing)).m_61124_((Property)FurnitureProxyBlock.WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
                    level.m_7731_(proxyPos, proxyState, 3);
                }
            }
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ServerFurnitureRegistry.increase(serverLevel, FurnitureItem.getData(context.m_43722_()));
        }
        FurnitureDataManager.saveHashData(data);
        return true;
    }

    protected BlockState m_5965_(BlockPlaceContext context) {
        Level level;
        int identifier = -1;
        ItemStack stack = context.m_43722_();
        FurnitureData data = FurnitureItem.getData(stack);
        if (!data.requiresBlockEntity() && (level = context.m_43725_()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            int from = data.lightLevel > 0 ? 65536 : 0;
            int size = data.lightLevel > 0 ? 256 : 1024;
            identifier = ServerFurnitureRegistry.registerIdentifier(level2, data, from, from + size - 1);
        }
        BlockState state = identifier < 0 ? (BlockState)Objects.requireNonNull(Blocks.FURNITURE_ENTITY.m_5573_(context)).m_61124_((Property)EntityFurnitureBlock.LIGHT, (Comparable)Integer.valueOf(data.lightLevel)) : (data.lightLevel > 0 ? (BlockState)((BlockState)Objects.requireNonNull(Blocks.FURNITURE_LIGHT.m_5573_(context)).m_61124_((Property)LightFurnitureBlock.IDENTIFIER, (Comparable)Integer.valueOf(identifier - 65536))).m_61124_((Property)LightFurnitureBlock.LIGHT, (Comparable)Integer.valueOf((int)Math.ceil((float)data.lightLevel / 3.0f))) : (BlockState)Objects.requireNonNull(Blocks.FURNITURE.m_5573_(context)).m_61124_((Property)FurnitureBlock.IDENTIFIER, (Comparable)Integer.valueOf(identifier)));
        return this.m_40610_(context, state) ? state : null;
    }
}

