/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.entity;

import java.util.ArrayList;
import java.util.Comparator;
import net.conczin.immersive_furniture.block.BaseFurnitureBlock;
import net.conczin.immersive_furniture.entity.Entities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3i;

public class SittingEntity
extends Entity {
    private Vec3 dismountPosition;
    private BlockPos blockPos;
    private Vector3i size;
    private Direction direction;

    public SittingEntity(EntityType<SittingEntity> type, Level level) {
        super(type, level);
    }

    public SittingEntity(Level level, Vec3 pos, BlockPos blockPos, Vector3i size, Direction direction, Vec3 dismountPosition) {
        super(Entities.SITTING, level);
        this.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        this.dismountPosition = dismountPosition;
        this.blockPos = blockPos;
        this.size = size;
        this.direction = direction;
        this.f_19794_ = true;
    }

    public Vec3 tryDismountAt(LivingEntity passenger, BlockPos targetPos, int height) {
        BlockPos.MutableBlockPos pos = targetPos.m_122032_();
        double maxY = pos.m_123342_() + height;
        block0: for (Pose pose : passenger.m_7431_()) {
            pos.m_122190_((Vec3i)targetPos);
            while ((double)pos.m_123342_() < maxY) {
                double floorHeight = this.m_9236_().m_45573_((BlockPos)pos);
                if ((double)pos.m_123342_() + floorHeight > maxY) continue block0;
                if (DismountHelper.m_38439_((double)floorHeight)) {
                    AABB bounds = passenger.m_21270_(pose);
                    Vec3 candidate = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + floorHeight, (double)pos.m_123343_() + 0.5);
                    if (DismountHelper.m_38456_((CollisionGetter)this.m_9236_(), (LivingEntity)passenger, (AABB)bounds.m_82383_(candidate))) {
                        passenger.m_20124_(pose);
                        return candidate;
                    }
                }
                pos.m_122173_(Direction.UP);
            }
        }
        return null;
    }

    public Vec3 m_7688_(LivingEntity passenger) {
        if (this.blockPos == null || this.size == null || this.dismountPosition == null || this.direction == null) {
            return super.m_7688_(passenger);
        }
        double radius = (float)(Math.abs(this.size.x) + Math.abs(this.size.z)) / 2.0f;
        Vec3 center = new Vec3(this.m_20185_() - Math.sin(Math.toRadians(passenger.m_146908_())) * radius, this.m_20186_(), this.m_20189_() + Math.cos(Math.toRadians(passenger.m_146908_())) * radius);
        ArrayList<BlockPos> candidates = new ArrayList<BlockPos>();
        int y = (int)Math.floor(center.f_82480_);
        for (int x = -1; x <= this.size.x(); ++x) {
            candidates.add(BaseFurnitureBlock.getProxyPosition(this.blockPos, this.direction, x, 0, -1));
            candidates.add(BaseFurnitureBlock.getProxyPosition(this.blockPos, this.direction, x, 0, this.size.z()));
        }
        for (int z = -1; z <= this.size.z(); ++z) {
            candidates.add(BaseFurnitureBlock.getProxyPosition(this.blockPos, this.direction, -1, 0, z));
            candidates.add(BaseFurnitureBlock.getProxyPosition(this.blockPos, this.direction, this.size.x(), 0, z));
        }
        candidates.sort(Comparator.comparingDouble(pos -> pos.m_203198_(center.f_82479_, center.f_82480_, center.f_82481_)));
        for (BlockPos pos2 : candidates) {
            Vec3 result = this.tryDismountAt(passenger, pos2, this.size.y);
            if (result == null) continue;
            return result;
        }
        return this.dismountPosition;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!(this.m_9236_().f_46443_ || this.m_20160_() && this.dismountPosition != null || this.m_213877_())) {
            this.m_146870_();
        }
    }

    public void m_7340_(Entity passenger) {
        super.m_7340_(passenger);
        this.clampRotation(passenger);
    }

    protected void m_19956_(Entity passenger, Entity.MoveFunction callback) {
        super.m_19956_(passenger, callback);
        this.clampRotation(passenger);
    }

    public void clampRotation(Entity passenger) {
        float delta = Mth.m_14177_((float)(passenger.m_146908_() - this.m_146908_()));
        float clampedDelta = Mth.m_14036_((float)delta, (float)-105.0f, (float)105.0f);
        passenger.f_19859_ += clampedDelta - delta;
        passenger.m_5618_(this.m_146908_());
        passenger.m_146922_(passenger.m_146908_() + clampedDelta - delta);
        passenger.m_5616_(passenger.m_146908_());
    }

    public double m_6048_() {
        return -0.25;
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag compound) {
    }

    protected void m_7380_(CompoundTag compound) {
    }

    public boolean m_142391_() {
        return false;
    }
}

