/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.client.renderer;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.List;
import java.util.Map;
import net.conczin.immersive_furniture.Common;
import net.conczin.immersive_furniture.block.BaseFurnitureBlock;
import net.conczin.immersive_furniture.block.entity.FurnitureBlockEntity;
import net.conczin.immersive_furniture.client.model.CompositeBakedModel;
import net.conczin.immersive_furniture.client.model.DynamicAtlas;
import net.conczin.immersive_furniture.client.model.FurnitureModelBaker;
import net.conczin.immersive_furniture.client.renderer.ModelBoundingBoxFetcher;
import net.conczin.immersive_furniture.data.FurnitureData;
import net.conczin.immersive_furniture.data.ModelUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.system.MemoryStack;

public class FurnitureBlockEntityRenderer<T extends FurnitureBlockEntity>
implements BlockEntityRenderer<T> {
    private final ItemRenderer itemRenderer;
    private static final RandomSource randomsource = RandomSource.m_216327_();

    public FurnitureBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = context.m_234447_();
    }

    public void render(T blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        int state;
        ++Common.entityRendersTotal;
        FurnitureData data = ((FurnitureBlockEntity)((Object)blockEntity)).getData();
        if (data == null) {
            return;
        }
        BlockState blockState = blockEntity.m_58900_();
        int n = state = (Boolean)blockState.m_61143_((Property)BaseFurnitureBlock.ACTIVE) != false ? 1 : 0;
        if (FurnitureBlockEntityRenderer.hasItems(blockEntity, data, state)) {
            poseStack.m_85836_();
            FurnitureBlockEntityRenderer.rotate(blockState, poseStack);
            FurnitureBlockEntityRenderer.drawItems(this.itemRenderer, blockEntity.m_58904_(), blockEntity, state, poseStack, buffer, packedLight, packedOverlay, data);
            poseStack.m_85849_();
        }
        if (DynamicAtlas.BAKED.knownFurniture.containsKey(data.getHash())) {
            return;
        }
        ++Common.entityRenders;
        poseStack.m_85836_();
        FurnitureBlockEntityRenderer.rotate(blockState, poseStack);
        FurnitureBlockEntityRenderer.renderFurniture(blockState, poseStack, buffer, packedLight, packedOverlay, data);
        poseStack.m_85849_();
    }

    private static void rotate(BlockState blockState, PoseStack poseStack) {
        if (blockState.m_60734_() instanceof BaseFurnitureBlock) {
            float yaw = -((Direction)blockState.m_61143_((Property)BaseFurnitureBlock.FACING)).m_122424_().m_122435_();
            poseStack.m_252880_(0.5f, 0.5f, 0.5f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(yaw));
            poseStack.m_252880_(-0.5f, -0.5f, -0.5f);
        }
    }

    public static boolean hasItems(FurnitureBlockEntity blockEntity, FurnitureData data, int state) {
        int slot = 0;
        for (FurnitureData.Element element : data.elements) {
            ItemStack itemstack;
            if (element.type != FurnitureData.ElementType.SPRITE || !element.sprite.item || !element.isMasked(state)) continue;
            ItemStack itemStack = itemstack = blockEntity == null ? Items.f_42410_.m_7968_() : blockEntity.m_8020_(slot);
            if (!itemstack.m_41619_()) {
                return true;
            }
            ++slot;
        }
        return false;
    }

    public static void drawItems(ItemRenderer itemRenderer, Level level, FurnitureBlockEntity blockEntity, int state, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay, FurnitureData data) {
        int slot = 0;
        for (FurnitureData.Element element : data.elements) {
            if (element.type != FurnitureData.ElementType.SPRITE || !element.sprite.item || !element.isMasked(state)) continue;
            ItemStack itemStack = blockEntity == null ? (slot % 4 == 0 ? Items.f_42410_.m_7968_() : (slot % 4 == 1 ? Items.f_41962_.m_7968_() : (slot % 4 == 2 ? Items.f_42390_.m_7968_() : Items.f_42038_.m_7968_()))) : blockEntity.m_8020_(slot);
            if (itemStack.m_41619_()) continue;
            Vector3f center = element.getCenter();
            Quaternionf quaternion = ModelUtils.getElementRotation(element.getRotation());
            poseStack.m_85836_();
            poseStack.m_85837_((double)center.x / 16.0, (double)center.y / 16.0, (double)center.z / 16.0);
            poseStack.m_252781_(quaternion);
            poseStack.m_85841_(element.sprite.size, element.sprite.size, element.sprite.size);
            BakedModel bakedmodel = itemRenderer.m_174264_(itemStack, level, null, slot);
            AABB box = ModelBoundingBoxFetcher.INSTANCE.getModelBoundingBox(bakedmodel);
            if (element.sprite.align) {
                poseStack.m_85837_(0.0, -0.5 - box.f_82289_, 0.0);
            } else {
                poseStack.m_85837_(0.0, 0.0, box.f_82290_);
            }
            itemRenderer.m_115143_(itemStack, ItemDisplayContext.FIXED, false, poseStack, buffer, packedLight, packedOverlay, bakedmodel);
            poseStack.m_85849_();
            ++slot;
        }
    }

    public static void renderFurniture(BlockState state, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay, FurnitureData data) {
        FurnitureBlockEntityRenderer.renderFurniture(state, poseStack, buffer, packedLight, packedOverlay, FurnitureModelBaker.getModel(data, DynamicAtlas.ENTITY), DynamicAtlas.ENTITY);
    }

    public static void renderFurniture(BlockState state, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay, CompositeBakedModel bakedModel, DynamicAtlas atlas) {
        for (int i = 0; i < 2; ++i) {
            ResourceLocation location = i == 0 ? atlas.getLocation() : InventoryMenu.f_39692_;
            for (Map.Entry<RenderType, BakedModel> entry : bakedModel.getModels().entrySet()) {
                VertexConsumer consumer = entry.getKey() == RenderType.m_110463_() || entry.getKey() == RenderType.m_110457_() ? buffer.m_6299_(RenderType.m_110452_((ResourceLocation)location)) : (entry.getKey() == RenderType.m_110466_() ? buffer.m_6299_(RenderType.m_110470_((ResourceLocation)location)) : buffer.m_6299_(RenderType.m_110446_((ResourceLocation)location)));
                FurnitureBlockEntityRenderer.renderModel(poseStack.m_85850_(), consumer, state, entry.getValue(), packedLight, packedOverlay, i == 1);
            }
        }
    }

    private static void renderModel(PoseStack.Pose pose, VertexConsumer consumer, BlockState state, BakedModel model, int packedLight, int packedOverlay, boolean blocksAtlas) {
        for (Direction direction : SignalGetter.f_276432_) {
            FurnitureBlockEntityRenderer.renderQuadList(pose, consumer, model.m_213637_(state, direction, randomsource), packedLight, packedOverlay, blocksAtlas);
        }
        FurnitureBlockEntityRenderer.renderQuadList(pose, consumer, model.m_213637_(state, null, randomsource), packedLight, packedOverlay, blocksAtlas);
    }

    private static void renderQuadList(PoseStack.Pose pose, VertexConsumer consumer, List<BakedQuad> quads, int packedLight, int packedOverlay, boolean blocksAtlas) {
        for (BakedQuad quad : quads) {
            ResourceLocation resourceLocation = quad.m_173410_().m_247685_();
            if (resourceLocation.m_135827_().equals("minecraft") != blocksAtlas) continue;
            FurnitureBlockEntityRenderer.putBulkData(consumer, pose, quad, packedLight, packedOverlay);
        }
    }

    static void putBulkData(VertexConsumer consumer, PoseStack.Pose pose, BakedQuad quad, int packedLight, int packedOverlay) {
        int[] vertices = quad.m_111303_();
        Vec3i quadNormal = quad.m_111306_().m_122436_();
        Matrix4f matrix4f = pose.m_252922_();
        Vector3f normal = pose.m_252943_().transform(new Vector3f((float)quadNormal.m_123341_(), (float)quadNormal.m_123342_(), (float)quadNormal.m_123343_()));
        int vertexCount = vertices.length / 8;
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            ByteBuffer bytebuffer = memorystack.malloc(DefaultVertexFormat.f_85811_.m_86020_());
            IntBuffer intbuffer = bytebuffer.asIntBuffer();
            for (int i = 0; i < vertexCount; ++i) {
                intbuffer.clear();
                intbuffer.put(vertices, i * 8, 8);
                float x = bytebuffer.getFloat(0);
                float y = bytebuffer.getFloat(4);
                float z = bytebuffer.getFloat(8);
                Vector4f pos = matrix4f.transform(new Vector4f(x, y, z, 1.0f));
                float red = (float)(bytebuffer.get(12) & 0xFF) / 255.0f;
                float green = (float)(bytebuffer.get(13) & 0xFF) / 255.0f;
                float blue = (float)(bytebuffer.get(14) & 0xFF) / 255.0f;
                float u = bytebuffer.getFloat(16);
                float v = bytebuffer.getFloat(20);
                int light = FurnitureBlockEntityRenderer.blend(packedLight, quad.m_111303_()[i * 8 + 6]);
                consumer.m_5954_(pos.x(), pos.y(), pos.z(), red, green, blue, 1.0f, u, v, packedOverlay, light, normal.x(), normal.y(), normal.z());
            }
        }
    }

    private static int blend(int worldLight, int vertexLight) {
        return Math.max(worldLight & 0xFFFF, vertexLight & 0xFFFF) | Math.max(worldLight >> 16 & 0xFFFF, vertexLight >> 16 & 0xFFFF) << 16;
    }
}

