/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.block;

import java.util.List;
import net.conczin.immersive_furniture.InteractionManager;
import net.conczin.immersive_furniture.block.FurnitureProxyBlock;
import net.conczin.immersive_furniture.config.Config;
import net.conczin.immersive_furniture.data.FurnitureData;
import net.conczin.immersive_furniture.entity.SittingEntity;
import net.conczin.immersive_furniture.item.FurnitureItem;
import net.conczin.immersive_furniture.item.Items;
import net.conczin.immersive_furniture.network.Network;
import net.conczin.immersive_furniture.network.s2c.FurnitureInteractMessage;
import net.conczin.immersive_furniture.network.s2c.PoseOffsetMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class BaseFurnitureBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");

    public BaseFurnitureBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        FurnitureData data = this.getData(state, (BlockGetter)level, pos);
        if (data != null) {
            Vec3 click = new Vec3(hit.m_82450_().f_82479_ - (double)pos.m_123341_(), hit.m_82450_().f_82480_ - (double)pos.m_123342_(), hit.m_82450_().f_82481_ - (double)pos.m_123343_());
            FurnitureData.PoseOffset offset = data.getClosestPose(click, (Direction)state.m_61143_((Property)FACING));
            boolean consume = false;
            if (offset != null) {
                InteractionManager.INSTANCE.addInteraction((Entity)player, pos, offset);
                if (offset.pose() == Pose.SLEEPING) {
                    BaseFurnitureBlock.startSleeping(pos, player, offset);
                } else if (offset.pose() == Pose.SITTING) {
                    BaseFurnitureBlock.startSitting(data, level, pos, (Direction)state.m_61143_((Property)FACING), player, offset);
                }
                consume = true;
            }
            consume = this.trigger(data, state, level, pos, data.toggleWithRightClick) || consume;
            return consume ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    public boolean trigger(FurnitureData data, BlockState state, Level level, BlockPos pos, boolean toggle) {
        boolean consume = false;
        if (toggle) {
            state = (BlockState)state.m_61122_((Property)ACTIVE);
            state = this.toggleLight(data, state, level, pos);
            level.m_7731_(pos, state, data.getUniqueSolidStates().size() > 1 ? 3 : 7);
            consume = true;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (data.hasSounds() || data.hasParticles()) {
                Boolean active = (Boolean)state.m_61143_((Property)ACTIVE);
                FurnitureInteractMessage message = new FurnitureInteractMessage(pos, active);
                int maxDist = Config.getInstance().maximumInteractDistance;
                serverLevel.m_7654_().m_6846_().m_11314_().forEach(p -> {
                    double dist = pos.m_203198_(p.m_20185_(), p.m_20186_(), p.m_20189_());
                    if (maxDist <= 0 || dist < (double)(maxDist * maxDist)) {
                        Network.sendToPlayer(message, p);
                    }
                });
                consume = true;
            }
        }
        return consume;
    }

    public BlockState toggleLight(FurnitureData data, BlockState state, Level level, BlockPos pos) {
        return state;
    }

    public void onInteract(Level level, BlockState blockState, BlockPos pos, boolean active, Player player) {
        FurnitureData data = this.getData(blockState, (BlockGetter)level, pos);
        if (data != null) {
            Direction facing = (Direction)blockState.m_61143_((Property)FACING);
            int state = active ? 1 : 0;
            data.playInteractSound(level, pos, state, player);
            data.emitInteractParticles(pos, facing, state, player, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((Level)level).m_7106_(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), false);
        }
    }

    private static void startSleeping(BlockPos pos, Player player, FurnitureData.PoseOffset offset) {
        ServerPlayer serverPlayer;
        if (player.m_9236_().f_46443_) {
            return;
        }
        if (player instanceof ServerPlayer) {
            serverPlayer = (ServerPlayer)player;
            PoseOffsetMessage message = new PoseOffsetMessage(pos, offset, (Entity)serverPlayer);
            Network.sendToAllPlayers(serverPlayer.m_284548_().m_7654_(), message);
        }
        player.m_7720_(pos).ifLeft(problem -> {
            if (problem.m_36423_() != null) {
                player.m_5661_(problem.m_36423_(), true);
            }
        });
        if (player instanceof ServerPlayer) {
            serverPlayer = (ServerPlayer)player;
            serverPlayer.m_9158_(player.m_9236_().m_46472_(), pos, player.m_146908_(), true, true);
        }
    }

    private static void startSitting(FurnitureData data, Level level, BlockPos pos, Direction direction, Player player, FurnitureData.PoseOffset offset) {
        if (!level.f_46443_) {
            Vec3 position = new Vec3((double)((float)pos.m_123341_() + offset.offset().x), (double)((float)pos.m_123342_() + offset.offset().y), (double)((float)pos.m_123343_() + offset.offset().z));
            SittingEntity sittingEntity = new SittingEntity(level, position, pos, data.size, direction, new Vec3(player.m_20185_(), player.m_20186_(), player.m_20189_()));
            sittingEntity.m_146922_(offset.rotation());
            player.m_20329_((Entity)sittingEntity);
            sittingEntity.clampRotation((Entity)player);
            level.m_7967_((Entity)sittingEntity);
        }
        player.f_19812_ = true;
    }

    public abstract FurnitureData getData(BlockState var1, BlockGetter var2, BlockPos var3);

    public void m_214162_(BlockState blockState, Level level, BlockPos pos, RandomSource random) {
        FurnitureData data = this.getData(blockState, (BlockGetter)level, pos);
        if (data != null) {
            Direction facing = (Direction)blockState.m_61143_((Property)FACING);
            int state = (Boolean)blockState.m_61143_((Property)ACTIVE) != false ? 1 : 0;
            data.tick(level, pos, state, facing, random, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((Level)level).m_7106_(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), false, false);
        }
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape shape;
        FurnitureData data = this.getData(state, level, pos);
        if (data != null && (shape = data.getShapeLazy((Direction)state.m_61143_((Property)FACING), (Boolean)state.m_61143_((Property)ACTIVE) != false ? 1 : 0, 0, 0, 0)) != null) {
            return shape;
        }
        return Block.m_49796_((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean m_7361_(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidState) {
        if (!((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue() && fluidState.m_76152_() == Fluids.f_76193_) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
            level.m_186469_(pos, fluidState.m_76152_(), fluidState.m_76152_().m_6718_((LevelReader)level));
            return true;
        }
        return false;
    }

    public FluidState m_5888_(BlockState state) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            return Fluids.f_76193_.m_76068_(false);
        }
        return super.m_5888_(state);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public Item m_5456_() {
        return Items.FURNITURE;
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        ItemStack itemStack = new ItemStack((ItemLike)this.m_5456_());
        FurnitureData data = this.getData(state, level, pos);
        if (data != null) {
            FurnitureItem.setData(itemStack, data);
        }
        return itemStack;
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder params) {
        return List.of();
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.f_46443_) {
            FurnitureData data = this.getData(state, (BlockGetter)level, pos);
            if (data != null) {
                Direction facing = (Direction)state.m_61143_((Property)FACING);
                for (int x = 0; x < data.size.x; ++x) {
                    for (int y = 0; y < data.size.y; ++y) {
                        for (int z = 0; z < data.size.z; ++z) {
                            BlockPos proxyPos;
                            BlockState proxyState;
                            if (x == 0 && y == 0 && z == 0 || !((proxyState = level.m_8055_(proxyPos = BaseFurnitureBlock.getProxyPosition(pos, facing, x, y, z))).m_60734_() instanceof FurnitureProxyBlock)) continue;
                            level.m_7471_(proxyPos, false);
                        }
                    }
                }
                AABB aabb = new AABB(pos, pos.m_7918_(data.size.x, data.size.y, data.size.z)).m_82400_(1.0);
                level.m_45976_(SittingEntity.class, aabb).forEach(Entity::m_20153_);
            }
            if (!player.m_7500_()) {
                ItemStack itemStack = this.m_7397_((BlockGetter)level, pos, state);
                Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)itemStack);
            }
        }
        super.m_5707_(level, pos, state, player);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos pos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)level.m_7702_(pos));
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        FurnitureData data;
        boolean flag;
        if (!level.f_46443_ && (flag = ((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue()) != level.m_276867_(pos) && (data = this.getData(state, (BlockGetter)level, pos)) != null) {
            this.trigger(data, state, level, pos, true);
        }
    }

    public static BlockPos getProxyPosition(BlockPos basePos, Direction facing, int offsetX, int offsetY, int offsetZ) {
        int dx = 0;
        int dz = 0;
        switch (facing) {
            case NORTH: {
                dz = offsetZ;
                dx = offsetX;
                break;
            }
            case SOUTH: {
                dz = -offsetZ;
                dx = -offsetX;
                break;
            }
            case EAST: {
                dx = -offsetZ;
                dz = offsetX;
                break;
            }
            case WEST: {
                dx = offsetZ;
                dz = -offsetX;
                break;
            }
        }
        return basePos.m_7918_(dx, offsetY, dz);
    }
}

