/*
 * Decompiled with CFR 0.152.
 */
package telepathicgrunt.structure_layout_optimizer.utils;

import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMaps;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.NotNull;
import telepathicgrunt.structure_layout_optimizer.services.PlatformService;

public class StructureTemplateOptimizer {
    private static final Map<StructureProcessor, Boolean> FINALIZE_PROCESSING_PROCESSORS = Object2BooleanMaps.synchronize((Object2BooleanMap)new Object2BooleanOpenHashMap());
    private static final String FINALIZE_PROCESSING_METHOD_NAME = PlatformService.INSTANCE.getFinalizeProcessingMethodName();

    @NotNull
    public static List<StructureTemplate.StructureBlockInfo> getStructureBlockInfosInBounds(StructureTemplate.Palette palette, BlockPos offset, StructurePlaceSettings structurePlaceSettings) {
        BoundingBox boundingBox = structurePlaceSettings.m_74409_();
        List originalPositions = palette.m_74652_();
        if (boundingBox == null) {
            return originalPositions;
        }
        for (StructureProcessor processor : structurePlaceSettings.m_74411_()) {
            if (!FINALIZE_PROCESSING_PROCESSORS.computeIfAbsent(processor, StructureTemplateOptimizer::isFinalizeProcessor).booleanValue()) continue;
            return palette.m_74652_();
        }
        Mirror mirror = structurePlaceSettings.m_74401_();
        Rotation rotation = structurePlaceSettings.m_74404_();
        BlockPos pivot = structurePlaceSettings.m_74407_();
        ArrayList<StructureTemplate.StructureBlockInfo> listOfInBoundsRelativePositions = new ArrayList<StructureTemplate.StructureBlockInfo>();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (StructureTemplate.StructureBlockInfo blockInfo : palette.m_74652_()) {
            mutableBlockPos.m_122190_((Vec3i)blockInfo.f_74675_());
            StructureTemplateOptimizer.transform(mutableBlockPos, mirror, rotation, pivot);
            mutableBlockPos.m_122193_((Vec3i)offset);
            if (!boundingBox.m_71051_((Vec3i)mutableBlockPos)) continue;
            listOfInBoundsRelativePositions.add(blockInfo);
        }
        if (listOfInBoundsRelativePositions.isEmpty() && !originalPositions.isEmpty()) {
            listOfInBoundsRelativePositions.add((StructureTemplate.StructureBlockInfo)originalPositions.get(0));
        }
        return listOfInBoundsRelativePositions;
    }

    @NotNull
    private static Boolean isFinalizeProcessor(StructureProcessor structureProcessor) {
        try {
            Method method = structureProcessor.getClass().getMethod(FINALIZE_PROCESSING_METHOD_NAME, ServerLevelAccessor.class, BlockPos.class, BlockPos.class, List.class, List.class, StructurePlaceSettings.class);
            return method.getDeclaringClass() != StructureProcessor.class;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Unable to find 'finalizeProcessing' method. Report this major issue to Dev of structure_layout_optimizer", e);
        }
    }

    private static void transform(BlockPos.MutableBlockPos mutableBlockPos, Mirror mirror, Rotation rotation, BlockPos pivot) {
        int i = mutableBlockPos.m_123341_();
        int j = mutableBlockPos.m_123342_();
        int k = mutableBlockPos.m_123343_();
        boolean flag = true;
        switch (mirror) {
            case LEFT_RIGHT: {
                k = -k;
                break;
            }
            case FRONT_BACK: {
                i = -i;
                break;
            }
            default: {
                flag = false;
            }
        }
        int l = pivot.m_123341_();
        int i1 = pivot.m_123343_();
        switch (rotation) {
            case COUNTERCLOCKWISE_90: {
                mutableBlockPos.m_122178_(l - i1 + k, j, l + i1 - i);
                return;
            }
            case CLOCKWISE_90: {
                mutableBlockPos.m_122178_(l + i1 - k, j, i1 - l + i);
                return;
            }
            case CLOCKWISE_180: {
                mutableBlockPos.m_122178_(l + l - i, j, i1 + i1 - k);
                return;
            }
        }
        if (flag) {
            mutableBlockPos.m_122178_(i, j, k);
        }
    }
}

