/*
 * Decompiled with CFR 0.152.
 */
package expr;

class Token {
    public static final int TT_ERROR = -1;
    public static final int TT_EOF = -2;
    public static final int TT_NUMBER = -3;
    public static final int TT_WORD = -4;
    public static final int TT_LE = -5;
    public static final int TT_NE = -6;
    public static final int TT_GE = -7;
    public final int ttype;
    public final String sval;
    public final double nval;
    public final int location;
    public final int leadingWhitespace;
    public final int trailingWhitespace;

    public Token(int ttype, double nval, String input, int start, int end) {
        int i;
        this.ttype = ttype;
        this.sval = input.substring(start, end);
        this.nval = nval;
        this.location = start;
        int count = 0;
        for (i = start - 1; 0 <= i && Character.isWhitespace(input.charAt(i)); --i) {
            ++count;
        }
        this.leadingWhitespace = count;
        count = 0;
        for (i = end; i < input.length() && Character.isWhitespace(input.charAt(i)); ++i) {
            ++count;
        }
        this.trailingWhitespace = count;
    }

    Token(int ttype, double nval, String sval, Token token) {
        this.ttype = ttype;
        this.sval = sval;
        this.nval = nval;
        this.location = token.location;
        this.leadingWhitespace = token.leadingWhitespace;
        this.trailingWhitespace = token.trailingWhitespace;
    }
}

