/*
 * Decompiled with CFR 0.152.
 */
package expr;

import expr.Expr;
import expr.Parser;
import expr.SyntaxException;
import expr.Variable;

public class RegressionTest {
    public static void main(String[] args) {
        Variable.make("pi").setValue(Math.PI);
        RegressionTest.expect(9.0, "3^2");
        RegressionTest.expect(256.0, "2^2^3");
        RegressionTest.expect(6.0, "3*2");
        RegressionTest.expect(1.5, "3/2");
        RegressionTest.expect(5.0, "3+2");
        RegressionTest.expect(1.0, "3-2");
        RegressionTest.expect(-3.0, "-3");
        RegressionTest.expect(1.0, "2<3");
        RegressionTest.expect(0.0, "2<2");
        RegressionTest.expect(0.0, "3<2");
        RegressionTest.expect(1.0, "2<=3");
        RegressionTest.expect(1.0, "2<=2");
        RegressionTest.expect(0.0, "3<=2");
        RegressionTest.expect(0.0, "2=3");
        RegressionTest.expect(1.0, "2=2");
        RegressionTest.expect(1.0, "2<>3");
        RegressionTest.expect(0.0, "2<>2");
        RegressionTest.expect(0.0, "2>=3");
        RegressionTest.expect(1.0, "2>=2");
        RegressionTest.expect(1.0, "3>=2");
        RegressionTest.expect(0.0, "2>3");
        RegressionTest.expect(0.0, "2>2");
        RegressionTest.expect(1.0, "3>2");
        RegressionTest.expect(1.0, "(1 and 1)");
        RegressionTest.expect(0.0, "(1 and 0)");
        RegressionTest.expect(0.0, "(0 and 1)");
        RegressionTest.expect(0.0, "(0 and 0)");
        RegressionTest.expect(1.0, "(1 or 1)");
        RegressionTest.expect(1.0, "(1 or 0)");
        RegressionTest.expect(1.0, "(0 or 1)");
        RegressionTest.expect(0.0, "(0 or 0)");
        RegressionTest.expect(2.0, "abs(-2)");
        RegressionTest.expect(2.0, "abs(2)");
        RegressionTest.expect(0.0, "acos(1)");
        RegressionTest.expect(1.5707963267948966, "asin(1)");
        RegressionTest.expect(0.7853981633974483, "atan(1)");
        RegressionTest.expect(-2.356194490192345, "atan2(-1, -1)");
        RegressionTest.expect(4.0, "ceil(3.5)");
        RegressionTest.expect(-3.0, "ceil(-3.5)");
        RegressionTest.expect(1.0, "cos(0)");
        RegressionTest.expect(Math.exp(1.0), "exp(1)");
        RegressionTest.expect(3.0, "floor(3.5)");
        RegressionTest.expect(-4.0, "floor(-3.5)");
        RegressionTest.expect(1.0, "log(2.7182818284590451)");
        RegressionTest.expect(4.0, "round(3.5)");
        RegressionTest.expect(-4.0, "round(-3.5)");
        RegressionTest.expect(1.0, "sin(pi/2)");
        RegressionTest.expect(3.0, "sqrt(9)");
        RegressionTest.expect(0.9999999999999999, "tan(pi/4)");
        RegressionTest.expect(3.0, "max(2, 3)");
        RegressionTest.expect(2.0, "min(2, 3)");
        RegressionTest.expect(137.0, "if(0, 42, 137)");
        RegressionTest.expect(42.0, "if(1, 42, 137)");
        RegressionTest.expect(-3.0 * Math.pow(1.01, 100.1), "  -3 * 1.01^100.1  ");
        Variable x = Variable.make("x");
        x.setValue(-40.0);
        RegressionTest.expect(-171.375208, "-0.00504238 * x^2 + 2.34528 * x - 69.4962");
        boolean caught = false;
        Parser p = new Parser();
        p.allow(x);
        try {
            p.parseString("whoo");
        }
        catch (SyntaxException se) {
            caught = true;
        }
        if (!caught) {
            throw new Error("Test failed: unknown variable allowed");
        }
        x.setValue(1.1);
        RegressionTest.expect(137.0, "137");
        RegressionTest.expect(Math.PI, "pi");
        RegressionTest.expect(1.1, "x");
        RegressionTest.expect(3.8013239000000003, "3.14159 * x^2");
        RegressionTest.expect(-1.457526100326025, "sin(10*x) + sin(9*x)");
        RegressionTest.expect(0.8907649332805846, "sin(x) + sin(100*x)/100");
        RegressionTest.expect(-0.16000473871962462, "sin(0.1*x) * (sin(9*x) + sin(10*x))");
        RegressionTest.expect(0.29819727942988733, "exp(-x^2)");
        RegressionTest.expect(0.43226861565393254, "2^(-x^2)");
        RegressionTest.expect(0.7075295010833899, "(x^3)^(-x^2)");
        RegressionTest.expect(0.8678400091286832, "x*sin(1/x)");
        RegressionTest.expect(-5.89, "x^2-x-6");
        RegressionTest.expect(3.1953090617340916, "sqrt(3^2 + x^2)");
        RegressionTest.expect(1.3542460218188073, "atan(5/x)");
        RegressionTest.expect(1.5761904761904764, "(x^2 + x + 1)/(x + 1)");
        RegressionTest.expect(2.6451713395638627, "(x^3 - (4*x^2) + 12)/(x^2 + 2)");
        RegressionTest.expect(-2.2199999999999998, "-2*(x-3)^2+5");
        RegressionTest.expect(1.2000000000000002, "2*abs(x+1)-3");
        RegressionTest.expect(2.7910571473905725, "sqrt(9-x^2)");
        System.out.println("All tests passed.");
    }

    private static void expect(double expected, String input) {
        Expr expr;
        try {
            expr = Parser.parse(input);
        }
        catch (SyntaxException e) {
            throw new Error(e.explain());
        }
        double result = expr.value();
        if (result != expected) {
            throw new Error("Bad result: " + result + " instead of the expected " + expected + " in \"" + input + "\"");
        }
    }
}

