/*
 * Decompiled with CFR 0.152.
 */
package expr;

import expr.Expr;
import expr.Scanner;
import expr.SyntaxException;
import expr.Token;
import expr.Variable;
import java.util.Hashtable;
import java.util.Vector;

public class Parser {
    private static final Variable pi = Variable.make("pi");
    private Hashtable allowedVariables = null;
    Scanner tokens = null;
    private Token token = null;
    private static final String operatorChars = "*/+-^<>=,()";
    private static final String[] procs1;
    private static final int[] rators1;
    private static final String[] procs2;
    private static final int[] rators2;

    public static Expr parse(String input) throws SyntaxException {
        return new Parser().parseString(input);
    }

    public void allow(Variable optVariable) {
        if (null == this.allowedVariables) {
            this.allowedVariables = new Hashtable();
            this.allowedVariables.put(pi, pi);
        }
        if (null != optVariable) {
            this.allowedVariables.put(optVariable, optVariable);
        }
    }

    public Expr parseString(String input) throws SyntaxException {
        this.tokens = new Scanner(input, operatorChars);
        return this.reparse();
    }

    private Expr reparse() throws SyntaxException {
        this.tokens.index = -1;
        this.nextToken();
        Expr expr = this.parseExpr(0);
        if (this.token.ttype != -2) {
            throw this.error("Incomplete expression", 0, null);
        }
        expr.setInput(this.tokens.getInput());
        return expr;
    }

    private void nextToken() {
        this.token = this.tokens.nextToken();
    }

    private Expr parseExpr(int precedence) throws SyntaxException {
        Expr expr = this.parseFactor();
        block13: while (true) {
            int rator;
            int r;
            int l;
            switch (this.token.ttype) {
                case 60: {
                    l = 20;
                    r = 21;
                    rator = 8;
                    break;
                }
                case -5: {
                    l = 20;
                    r = 21;
                    rator = 9;
                    break;
                }
                case 61: {
                    l = 20;
                    r = 21;
                    rator = 10;
                    break;
                }
                case -6: {
                    l = 20;
                    r = 21;
                    rator = 11;
                    break;
                }
                case -7: {
                    l = 20;
                    r = 21;
                    rator = 12;
                    break;
                }
                case 62: {
                    l = 20;
                    r = 21;
                    rator = 13;
                    break;
                }
                case 43: {
                    l = 30;
                    r = 31;
                    rator = 0;
                    break;
                }
                case 45: {
                    l = 30;
                    r = 31;
                    rator = 1;
                    break;
                }
                case 47: {
                    l = 40;
                    r = 41;
                    rator = 3;
                    break;
                }
                case 42: {
                    l = 40;
                    r = 41;
                    rator = 2;
                    break;
                }
                case 94: {
                    l = 50;
                    r = 50;
                    rator = 4;
                    break;
                }
                default: {
                    if (this.token.ttype == -4 && this.token.sval.equals("and")) {
                        l = 5;
                        r = 6;
                        rator = 14;
                        break;
                    }
                    if (this.token.ttype != -4 || !this.token.sval.equals("or")) break block13;
                    l = 10;
                    r = 11;
                    rator = 15;
                }
            }
            if (l < precedence) break;
            this.nextToken();
            expr = Expr.makeApp2(rator, expr, this.parseExpr(r));
        }
        return expr;
    }

    private Expr parseFactor() throws SyntaxException {
        switch (this.token.ttype) {
            case -3: {
                Expr lit = Expr.makeLiteral(this.token.nval);
                this.nextToken();
                return lit;
            }
            case -4: {
                int i;
                for (i = 0; i < procs1.length; ++i) {
                    if (!procs1[i].equals(this.token.sval)) continue;
                    this.nextToken();
                    this.expect(40);
                    Expr rand = this.parseExpr(0);
                    this.expect(41);
                    return Expr.makeApp1(rators1[i], rand);
                }
                for (i = 0; i < procs2.length; ++i) {
                    if (!procs2[i].equals(this.token.sval)) continue;
                    this.nextToken();
                    this.expect(40);
                    Expr rand1 = this.parseExpr(0);
                    this.expect(44);
                    Expr rand2 = this.parseExpr(0);
                    this.expect(41);
                    return Expr.makeApp2(rators2[i], rand1, rand2);
                }
                if (this.token.sval.equals("if")) {
                    this.nextToken();
                    this.expect(40);
                    Expr test = this.parseExpr(0);
                    this.expect(44);
                    Expr consequent = this.parseExpr(0);
                    this.expect(44);
                    Expr alternative = this.parseExpr(0);
                    this.expect(41);
                    return Expr.makeIfThenElse(test, consequent, alternative);
                }
                Variable var = Variable.make(this.token.sval);
                if (null != this.allowedVariables && null == this.allowedVariables.get(var)) {
                    throw this.error("Unknown variable", 4, null);
                }
                this.nextToken();
                return var;
            }
            case 40: {
                this.nextToken();
                Expr enclosed = this.parseExpr(0);
                this.expect(41);
                return enclosed;
            }
            case 45: {
                this.nextToken();
                return Expr.makeApp1(109, this.parseExpr(35));
            }
            case -2: {
                throw this.error("Expected a factor", 2, null);
            }
        }
        throw this.error("Expected a factor", 1, null);
    }

    private SyntaxException error(String complaint, int reason, String expected) {
        return new SyntaxException(complaint, this, reason, expected);
    }

    private void expect(int ttype) throws SyntaxException {
        if (this.token.ttype != ttype) {
            throw this.error("'" + (char)ttype + "' expected", 3, "" + (char)ttype);
        }
        this.nextToken();
    }

    boolean tryCorrections() {
        return this.tryInsertions() || this.tryDeletions() || this.trySubstitutions();
    }

    private boolean tryInsertions() {
        Vector v = this.tokens.tokens;
        for (int i = this.tokens.index; 0 <= i; --i) {
            Token[] candidates;
            Token t;
            if (i < v.size()) {
                t = (Token)v.elementAt(i);
            } else {
                String s = this.tokens.getInput();
                t = new Token(-2, 0.0, s, s.length(), s.length());
            }
            for (Token candidate : candidates = this.possibleInsertions(t)) {
                v.insertElementAt(candidate, i);
                try {
                    this.reparse();
                    return true;
                }
                catch (SyntaxException se) {
                    v.removeElementAt(i);
                }
            }
        }
        return false;
    }

    private boolean tryDeletions() {
        Vector v = this.tokens.tokens;
        for (int i = this.tokens.index; 0 <= i; --i) {
            if (v.size() <= i) continue;
            Object t = v.elementAt(i);
            v.remove(i);
            try {
                this.reparse();
                return true;
            }
            catch (SyntaxException se) {
                v.insertElementAt(t, i);
            }
        }
        return false;
    }

    private boolean trySubstitutions() {
        Vector v = this.tokens.tokens;
        for (int i = this.tokens.index; 0 <= i; --i) {
            if (v.size() <= i) continue;
            Token t = (Token)v.elementAt(i);
            Token[] candidates = this.possibleSubstitutions(t);
            for (int j = 0; j < candidates.length; ++j) {
                v.setElementAt(candidates[j], i);
                try {
                    this.reparse();
                    return true;
                }
                catch (SyntaxException syntaxException) {
                    continue;
                }
            }
            v.setElementAt(t, i);
        }
        return false;
    }

    private Token[] possibleInsertions(Token t) {
        Token[] ts = new Token[operatorChars.length() + 6 + procs1.length + procs2.length];
        int i = 0;
        Token one = new Token(-3, 1.0, "1", t);
        ts[i++] = one;
        for (int j = 0; j < operatorChars.length(); ++j) {
            char c = operatorChars.charAt(j);
            ts[i++] = new Token(c, 0.0, Character.toString(c), t);
        }
        ts[i++] = new Token(-4, 0.0, "x", t);
        for (int k = 0; k < procs1.length; ++k) {
            ts[i++] = new Token(-4, 0.0, procs1[k], t);
        }
        for (int m = 0; m < procs2.length; ++m) {
            ts[i++] = new Token(-4, 0.0, procs2[m], t);
        }
        ts[i++] = new Token(-5, 0.0, "<=", t);
        ts[i++] = new Token(-6, 0.0, "<>", t);
        ts[i++] = new Token(-7, 0.0, ">=", t);
        ts[i++] = new Token(-4, 0.0, "if", t);
        return ts;
    }

    private Token[] possibleSubstitutions(Token t) {
        return this.possibleInsertions(t);
    }

    public Scanner getTokens() {
        return this.tokens;
    }

    static {
        pi.setValue(Math.PI);
        procs1 = new String[]{"abs", "acos", "asin", "atan", "ceil", "cos", "exp", "floor", "log", "round", "sin", "sqrt", "tan"};
        rators1 = new int[]{100, 101, 102, 103, 104, 105, 106, 107, 108, 110, 111, 112, 113};
        procs2 = new String[]{"atan2", "max", "min"};
        rators2 = new int[]{5, 6, 7};
    }
}

