/*
 * Decompiled with CFR 0.152.
 */
package expr;

import expr.Expr;
import expr.Parser;
import expr.SyntaxException;
import expr.Variable;

public class Benchmark {
    static final int nruns = 1000000;
    static final int nparses = 1000;

    public static void main(String[] args) {
        double parse_product = 1.0;
        double run_product = 1.0;
        for (String arg : args) {
            long parsetime = Benchmark.timeParse(arg);
            long runtime = Benchmark.timeRun(arg);
            System.out.println(Benchmark.msec(parsetime) + " ms(parse) " + Benchmark.msec(runtime) + " ms(run): " + arg);
            parse_product *= (double)parsetime;
            run_product *= (double)runtime;
        }
        if (0 < args.length) {
            double run_geomean = Math.pow(run_product, 1.0 / (double)args.length);
            double parse_geomean = Math.pow(parse_product, 1.0 / (double)args.length);
            System.out.println(Benchmark.msec(parse_geomean) + " ms(parse) " + Benchmark.msec(run_geomean) + " ms(run): (geometric mean)");
        }
    }

    static long msec(double nsec) {
        return (long)Math.rint(nsec * 1.0E-6);
    }

    static long timeRun(String expression) {
        Variable x = Variable.make("x");
        Expr expr = Benchmark.parse(expression);
        double low = 0.0;
        double high = 4.0;
        double step = (high - low) / 1000000.0;
        long start = System.nanoTime();
        for (double xval = low; xval <= high; xval += step) {
            x.setValue(xval);
            expr.value();
        }
        return System.nanoTime() - start;
    }

    static long timeParse(String expression) {
        long start = System.nanoTime();
        for (int i = 0; i < 1000; ++i) {
            Benchmark.parse(expression);
        }
        return System.nanoTime() - start;
    }

    static Expr parse(String expression) {
        try {
            return Parser.parse(expression);
        }
        catch (SyntaxException e) {
            System.err.println(e.explain());
            throw new Error(e);
        }
    }
}

