/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.integration;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegisterClient;
import com.lowdragmc.lowdraglib.gui.editor.runtime.AnnotationDetector;
import com.lowdragmc.lowdraglib.plugin.ILDLibPlugin;
import com.lowdragmc.lowdraglib.plugin.LDLibPlugin;
import com.lowdragmc.lowdraglib.syncdata.IAccessor;
import com.lowdragmc.lowdraglib.syncdata.TypedPayloadRegistries;
import com.lowdragmc.lowdraglib.syncdata.payload.NbtTagPayload;
import com.lowdragmc.photon.Photon;
import com.lowdragmc.photon.client.gameobject.IFXObject;
import com.lowdragmc.photon.client.gameobject.emitter.data.shape.IShape;
import com.lowdragmc.photon.gui.editor.accessor.IShapeAccessor;
import com.lowdragmc.photon.gui.editor.accessor.NumberFunction3Accessor;
import com.lowdragmc.photon.gui.editor.accessor.NumberFunctionAccessor;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@LDLibPlugin
public class PhotonLDLibPlugin
implements ILDLibPlugin {
    public static final IAccessor NUMBER_FUNCTION_ACCESSOR = new NumberFunctionAccessor();
    public static final IAccessor NUMBER_FUNCTION3_ACCESSOR = new NumberFunction3Accessor();
    public static final IAccessor SHAPE_ACCESSOR = new IShapeAccessor();
    @OnlyIn(value=Dist.CLIENT)
    public static Map<String, AnnotationDetector.Wrapper<LDLRegisterClient, ? extends IFXObject>> REGISTER_FX_OBJECTS;
    public static Map<String, AnnotationDetector.Wrapper<LDLRegister, ? extends IShape>> REGISTER_SHAPES;

    public void onLoad() {
        File fxLocation = new File(LDLib.getLDLibDir(), "assets/photon/fx");
        if (fxLocation.mkdirs()) {
            Photon.LOGGER.info("creat the photon fx folder");
        }
        TypedPayloadRegistries.register(NbtTagPayload.class, NbtTagPayload::new, (IAccessor)NUMBER_FUNCTION_ACCESSOR, (int)1000);
        TypedPayloadRegistries.register(NbtTagPayload.class, NbtTagPayload::new, (IAccessor)NUMBER_FUNCTION3_ACCESSOR, (int)1000);
        TypedPayloadRegistries.register(NbtTagPayload.class, NbtTagPayload::new, (IAccessor)SHAPE_ACCESSOR, (int)1000);
        if (LDLib.isClient()) {
            REGISTER_FX_OBJECTS = new HashMap<String, AnnotationDetector.Wrapper<LDLRegisterClient, ? extends IFXObject>>();
            AnnotationDetector.scanClasses(LDLRegisterClient.class, IFXObject.class, AnnotationDetector::checkNoArgsConstructor, PhotonLDLibPlugin::toUINoArgsBuilder, PhotonLDLibPlugin::UIWrapperSorter, l -> REGISTER_FX_OBJECTS.putAll(l.stream().collect(Collectors.toMap(w -> ((LDLRegisterClient)w.annotation()).name(), w -> w))));
        }
        REGISTER_SHAPES = new HashMap<String, AnnotationDetector.Wrapper<LDLRegister, ? extends IShape>>();
        AnnotationDetector.scanClasses(LDLRegister.class, IShape.class, AnnotationDetector::checkNoArgsConstructor, AnnotationDetector::toUINoArgsBuilder, AnnotationDetector::UIWrapperSorter, l -> REGISTER_SHAPES.putAll(l.stream().collect(Collectors.toMap(w -> ((LDLRegister)w.annotation()).name(), w -> w))));
    }

    public static <T> AnnotationDetector.Wrapper<LDLRegisterClient, T> toUINoArgsBuilder(Class<? extends T> clazz) {
        return new AnnotationDetector.Wrapper((Annotation)clazz.getAnnotation(LDLRegisterClient.class), clazz, () -> AnnotationDetector.createNoArgsInstance((Class)clazz));
    }

    public static int UIWrapperSorter(AnnotationDetector.Wrapper<LDLRegisterClient, ?> a, AnnotationDetector.Wrapper<LDLRegisterClient, ?> b) {
        return ((LDLRegisterClient)b.annotation()).priority() - ((LDLRegisterClient)a.annotation()).priority();
    }
}

