/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.gui.editor;

import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.editor.ui.menu.MenuTab;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.util.TreeBuilder;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import com.lowdragmc.lowdraglib.utils.TrackedDummyWorld;
import com.lowdragmc.photon.gui.editor.FXEditor;
import com.lowdragmc.photon.gui.editor.ParticleScenePanel;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

@LDLRegister(name="scene", group="editor.fx", priority=99)
public class SceneMenu
extends MenuTab {
    private int range = 3;
    private boolean usingRealWorld = false;

    protected TreeBuilder.Menu createMenu() {
        TreeBuilder.Menu viewMenu = TreeBuilder.Menu.start();
        viewMenu.branch("range", menu -> {
            for (int r : new int[]{1, 3, 5}) {
                menu.leaf((IGuiTexture)(this.range == r ? Icons.CHECK : IGuiTexture.EMPTY), "%d\u00d7%d\u00d7%d".formatted(r, r, r), () -> this.setRange(r));
            }
        });
        viewMenu.crossLine();
        viewMenu.leaf((IGuiTexture)(this.usingRealWorld ? Icons.CHECK : IGuiTexture.EMPTY), "photon.gui.editor.menu.scene.real_world", () -> this.setUsingRealWorld(!this.usingRealWorld));
        return viewMenu;
    }

    protected void updateScene() {
        Editor editor = this.editor;
        if (editor instanceof FXEditor) {
            FXEditor fxEditor = (FXEditor)editor;
            editor = fxEditor.getTabPages().focus;
            if (editor instanceof ParticleScenePanel) {
                ParticleScenePanel panel = (ParticleScenePanel)editor;
                panel.resetScene();
            }
        }
    }

    public void setRange(int range) {
        this.range = range;
        this.updateScene();
    }

    public void setUsingRealWorld(boolean usingRealWorld) {
        this.usingRealWorld = usingRealWorld;
        this.updateScene();
    }

    public Set<BlockPos> createScene(TrackedDummyWorld level) {
        HashSet<BlockPos> plane = new HashSet<BlockPos>();
        if (this.usingRealWorld) {
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            BlockPos playerPos = Minecraft.m_91087_().f_91074_.m_20097_();
            for (int x = -this.range; x <= this.range; ++x) {
                for (int y = -this.range; y <= this.range; ++y) {
                    for (int z = -this.range; z <= this.range; ++z) {
                        BlockState state = world.m_8055_(new BlockPos(x, y, z).m_121955_((Vec3i)playerPos));
                        if (state.m_60734_() == Blocks.f_50016_) continue;
                        plane.add(new BlockPos(x, y, z));
                        level.addBlock(new BlockPos(x, y, z), BlockInfo.fromBlockState((BlockState)state));
                    }
                }
            }
        } else {
            int i = 0;
            for (int x = -this.range; x <= this.range; ++x) {
                for (int z = -this.range; z <= this.range; ++z) {
                    plane.add(new BlockPos(x, 0, z));
                    level.addBlock(new BlockPos(x, 0, z), BlockInfo.fromBlock((Block)(i % 2 == 0 ? Blocks.f_50497_ : Blocks.f_50498_)));
                    ++i;
                }
            }
        }
        return plane;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("range", this.range);
        tag.m_128379_("usingRealWorld", this.usingRealWorld);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.range = nbt.m_128451_("range");
        this.usingRealWorld = nbt.m_128471_("usingRealWorld");
    }

    public int getRange() {
        return this.range;
    }

    public boolean isUsingRealWorld() {
        return this.usingRealWorld;
    }
}

