/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.gui.editor;

import com.lowdragmc.lowdraglib.client.utils.RenderUtils;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.editor.ui.menu.ViewMenu;
import com.lowdragmc.lowdraglib.gui.editor.ui.sceneeditor.data.Ray;
import com.lowdragmc.lowdraglib.gui.editor.ui.view.FloatViewWidget;
import com.lowdragmc.lowdraglib.gui.widget.SceneWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import com.lowdragmc.lowdraglib.utils.Size;
import com.lowdragmc.lowdraglib.utils.TrackedDummyWorld;
import com.lowdragmc.lowdraglib.utils.Vector3fHelper;
import com.lowdragmc.photon.client.fx.FXData;
import com.lowdragmc.photon.client.fx.FXProjectEffect;
import com.lowdragmc.photon.client.fx.FXRuntime;
import com.lowdragmc.photon.client.gameobject.IFXObject;
import com.lowdragmc.photon.client.gameobject.emitter.IParticleEmitter;
import com.lowdragmc.photon.gui.editor.FXEditor;
import com.lowdragmc.photon.gui.editor.FXObjectsList;
import com.lowdragmc.photon.gui.editor.FXProject;
import com.lowdragmc.photon.gui.editor.ParticleInfoView;
import com.lowdragmc.photon.gui.editor.ParticleScene;
import com.lowdragmc.photon.gui.editor.SceneMenu;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ParticleScenePanel
extends WidgetGroup {
    public final FXEditor editor;
    public final FXProject project;
    @Nullable
    protected FXObjectsList fxObjectsList;
    protected final ParticleScene scene;
    protected final TrackedDummyWorld level;
    protected final FXData fxData;
    protected final FXProjectEffect effect;
    protected final FXRuntime runtime;
    protected boolean hoverSelected;
    protected boolean draggingSelected;
    protected final ParticleInfoView particleInfoView;

    public ParticleScenePanel(FXEditor editor, FXProject project, FXData fxData) {
        super(0, editor.getMenuPanel().getSizeHeight() + 16, editor.getSize().getWidth() - editor.getConfigPanel().getSizeWidth(), editor.getSize().height - editor.getMenuPanel().getSizeHeight() - 16);
        this.fxData = fxData;
        this.editor = editor;
        this.project = project;
        this.runtime = new FXRuntime(project.fx, fxData, false, false);
        this.runtime.root.updatePos(new Vector3f(0.5f, 2.0f, 0.5f));
        this.scene = new ParticleScene(0, 0, this.getSize().width, this.getSize().height);
        this.addWidget((Widget)this.scene);
        this.scene.setRenderFacing(false);
        this.scene.setRenderSelect(false);
        this.scene.useCacheBuffer();
        this.level = new TrackedDummyWorld();
        this.scene.createScene((Level)this.level);
        this.scene.setAfterWorldRender(this::renderAfterWorld);
        this.effect = new FXProjectEffect((Level)this.level);
        this.particleInfoView = new ParticleInfoView(this);
        this.particleInfoView.setSelfPosition(editor.getSizeWidth() - editor.getConfigPanel().getSizeWidth() - this.particleInfoView.getSizeWidth() - 5, editor.getSizeHeight() - editor.getResourcePanel().getSizeHeight() - this.particleInfoView.getSizeHeight() - 5);
    }

    public void onPanelSelected() {
        this.editor.getConfigPanel().clearAllConfigurators();
        this.editor.getToolPanel().clearAllWidgets();
        this.editor.getToolPanel().setTitle("photon.gui.editor.fx.particle_panel.fx_object_list");
        this.editor.getToolPanel().addNewToolBox("photon.gui.editor.fx.particle_panel.fx_object_list", Icons.WIDGET_CUSTOM, size -> {
            this.fxObjectsList = new FXObjectsList(this, (Size)size);
            return this.fxObjectsList;
        });
        if (this.editor.getToolPanel().inAnimate()) {
            this.editor.getToolPanel().getAnimation().appendOnFinish(() -> this.editor.getToolPanel().show());
        } else {
            this.editor.getToolPanel().show();
        }
        Object v = this.editor.getMenuPanel().getTabs().get("view");
        if (v instanceof ViewMenu) {
            ViewMenu viewMenu = (ViewMenu)v;
            viewMenu.removeView("particle_info");
            viewMenu.openView((FloatViewWidget)this.particleInfoView);
        }
        this.resetScene();
    }

    public void onPanelDeselected() {
        this.editor.getToolPanel().setTitle("ldlib.gui.editor.group.tool_box");
        this.editor.getToolPanel().hide();
        this.editor.getToolPanel().clearAllWidgets();
        this.editor.getConfigPanel().clearAllConfigurators();
    }

    public void restartEmitters() {
        this.scene.getParticleManager().clearAllParticles();
        this.runtime.emmit(this.effect);
    }

    public void resetScene() {
        this.level.clear();
        Object v = this.editor.getMenuPanel().getTabs().get("scene");
        if (v instanceof SceneMenu) {
            SceneMenu sceneMenu = (SceneMenu)((Object)v);
            this.scene.setRenderedCore(sceneMenu.createScene(this.level), null);
        } else {
            HashSet<BlockPos> plane = new HashSet<BlockPos>();
            int i = 0;
            for (int x = -5; x < 6; ++x) {
                for (int z = -5; z < 6; ++z) {
                    plane.add(new BlockPos(x, 0, z));
                    this.level.addBlock(new BlockPos(x, 0, z), BlockInfo.fromBlock((Block)(i % 2 == 0 ? Blocks.f_50497_ : Blocks.f_50498_)));
                    ++i;
                }
            }
            this.scene.setRenderedCore(plane, null);
        }
        Vector3f center = new Vector3f(0.5f, 2.0f, 0.5f);
        float zoom = this.scene.getZoom();
        float range = this.scene.getRange();
        this.scene.setCenter(center);
        this.scene.getRenderer().setCameraOrtho(range * zoom, this.scene.getRange() * zoom, range * zoom);
        this.scene.getRenderer().setCameraLookAt(center, (double)this.scene.camZoom(), Math.toRadians(this.scene.getRotationPitch()), Math.toRadians(this.scene.getRotationYaw()));
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY) && this.hoverSelected) {
            this.draggingSelected = true;
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.draggingSelected) {
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.draggingSelected = false;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public void renderAfterWorld(SceneWidget _scene) {
        AABB aabb;
        IFXObject selected;
        this.hoverSelected = false;
        ParticleScenePanel.renderBox(new PoseStack(), new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0), 0.0f, 0.0f, 0.0f);
        if (this.project.isDraggable() && this.fxObjectsList != null && (selected = this.fxObjectsList.getSelected()) != null) {
            PoseStack poseStack = new PoseStack();
            Vector3f position = selected.transform().position();
            aabb = new AABB((double)position.x - 0.1, (double)position.y - 0.1, (double)position.z - 0.1, (double)position.x + 0.1, (double)position.y + 0.1, (double)position.z + 0.1);
            ParticleScenePanel.renderBox(poseStack, aabb, 1.0f, 0.0f, 0.0f);
            Ray ray = this.scene.unProject(this.scene.getLastMouseX(), this.scene.getLastMouseY());
            if (this.draggingSelected) {
                Vector3f pos = selected.transform().position();
                Vector3f vec = new Vector3f((Vector3fc)ray.endPos()).sub((Vector3fc)new Vector3f((Vector3fc)ray.startPos()));
                Vector3f lookVec = pos.sub((Vector3fc)new Vector3f((Vector3fc)ray.startPos()));
                float mag = lookVec.length();
                Vector3f draggedPos = new Vector3f((Vector3fc)ray.startPos()).add((Vector3fc)Vector3fHelper.project((Vector3f)lookVec, (Vector3f)vec).normalize().mul(mag));
                selected.updatePos(draggedPos);
            } else {
                Optional result = aabb.m_82371_(new Vec3((ray = ray.toInfinite()).startPos()), new Vec3(ray.endPos()));
                if (result.isPresent()) {
                    this.hoverSelected = true;
                }
            }
        }
        if (this.project.isRenderCullBox() && this.fxObjectsList != null && (selected = this.fxObjectsList.getSelected()) instanceof IParticleEmitter) {
            IParticleEmitter emitter = (IParticleEmitter)selected;
            PoseStack poseStack = new PoseStack();
            aabb = emitter.getCullBox(Minecraft.m_91087_().m_91296_());
            if (aabb != null) {
                ParticleScenePanel.renderBox(poseStack, aabb, 0.5f, 0.5f, 0.5f);
            }
        }
    }

    public static void renderBox(PoseStack poseStack, AABB aabb, float r, float g, float b) {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)1);
        poseStack.m_85836_();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172811_);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        RenderUtils.renderCubeFace((PoseStack)poseStack, (BufferBuilder)buffer, (float)((float)aabb.f_82288_), (float)((float)aabb.f_82289_), (float)((float)aabb.f_82290_), (float)((float)aabb.f_82291_), (float)((float)aabb.f_82292_), (float)((float)aabb.f_82293_), (float)r, (float)g, (float)b, (float)1.0f);
        tessellator.m_85914_();
        poseStack.m_85849_();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Nullable
    public FXObjectsList getFxObjectsList() {
        return this.fxObjectsList;
    }

    public ParticleScene getScene() {
        return this.scene;
    }

    public TrackedDummyWorld getLevel() {
        return this.level;
    }

    public FXData getFxData() {
        return this.fxData;
    }

    public FXRuntime getRuntime() {
        return this.runtime;
    }

    public boolean isHoverSelected() {
        return this.hoverSelected;
    }

    public boolean isDraggingSelected() {
        return this.draggingSelected;
    }

    public ParticleInfoView getParticleInfoView() {
        return this.particleInfoView;
    }
}

