/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.gui.editor;

import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.Resource;
import com.lowdragmc.lowdraglib.gui.editor.ui.ConfigPanel;
import com.lowdragmc.lowdraglib.gui.editor.ui.ResourcePanel;
import com.lowdragmc.lowdraglib.gui.editor.ui.resource.ResourceContainer;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.photon.client.gameobject.emitter.data.material.IMaterial;

public class MaterialsResourceContainer
extends ResourceContainer<IMaterial, ImageWidget> {
    public MaterialsResourceContainer(Resource<IMaterial> resource, ResourcePanel panel) {
        super(resource, panel);
        this.setWidgetSupplier(k -> new ImageWidget(0, 0, 30, 30, () -> ((IMaterial)this.getResource().getResource(k)).preview()));
        this.setDragging(key -> (IMaterial)this.getResource().getResource(key), IMaterial::preview);
        this.setOnEdit(key -> this.getPanel().getEditor().getConfigPanel().openConfigurator(ConfigPanel.Tab.RESOURCE, (IConfigurable)this.getResource().getResource(key)));
        this.setOnMenu((selected, m) -> m.branch((IGuiTexture)Icons.ADD_FILE, "ldlib.gui.editor.menu.add_resource", menu -> {
            for (Class<? extends IMaterial> clazz : IMaterial.MATERIALS) {
                try {
                    IMaterial icon = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    menu.leaf(icon.preview(), clazz.getSimpleName(), () -> {
                        resource.addBuiltinResource(this.genNewFileName(), (Object)icon);
                        this.reBuild();
                    });
                }
                catch (Throwable throwable) {}
            }
        }));
    }
}

