/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.gui.editor;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegisterClient;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.gui.editor.runtime.AnnotationDetector;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.editor.ui.sceneeditor.data.Transform;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.util.TreeBuilder;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.DialogWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.SwitchWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextTextureWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.layout.Layout;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.lowdragmc.lowdraglib.utils.Size;
import com.lowdragmc.photon.client.gameobject.IFXObject;
import com.lowdragmc.photon.client.gameobject.emitter.IParticleEmitter;
import com.lowdragmc.photon.gui.editor.FXEditor;
import com.lowdragmc.photon.gui.editor.ParticleScenePanel;
import com.lowdragmc.photon.integration.PhotonLDLibPlugin;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class FXObjectsList
extends DraggableScrollableWidgetGroup {
    private final ParticleScenePanel panel;
    @Nullable
    private IFXObject selected;
    private final ChildrenContainer rootContainer;
    private final Object2BooleanMap<IFXObject> expanded = new Object2BooleanOpenHashMap();

    public FXObjectsList(ParticleScenePanel panel, Size size) {
        super(0, 0, size.width, size.height);
        this.panel = panel;
        this.setYScrollBarWidth(4).setYBarStyle(null, (IGuiTexture)ColorPattern.T_WHITE.rectTexture().setRadius(2.0f).transform(-0.5f, 0.0f));
        this.rootContainer = new ChildrenContainer(null, size.width - 4);
        this.addWidget((Widget)this.rootContainer);
        this.updateList();
    }

    public boolean isExpanded(IFXObject emitter) {
        if (emitter.transform().parent() == null) {
            return true;
        }
        return this.expanded.getBoolean((Object)emitter);
    }

    public void setExpanded(IFXObject emitter, boolean expanded) {
        this.expanded.put((Object)emitter, expanded);
    }

    public void addSceneObject(IFXObject fxObject) {
        fxObject.transform().localPosition(new Vector3f());
        this.panel.runtime.addSceneObject(fxObject);
        fxObject.transform().parent(this.panel.runtime.getRoot().transform(), false);
    }

    public void removeSceneObject(IFXObject fxObject) {
        this.panel.runtime.removeSceneObject(fxObject);
        this.expanded.removeBoolean((Object)fxObject);
    }

    public void updateList() {
        this.rootContainer.updateChildren();
        this.panel.restartEmitters();
    }

    public void setSelectedFX(@Nullable IFXObject selected) {
        this.selected = selected;
        this.panel.scene.setTransformGizmoTarget(selected == null ? null : selected.transform());
        if (selected == null) {
            this.panel.editor.getConfigPanel().clearAllConfigurators();
        } else {
            this.panel.editor.getConfigPanel().openConfigurator(FXEditor.BASIC, (IConfigurable)selected);
        }
    }

    public WidgetGroup createEmitterWidget(IFXObject fxObject, int width) {
        WidgetGroup container = new WidgetGroup(0, 0, width, 10);
        ChildrenContainer children = new ChildrenContainer(fxObject, width - 10);
        children.setSelfPosition(10, 10);
        container.addWidget((Widget)children);
        container.setDynamicSized(true);
        container.addWidget((Widget)new ImageWidget(0, 0, 10, 10, () -> fxObject.transform().children().isEmpty() ? IGuiTexture.EMPTY : (this.isExpanded(fxObject) ? Icons.DOWN.copy().scale(0.9f) : Icons.RIGHT.copy().scale(0.9f))));
        container.addWidget((Widget)new ButtonWidget(0, 0, 10, 10, cd -> {
            if (fxObject.transform().children().isEmpty()) {
                return;
            }
            boolean isExpanded = !this.isExpanded(fxObject);
            this.setExpanded(fxObject, isExpanded);
            children.updateChildren();
        }));
        container.addWidget((Widget)new ButtonWidget(10, 0, width - 20, 10, cd -> this.setSelectedFX(fxObject)));
        container.addWidget(new TextTextureWidget(10, 0, width - 20, 10).setText(() -> Component.m_237113_((String)fxObject.getName())).textureStyle(t -> t.setType(TextTexture.TextType.LEFT_HIDE)).setHoverTexture(new IGuiTexture[]{ColorPattern.T_GRAY.rectTexture()}).setDraggingConsumer(o -> {
            IParticleEmitter e;
            return o instanceof IParticleEmitter && (e = (IParticleEmitter)o) != fxObject && !fxObject.transform().isInheritedParent(e.transform());
        }, o -> {}, o -> {}, o -> {
            if (o instanceof IParticleEmitter) {
                IParticleEmitter e = (IParticleEmitter)o;
                e.transform().parent(fxObject.transform());
                this.updateList();
            }
        }).setDraggingProvider(() -> fxObject, (e, pos) -> new TextTexture(e.getName())));
        container.addWidget((Widget)new SwitchWidget(width - 10, 0, 10, 10, (cd, pressed) -> fxObject.setVisible((boolean)pressed)).setTexture((IGuiTexture)Icons.EYE_OFF.copy().scale(0.9f), (IGuiTexture)Icons.EYE.copy().scale(0.9f)).setPressed(fxObject.isVisible()).setSupplier(fxObject::isVisible));
        container.addWidget((Widget)new ImageWidget(0, 0, width, 10, () -> this.selected == fxObject ? ColorPattern.T_GREEN.rectTexture() : IGuiTexture.EMPTY));
        return container;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY) && button == 1) {
            TreeBuilder.Menu menu = TreeBuilder.Menu.start().branch((IGuiTexture)Icons.ADD_FILE, "add emitter", m -> {
                for (AnnotationDetector.Wrapper<LDLRegisterClient, ? extends IFXObject> wrapper : PhotonLDLibPlugin.REGISTER_FX_OBJECTS.values()) {
                    m.leaf(((LDLRegisterClient)wrapper.annotation()).name(), () -> {
                        IFXObject emitter = (IFXObject)wrapper.creator().get();
                        String name = emitter.getName();
                        int index = 0;
                        while (this.panel.runtime.objects.values().stream().anyMatch(e -> e.getName().equals(emitter.getName()))) {
                            emitter.setName(name + "(%d)".formatted(index));
                            ++index;
                        }
                        this.addSceneObject(emitter);
                        this.updateList();
                    });
                }
            });
            if (this.selected != null && this.selected != this.panel.runtime.getRoot()) {
                menu.crossLine();
                menu.leaf("ldlib.gui.editor.menu.rename", () -> DialogWidget.showStringEditorDialog((WidgetGroup)Editor.INSTANCE, (String)(LocalizationUtils.format((String)"ldlib.gui.editor.tips.rename", (Object[])new Object[0]) + " " + LocalizationUtils.format((String)this.selected.name(), (Object[])new Object[0])), (String)this.selected.getName(), s -> true, s -> {
                    if (s == null) {
                        return;
                    }
                    this.selected.setName((String)s);
                }));
                menu.leaf((IGuiTexture)Icons.COPY, "ldlib.gui.editor.menu.copy", () -> {
                    String name = this.selected.getName();
                    IFXObject copied = this.deepCopyFXObject(this.selected, this.selected.transform().parent());
                    copied.setName(name + " copied");
                    this.updateList();
                });
                menu.leaf((IGuiTexture)Icons.REMOVE_FILE, "ldlib.gui.editor.menu.remove", () -> {
                    this.removeSceneObject(this.selected);
                    this.setSelectedFX(null);
                    this.updateList();
                });
            }
            this.panel.editor.openMenu(mouseX, mouseY, menu);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public IFXObject deepCopyFXObject(IFXObject fxObject, Transform parent) {
        IFXObject copied = fxObject.copy(true);
        this.addSceneObject(copied);
        copied.transform().parent(parent);
        for (Transform child : fxObject.transform().children()) {
            if (!(child.sceneObject() instanceof IFXObject)) continue;
            this.deepCopyFXObject((IFXObject)child.sceneObject(), copied.transform());
        }
        return copied;
    }

    @Nullable
    public IFXObject getSelected() {
        return this.selected;
    }

    private class ChildrenContainer
    extends WidgetGroup {
        @Nullable
        private final IFXObject parent;
        private int width;

        private ChildrenContainer(IFXObject parent, int width) {
            super(0, 0, width, 0);
            this.width = 0;
            this.width = width;
            this.parent = parent;
            this.setDynamicSized(true);
            this.setLayout(Layout.VERTICAL_LEFT);
            this.updateChildren();
        }

        public Collection<IFXObject> getChildren() {
            if (this.parent == null) {
                return List.of(FXObjectsList.this.panel.runtime.getRoot());
            }
            return this.parent.transform().children().stream().filter(t -> t.sceneObject() instanceof IFXObject).map(t -> (IFXObject)t.sceneObject()).toList();
        }

        public void updateChildren() {
            this.clearAllWidgets();
            if (this.parent != null && !FXObjectsList.this.isExpanded(this.parent)) {
                return;
            }
            for (IFXObject child : this.getChildren()) {
                this.addWidget((Widget)FXObjectsList.this.createEmitterWidget(child, this.width));
            }
        }
    }
}

