/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.gui.editor;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.gui.editor.configurator.WrapperConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.Resource;
import com.lowdragmc.lowdraglib.gui.editor.ui.ConfigPanel;
import com.lowdragmc.lowdraglib.gui.editor.ui.ResourcePanel;
import com.lowdragmc.lowdraglib.gui.editor.ui.resource.ResourceContainer;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.util.TreeBuilder;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.syncdata.ITagSerializable;
import com.lowdragmc.lowdraglib.utils.Size;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.CurveLineWidget;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.CurveTexture;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.ECBCurves;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.RandomCurveLineWidget;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.RandomCurveTexture;
import com.mojang.datafixers.util.Either;
import java.io.File;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

@LDLRegister(name="curves", group="resource")
public class CurvesResource
extends Resource<Curves> {
    public static final String RESOURCE_NAME = "curves";

    public CurvesResource() {
        super(new File(LDLib.getLDLibDir(), "assets/resources/curves"));
    }

    public String name() {
        return RESOURCE_NAME;
    }

    public void buildDefault() {
        this.addBuiltinResource("middle", new Curves(new ECBCurves()));
        this.addBuiltinResource("linear up", new Curves(new ECBCurves(0.0f, 0.0f, 0.1f, 0.3f, 0.9f, 0.7f, 1.0f, 1.0f)));
        this.addBuiltinResource("linear down", new Curves(new ECBCurves(0.0f, 1.0f, 0.1f, 0.7f, 0.9f, 0.3f, 1.0f, 0.0f)));
        this.addBuiltinResource("smooth up", new Curves(new ECBCurves(0.0f, 0.0f, 0.1f, 0.0f, 0.9f, 1.0f, 1.0f, 1.0f)));
        this.addBuiltinResource("smooth down", new Curves(new ECBCurves(0.0f, 1.0f, 0.1f, 1.0f, 0.9f, 0.0f, 1.0f, 0.0f)));
        this.addBuiltinResource("concave", new Curves(new ECBCurves(0.0f, 1.0f, 0.1f, 1.0f, 0.4f, 0.0f, 0.5f, 0.0f, 0.5f, 0.0f, 0.6f, 0.0f, 0.9f, 1.0f, 1.0f, 1.0f)));
        this.addBuiltinResource("convex", new Curves(new ECBCurves(0.0f, 0.0f, 0.1f, 0.0f, 0.4f, 1.0f, 0.5f, 1.0f, 0.5f, 1.0f, 0.6f, 1.0f, 0.9f, 0.0f, 1.0f, 0.0f)));
        this.addBuiltinResource("random full", new Curves(new ECBCurves(0.0f, 1.0f, 0.1f, 1.0f, 0.9f, 1.0f, 1.0f, 1.0f), new ECBCurves(0.0f, 0.0f, 0.1f, 0.0f, 0.9f, 0.0f, 1.0f, 0.0f)));
        this.addBuiltinResource("random up", new Curves(new ECBCurves(0.0f, 1.0f, 0.1f, 1.0f, 0.9f, 1.0f, 1.0f, 1.0f), new ECBCurves(0.0f, 0.0f, 0.1f, 0.0f, 0.9f, 1.0f, 1.0f, 1.0f)));
        this.addBuiltinResource("random down", new Curves(new ECBCurves(0.0f, 1.0f, 0.1f, 1.0f, 0.9f, 1.0f, 1.0f, 1.0f), new ECBCurves(0.0f, 1.0f, 0.1f, 1.0f, 0.9f, 0.0f, 1.0f, 0.0f)));
    }

    @Nullable
    public Tag serialize(Curves curves) {
        return curves.serializeNBT();
    }

    public Curves deserialize(Tag tag) {
        Curves curves = new Curves();
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            curves.deserializeNBT(compoundTag);
        }
        return curves;
    }

    public ResourceContainer<Curves, ? extends Widget> createContainer(ResourcePanel panel) {
        ResourceContainer<Curves, ImageWidget> container = new ResourceContainer<Curves, ImageWidget>((Resource)this, panel){

            protected TreeBuilder.Menu getMenu() {
                return super.getMenu().leaf((IGuiTexture)Icons.ADD_FILE, "add curve", () -> {
                    String randomName = this.genNewFileName();
                    this.resource.addBuiltinResource(randomName, (Object)new Curves());
                    this.reBuild();
                }).leaf((IGuiTexture)Icons.ADD_FILE, "add random curve", () -> {
                    String randomName = this.genNewFileName();
                    this.resource.addBuiltinResource(randomName, (Object)new Curves(new ECBCurves(), new ECBCurves(0.0f, 0.2f, 0.1f, 0.2f, 0.9f, 0.2f, 1.0f, 0.2f)));
                    this.reBuild();
                });
            }
        };
        container.setWidgetSupplier(k -> new ImageWidget(0, 0, 60, 15, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ColorPattern.T_WHITE.rectTexture(), ((Curves)this.getResource((Either)k)).isRandomCurve() ? new RandomCurveTexture(((Curves)this.getResource((Either)k)).curves0, ((Curves)this.getResource((Either)k)).curves1) : new CurveTexture(((Curves)this.getResource((Either)k)).curves0)}))).setDragging(arg_0 -> ((CurvesResource)this).getResource(arg_0), curves -> new GuiTextureGroup(new IGuiTexture[]{ColorPattern.T_WHITE.rectTexture(), curves.isRandomCurve() ? new RandomCurveTexture(curves.curves0, curves.curves1) : new CurveTexture(curves.curves0)})).setOnEdit(arg_0 -> this.lambda$createContainer$2((ResourceContainer)container, arg_0));
        return container;
    }

    private void openConfigurator(ResourceContainer<Curves, ImageWidget> container, final Either<String, File> key) {
        container.getPanel().getEditor().getConfigPanel().openConfigurator(ConfigPanel.Tab.RESOURCE, new IConfigurable(){

            public void buildConfigurator(ConfiguratorGroup father) {
                Curves curves = (Curves)CurvesResource.this.getResource(key);
                if (curves.isRandomCurve()) {
                    RandomCurveLineWidget curveLine = new RandomCurveLineWidget(0, 0, 180, 60, curves.curves0, curves.curves1);
                    curveLine.setGridSize(new Size(6, 2));
                    curveLine.setHoverTips(coord -> Component.m_237113_((String)"x: %f, y:%f".formatted(Float.valueOf(coord.f_82470_), Float.valueOf(coord.f_82471_))));
                    curveLine.setBackground(new IGuiTexture[]{new GuiTextureGroup(new IGuiTexture[]{ColorPattern.BLACK.rectTexture(), ColorPattern.T_WHITE.borderTexture(-1)})});
                    WrapperConfigurator configurator = new WrapperConfigurator("color", (Widget)curveLine);
                    father.addConfigurators(new Configurator[]{configurator});
                } else {
                    CurveLineWidget curveLine = new CurveLineWidget(0, 0, 180, 60, curves.curves0);
                    curveLine.setGridSize(new Size(6, 2));
                    curveLine.setHoverTips(coord -> Component.m_237113_((String)"x: %f, y:%f".formatted(Float.valueOf(coord.f_82470_), Float.valueOf(coord.f_82471_))));
                    curveLine.setBackground(new IGuiTexture[]{new GuiTextureGroup(new IGuiTexture[]{ColorPattern.BLACK.rectTexture(), ColorPattern.T_WHITE.borderTexture(-1)})});
                    WrapperConfigurator configurator = new WrapperConfigurator("color", (Widget)curveLine);
                    father.addConfigurators(new Configurator[]{configurator});
                }
            }
        });
    }

    private /* synthetic */ void lambda$createContainer$2(ResourceContainer container, Either k) {
        this.openConfigurator((ResourceContainer<Curves, ImageWidget>)container, (Either<String, File>)k);
    }

    public static class Curves
    implements ITagSerializable<CompoundTag> {
        @Nonnull
        public ECBCurves curves0;
        @Nullable
        public ECBCurves curves1;

        public Curves(@Nonnull ECBCurves curves0, @Nullable ECBCurves curves1) {
            this.curves0 = curves0;
            this.curves1 = curves1;
        }

        public Curves(@Nonnull ECBCurves curves0) {
            this(curves0, null);
        }

        public Curves() {
            this(new ECBCurves(), null);
        }

        public boolean isRandomCurve() {
            return this.curves1 != null;
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("a", (Tag)this.curves0.serializeNBT());
            if (this.curves1 != null) {
                tag.m_128365_("b", (Tag)this.curves1.serializeNBT());
            }
            return tag;
        }

        public void deserializeNBT(CompoundTag nbt) {
            ListTag list;
            Tag tag = nbt.m_128423_("a");
            if (tag instanceof ListTag) {
                list = (ListTag)tag;
                this.curves0.deserializeNBT(list);
            }
            if ((tag = nbt.m_128423_("b")) instanceof ListTag) {
                list = (ListTag)tag;
                if (this.curves1 == null) {
                    this.curves1 = new ECBCurves();
                }
                this.curves1.deserializeNBT(list);
            }
        }
    }
}

