/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.command;

import com.lowdragmc.lowdraglib.networking.IHandlerContext;
import com.lowdragmc.lowdraglib.networking.IPacket;
import com.lowdragmc.photon.PhotonNetworking;
import com.lowdragmc.photon.client.fx.EntityEffect;
import com.lowdragmc.photon.client.fx.FXRuntime;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RemoveEntityEffectCommand
implements IPacket {
    protected List<Entity> entities;
    private int[] ids = new int[0];
    protected boolean force;
    @Nullable
    protected ResourceLocation location;

    public static LiteralArgumentBuilder<CommandSourceStack> createServerCommand() {
        return (LiteralArgumentBuilder)Commands.m_82127_((String)"entity").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"entities", (ArgumentType)EntityArgument.m_91460_()).executes(c -> RemoveEntityEffectCommand.execute((CommandContext<CommandSourceStack>)c, false, false))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"force", (ArgumentType)BoolArgumentType.bool()).executes(c -> RemoveEntityEffectCommand.execute((CommandContext<CommandSourceStack>)c, true, false))).then(Commands.m_82129_((String)"location", (ArgumentType)ResourceLocationArgument.m_106984_()).executes(c -> RemoveEntityEffectCommand.execute((CommandContext<CommandSourceStack>)c, true, true)))));
    }

    private static int execute(CommandContext<CommandSourceStack> context, boolean force, boolean location) throws CommandSyntaxException {
        RemoveEntityEffectCommand command = new RemoveEntityEffectCommand();
        command.setEntities(EntityArgument.m_91461_(context, (String)"entities").stream().map(e -> e).toList());
        if (force) {
            command.setForce(BoolArgumentType.getBool(context, (String)"force"));
        }
        if (location) {
            command.setLocation(ResourceLocationArgument.m_107011_(context, (String)"location"));
        }
        PhotonNetworking.NETWORK.sendToAll((IPacket)command);
        return 1;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130130_(this.entities.size());
        for (Entity entity : this.entities) {
            buf.m_130130_(entity.m_19879_());
        }
        buf.writeBoolean(this.location != null);
        if (this.location != null) {
            buf.m_130085_(this.location);
        }
    }

    public void decode(FriendlyByteBuf buf) {
        this.ids = new int[buf.m_130242_()];
        for (int i = 0; i < this.ids.length; ++i) {
            this.ids[i] = buf.m_130242_();
        }
        if (buf.readBoolean()) {
            this.location = buf.m_130281_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void execute(IHandlerContext handler) {
        for (int id : this.ids) {
            Entity entity = handler.getLevel().m_6815_(id);
            if (entity == null) continue;
            List<EntityEffect> effects = EntityEffect.CACHE.get(entity);
            if (effects == null) {
                return;
            }
            Iterator<EntityEffect> iter = effects.iterator();
            while (iter.hasNext()) {
                EntityEffect effect = iter.next();
                if (this.location != null && !this.location.equals((Object)effect.getFx().getFxLocation())) continue;
                iter.remove();
                FXRuntime runtime = effect.getRuntime();
                if (runtime == null || !runtime.isAlive()) continue;
                runtime.destroy(this.force);
            }
            if (!effects.isEmpty()) continue;
            EntityEffect.CACHE.remove(entity);
        }
    }

    public void setEntities(List<Entity> entities) {
        this.entities = entities;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void setLocation(@Nullable ResourceLocation location) {
        this.location = location;
    }
}

