/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.command;

import com.lowdragmc.lowdraglib.networking.IHandlerContext;
import com.lowdragmc.lowdraglib.networking.IPacket;
import com.lowdragmc.photon.PhotonNetworking;
import com.lowdragmc.photon.client.fx.EntityEffect;
import com.lowdragmc.photon.client.fx.FX;
import com.lowdragmc.photon.client.fx.FXHelper;
import com.lowdragmc.photon.command.EffectCommand;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityEffectCommand
extends EffectCommand {
    protected List<Entity> entities;
    private int[] ids = new int[0];
    private EntityEffect.AutoRotate autoRotate = EntityEffect.AutoRotate.NONE;

    public static LiteralArgumentBuilder<CommandSourceStack> createServerCommand() {
        return (LiteralArgumentBuilder)Commands.m_82127_((String)"entity").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"entities", (ArgumentType)EntityArgument.m_91460_()).executes(c -> EntityEffectCommand.execute((CommandContext<CommandSourceStack>)c, false, false, false, false, false, false, false))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"offset", (ArgumentType)Vec3Argument.m_120847_((boolean)false)).executes(c -> EntityEffectCommand.execute((CommandContext<CommandSourceStack>)c, false, false, false, false, false, false, false))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"rotation", (ArgumentType)Vec3Argument.m_120847_((boolean)false)).executes(c -> EntityEffectCommand.execute((CommandContext<CommandSourceStack>)c, true, true, false, false, false, false, false))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"scale", (ArgumentType)Vec3Argument.m_120847_((boolean)false)).executes(c -> EntityEffectCommand.execute((CommandContext<CommandSourceStack>)c, true, true, true, false, false, false, false))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"delay", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(c -> EntityEffectCommand.execute((CommandContext<CommandSourceStack>)c, true, true, true, true, false, false, false))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"force death", (ArgumentType)BoolArgumentType.bool()).executes(c -> EntityEffectCommand.execute((CommandContext<CommandSourceStack>)c, true, true, true, true, true, false, false))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"allow multi", (ArgumentType)BoolArgumentType.bool()).executes(c -> EntityEffectCommand.execute((CommandContext<CommandSourceStack>)c, true, true, true, true, true, true, false))).then(Commands.m_82129_((String)"auto rotate", (ArgumentType)new AutoRotateType()).executes(c -> EntityEffectCommand.execute((CommandContext<CommandSourceStack>)c, true, true, true, true, true, true, true)))))))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"delay", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(c -> EntityEffectCommand.execute((CommandContext<CommandSourceStack>)c, true, true, false, true, false, false, false))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"force death", (ArgumentType)BoolArgumentType.bool()).executes(c -> EntityEffectCommand.execute((CommandContext<CommandSourceStack>)c, true, true, false, true, true, false, false))).then(Commands.m_82129_((String)"allow multi", (ArgumentType)BoolArgumentType.bool()).executes(c -> EntityEffectCommand.execute((CommandContext<CommandSourceStack>)c, true, true, false, true, true, true, false))))))));
    }

    private static int execute(CommandContext<CommandSourceStack> context, boolean offset, boolean rotation, boolean scale, boolean delay, boolean forceDeath, boolean allowMulti, boolean autoRotate) throws CommandSyntaxException {
        EntityEffectCommand command = new EntityEffectCommand();
        command.setLocation(ResourceLocationArgument.m_107011_(context, (String)"location"));
        command.setEntities(EntityArgument.m_91461_(context, (String)"entities").stream().map(e -> e).toList());
        if (offset) {
            command.setOffset(Vec3Argument.m_120844_(context, (String)"offset"));
        }
        if (rotation) {
            command.setRotation(Vec3Argument.m_120844_(context, (String)"rotation"));
        }
        if (scale) {
            command.setScale(Vec3Argument.m_120844_(context, (String)"scale"));
        }
        if (delay) {
            command.setDelay(IntegerArgumentType.getInteger(context, (String)"delay"));
        }
        if (forceDeath) {
            command.setForcedDeath(BoolArgumentType.getBool(context, (String)"force death"));
        }
        if (allowMulti) {
            command.setAllowMulti(BoolArgumentType.getBool(context, (String)"allow multi"));
        }
        if (autoRotate) {
            command.setAutoRotate(AutoRotateType.getValue(context, "auto rotate"));
        }
        PhotonNetworking.NETWORK.sendToAll((IPacket)command);
        return 1;
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        super.encode(buf);
        buf.m_130068_((Enum)this.autoRotate);
        buf.m_130130_(this.entities.size());
        for (Entity entity : this.entities) {
            buf.m_130130_(entity.m_19879_());
        }
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        super.decode(buf);
        this.autoRotate = (EntityEffect.AutoRotate)buf.m_130066_(EntityEffect.AutoRotate.class);
        this.ids = new int[buf.m_130242_()];
        for (int i = 0; i < this.ids.length; ++i) {
            this.ids[i] = buf.m_130242_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void execute(IHandlerContext handler) {
        Level level = handler.getLevel();
        FX fx = FXHelper.getFX(this.location);
        if (fx != null) {
            for (int id : this.ids) {
                Entity entity = level.m_6815_(id);
                if (entity == null) continue;
                EntityEffect effect = new EntityEffect(fx, level, entity, this.autoRotate);
                effect.setOffset(this.offset.f_82479_, this.offset.f_82480_, this.offset.f_82481_);
                effect.setRotation(this.rotation.f_82479_, this.rotation.f_82480_, this.rotation.f_82481_);
                effect.setScale(this.scale.f_82479_, this.scale.f_82480_, this.scale.f_82481_);
                effect.setDelay(this.delay);
                effect.setForcedDeath(this.forcedDeath);
                effect.setAllowMulti(this.allowMulti);
                effect.start();
            }
        }
    }

    public void setEntities(List<Entity> entities) {
        this.entities = entities;
    }

    public void setAutoRotate(EntityEffect.AutoRotate autoRotate) {
        this.autoRotate = autoRotate;
    }

    public static class AutoRotateType
    implements ArgumentType<EntityEffect.AutoRotate> {
        private static final Collection<String> EXAMPLES = Arrays.asList("none", "forward", "look", "xrot");

        public static EntityEffect.AutoRotate getValue(CommandContext<?> context, String name) {
            return (EntityEffect.AutoRotate)((Object)context.getArgument(name, EntityEffect.AutoRotate.class));
        }

        public EntityEffect.AutoRotate parse(StringReader reader) throws CommandSyntaxException {
            return EntityEffect.AutoRotate.valueOf(reader.readString().toUpperCase());
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            if ("none".startsWith(builder.getRemainingLowerCase())) {
                builder.suggest("none");
            }
            if ("forward".startsWith(builder.getRemainingLowerCase())) {
                builder.suggest("forward");
            }
            if ("look".startsWith(builder.getRemainingLowerCase())) {
                builder.suggest("look");
            }
            if ("xrot".startsWith(builder.getRemainingLowerCase())) {
                builder.suggest("xrot");
            }
            return builder.buildFuture();
        }

        public Collection<String> getExamples() {
            return EXAMPLES;
        }
    }
}

