/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.postprocessing;

import com.lowdragmc.lowdraglib.utils.ColorUtils;
import com.lowdragmc.photon.IrisFramebufferUtils;
import com.lowdragmc.photon.Photon;
import com.lowdragmc.photon.client.gameobject.emitter.PhotonParticleRenderType;
import com.lowdragmc.photon.client.gameobject.emitter.data.RendererSetting;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.IOException;
import java.lang.reflect.Field;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL20;

@OnlyIn(value=Dist.CLIENT)
public class BloomEffect {
    private static final Minecraft MC = Minecraft.m_91087_();
    private static int LAST_WIDTH;
    private static int LAST_HEIGHT;
    private static int LAST_GUI_WIDTH;
    private static int LAST_GUI_HEIGHT;
    private static RenderTarget INPUT;
    private static RenderTarget TRANSLUCENT_INPUT;
    private static RenderTarget GUI_INPUT;
    private static RenderTarget OUTPUT;
    private static RenderTarget SWAP2A;
    private static RenderTarget SWAP4A;
    private static RenderTarget SWAP8A;
    private static RenderTarget SWAP2B;
    private static RenderTarget SWAP4B;
    private static RenderTarget SWAP8B;
    private static final ShaderInstance PARTICLE;
    private static final ShaderInstance SEPARABLE_BLUR;
    private static final ShaderInstance UNREAL_COMPOSITE;
    private static Field lastFramebuffer;

    private static ShaderInstance loadShader(String shaderName) {
        return BloomEffect.loadShader(shaderName, DefaultVertexFormat.f_85814_);
    }

    private static ShaderInstance loadShader(String shaderName, VertexFormat format) {
        try {
            return new ShaderInstance((ResourceProvider)Minecraft.m_91087_().m_91098_(), shaderName, format);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static RenderTarget getInput() {
        BloomEffect.updateScreenSize();
        if (INPUT == null || IrisFramebufferUtils.getFboCachedField() != lastFramebuffer) {
            lastFramebuffer = IrisFramebufferUtils.getFboCachedField();
            int width = BloomEffect.MC.m_91385_().f_83915_;
            int height = BloomEffect.MC.m_91385_().f_83916_;
            BloomEffect.resetBloomTarget(width, height);
        }
        if (!Photon.isUsingShaderPack() || IrisFramebufferUtils.isRenderingGUIScreen()) {
            return GUI_INPUT;
        }
        return PhotonParticleRenderType.checkLayer(RendererSetting.Layer.Translucent) ? TRANSLUCENT_INPUT : INPUT;
    }

    private static void resetBloomTarget(int width, int height) {
        if (INPUT != null) {
            INPUT.m_83930_();
        }
        INPUT = BloomEffect.resize(null, width, height, true);
        BloomEffect.hookDepthBuffer(INPUT, Photon.getDepthTextureID());
        BloomEffect.hookColorBuffer(INPUT, Photon.getSolidTextureID(), 36064);
        BloomEffect.hookColorBuffer(INPUT, INPUT.m_83975_(), 36065);
        GL20.glDrawBuffers((int[])new int[]{36064, 36065});
        if (TRANSLUCENT_INPUT != null) {
            TRANSLUCENT_INPUT.m_83930_();
        }
        TRANSLUCENT_INPUT = BloomEffect.resize(null, width, height, true);
        BloomEffect.hookDepthBuffer(TRANSLUCENT_INPUT, Photon.getDepthTextureID());
        ((BloomTarget)TRANSLUCENT_INPUT).resetColorTexture(INPUT.m_83975_());
        BloomEffect.hookColorBuffer(TRANSLUCENT_INPUT, Photon.getTranslucentTextureID(false), 36064);
        BloomEffect.hookColorBuffer(TRANSLUCENT_INPUT, INPUT.m_83975_(), 36065);
        GL20.glDrawBuffers((int[])new int[]{36064, 36065});
    }

    private static void resetGuiTarget(int width, int height) {
        if (GUI_INPUT != null) {
            GUI_INPUT.m_83930_();
        }
        GUI_INPUT = BloomEffect.resize(null, width, height, true);
        BloomEffect.hookDepthBuffer(GUI_INPUT, Minecraft.m_91087_().m_91385_().m_83980_());
        BloomEffect.hookColorBuffer(GUI_INPUT, Minecraft.m_91087_().m_91385_().m_83975_(), 36064);
        BloomEffect.hookColorBuffer(GUI_INPUT, GUI_INPUT.m_83975_(), 36065);
        GL20.glDrawBuffers((int[])new int[]{36064, 36065});
    }

    public static ShaderInstance getParticleShader() {
        return PARTICLE;
    }

    public static void bindBloomShader() {
        RenderSystem.setShader(() -> PARTICLE);
    }

    public static void setBloomColor(int color) {
        if (RenderSystem.getShader() != null) {
            float r = ColorUtils.red((int)color);
            float g = ColorUtils.green((int)color);
            float b = ColorUtils.blue((int)color);
            float a = ColorUtils.alpha((int)color);
            RenderSystem.getShader().m_173356_("BloomColor").m_5805_(r, g, b, a);
        }
    }

    public static void setBloomColor(Vector4f color) {
        if (RenderSystem.getShader() != null) {
            RenderSystem.getShader().m_173356_("BloomColor").m_142558_(color);
        }
    }

    public static RenderTarget getOutput() {
        OUTPUT = BloomEffect.resize(OUTPUT, MC.m_91268_().m_85441_(), MC.m_91268_().m_85442_(), false);
        return OUTPUT;
    }

    public static void hookDepthBuffer(RenderTarget fbo, int depthBuffer) {
        GlStateManager._glBindFramebuffer((int)36160, (int)fbo.f_83920_);
        if (!Photon.isStencilEnabled(fbo)) {
            GlStateManager._glFramebufferTexture2D((int)36160, (int)36096, (int)3553, (int)depthBuffer, (int)0);
        } else if (Photon.useCombinedDepthStencilAttachment()) {
            GlStateManager._glFramebufferTexture2D((int)36160, (int)33306, (int)3553, (int)depthBuffer, (int)0);
        } else {
            GlStateManager._glFramebufferTexture2D((int)36160, (int)36096, (int)3553, (int)depthBuffer, (int)0);
            GlStateManager._glFramebufferTexture2D((int)36160, (int)36128, (int)3553, (int)depthBuffer, (int)0);
        }
    }

    public static void hookColorBuffer(RenderTarget fbo, int colorBuffer, int colorAttachment) {
        GlStateManager._glBindFramebuffer((int)36160, (int)fbo.f_83920_);
        GlStateManager._glFramebufferTexture2D((int)36160, (int)colorAttachment, (int)3553, (int)colorBuffer, (int)0);
    }

    public static void updateScreenSize() {
        boolean isGuiSizeChanged;
        int width = BloomEffect.MC.m_91385_().f_83915_;
        int height = BloomEffect.MC.m_91385_().f_83916_;
        int guiWidth = MC.m_91268_().m_85445_();
        int guiHeight = MC.m_91268_().m_85446_();
        boolean isSizeChanged = width != LAST_WIDTH || height != LAST_HEIGHT;
        boolean bl = isGuiSizeChanged = guiWidth != LAST_GUI_WIDTH || guiHeight != LAST_GUI_HEIGHT;
        if (!isSizeChanged && !isGuiSizeChanged) {
            return;
        }
        BloomEffect.resetBloomTarget(width, height);
        BloomEffect.resetGuiTarget(width, height);
        if (isSizeChanged) {
            OUTPUT = BloomEffect.resize(OUTPUT, width, height, false);
            SWAP2A = BloomEffect.resize(SWAP2A, width / 2, height / 2, false);
            SWAP4A = BloomEffect.resize(SWAP4A, width / 4, height / 4, false);
            SWAP8A = BloomEffect.resize(SWAP8A, width / 8, height / 8, false);
            SWAP2B = BloomEffect.resize(SWAP2B, width / 2, height / 2, false);
            SWAP4B = BloomEffect.resize(SWAP4B, width / 4, height / 4, false);
            SWAP8B = BloomEffect.resize(SWAP8B, width / 8, height / 8, false);
        }
        LAST_WIDTH = width;
        LAST_HEIGHT = height;
        LAST_GUI_WIDTH = guiWidth;
        LAST_GUI_HEIGHT = guiHeight;
    }

    private static RenderTarget resize(@Nullable RenderTarget target, int width, int height, boolean useDepth) {
        if (target == null) {
            target = new BloomTarget(width, height, useDepth, Minecraft.f_91002_);
            target.m_83931_(0.0f, 0.0f, 0.0f, 0.0f);
        }
        target.m_83941_(width, height, Minecraft.f_91002_);
        target.m_83936_(9729);
        return target;
    }

    public static void renderBloom(int background, int input, RenderTarget output) {
        BloomEffect.updateScreenSize();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        SEPARABLE_BLUR.m_173350_("DiffuseSampler", (Object)input);
        SEPARABLE_BLUR.m_173356_("BlurDir").m_7971_(1.0f, 0.0f);
        SEPARABLE_BLUR.m_173356_("Radius").m_142617_(3);
        SEPARABLE_BLUR.m_173356_("OutSize").m_7971_((float)BloomEffect.SWAP2A.f_83915_, (float)BloomEffect.SWAP2A.f_83916_);
        BloomEffect.blitShader(SEPARABLE_BLUR, SWAP2A);
        SEPARABLE_BLUR.m_173350_("DiffuseSampler", (Object)SWAP2A);
        SEPARABLE_BLUR.m_173356_("BlurDir").m_7971_(0.0f, 1.0f);
        SEPARABLE_BLUR.m_173356_("Radius").m_142617_(3);
        SEPARABLE_BLUR.m_173356_("OutSize").m_7971_((float)BloomEffect.SWAP2B.f_83915_, (float)BloomEffect.SWAP2B.f_83916_);
        BloomEffect.blitShader(SEPARABLE_BLUR, SWAP2B);
        SEPARABLE_BLUR.m_173350_("DiffuseSampler", (Object)SWAP2B);
        SEPARABLE_BLUR.m_173356_("BlurDir").m_7971_(1.0f, 0.0f);
        SEPARABLE_BLUR.m_173356_("Radius").m_142617_(5);
        SEPARABLE_BLUR.m_173356_("OutSize").m_7971_((float)BloomEffect.SWAP4A.f_83915_, (float)BloomEffect.SWAP4A.f_83916_);
        BloomEffect.blitShader(SEPARABLE_BLUR, SWAP4A);
        SEPARABLE_BLUR.m_173350_("DiffuseSampler", (Object)SWAP4A);
        SEPARABLE_BLUR.m_173356_("BlurDir").m_7971_(0.0f, 1.0f);
        SEPARABLE_BLUR.m_173356_("Radius").m_142617_(5);
        SEPARABLE_BLUR.m_173356_("OutSize").m_7971_((float)BloomEffect.SWAP4B.f_83915_, (float)BloomEffect.SWAP4B.f_83916_);
        BloomEffect.blitShader(SEPARABLE_BLUR, SWAP4B);
        SEPARABLE_BLUR.m_173350_("DiffuseSampler", (Object)SWAP4B);
        SEPARABLE_BLUR.m_173356_("BlurDir").m_7971_(1.0f, 0.0f);
        SEPARABLE_BLUR.m_173356_("Radius").m_142617_(7);
        SEPARABLE_BLUR.m_173356_("OutSize").m_7971_((float)BloomEffect.SWAP8A.f_83915_, (float)BloomEffect.SWAP8A.f_83916_);
        BloomEffect.blitShader(SEPARABLE_BLUR, SWAP8A);
        SEPARABLE_BLUR.m_173350_("DiffuseSampler", (Object)SWAP8A);
        SEPARABLE_BLUR.m_173356_("BlurDir").m_7971_(0.0f, 1.0f);
        SEPARABLE_BLUR.m_173356_("Radius").m_142617_(7);
        SEPARABLE_BLUR.m_173356_("OutSize").m_7971_((float)BloomEffect.SWAP8B.f_83915_, (float)BloomEffect.SWAP8B.f_83916_);
        BloomEffect.blitShader(SEPARABLE_BLUR, SWAP8B);
        UNREAL_COMPOSITE.m_173350_("DiffuseSampler", (Object)background);
        UNREAL_COMPOSITE.m_173350_("BlurTexture1", (Object)SWAP2B);
        UNREAL_COMPOSITE.m_173350_("BlurTexture2", (Object)SWAP4B);
        UNREAL_COMPOSITE.m_173350_("BlurTexture3", (Object)SWAP8B);
        UNREAL_COMPOSITE.m_173356_("BloomRadius").m_5985_(1.0f);
        BloomEffect.blitShader(UNREAL_COMPOSITE, output);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.enableDepthTest();
    }

    public static void blitShader(ShaderInstance shaderInstance, RenderTarget dist) {
        dist.m_83954_(Minecraft.f_91002_);
        dist.m_83947_(false);
        shaderInstance.m_173363_();
        Tesselator tesselator = RenderSystem.renderThreadTesselator();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        bufferbuilder.m_5483_(-1.0, 1.0, 0.0).m_5752_();
        bufferbuilder.m_5483_(-1.0, -1.0, 0.0).m_5752_();
        bufferbuilder.m_5483_(1.0, -1.0, 0.0).m_5752_();
        bufferbuilder.m_5483_(1.0, 1.0, 0.0).m_5752_();
        BufferUploader.m_231209_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        shaderInstance.m_173362_();
    }

    static {
        PARTICLE = BloomEffect.loadShader("photon:particle", DefaultVertexFormat.f_85813_);
        SEPARABLE_BLUR = BloomEffect.loadShader("photon:separable_blur");
        UNREAL_COMPOSITE = BloomEffect.loadShader("photon:unreal_composite");
    }

    public static class BloomTarget
    extends TextureTarget {
        public BloomTarget(int width, int height, boolean useDepth, boolean clearError) {
            super(width, height, useDepth, clearError);
        }

        public void resetColorTexture(int textureId) {
            if (this.f_83923_ > -1) {
                TextureUtil.releaseTextureId((int)this.f_83923_);
            }
            this.f_83923_ = textureId;
        }

        public void setColorTexture(int textureId) {
            this.f_83923_ = textureId;
        }
    }
}

