/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.gameobject.particle;

import com.lowdragmc.lowdraglib.utils.ColorUtils;
import com.lowdragmc.photon.client.gameobject.emitter.IParticleEmitter;
import com.lowdragmc.photon.client.gameobject.emitter.PhotonParticleRenderType;
import com.lowdragmc.photon.client.gameobject.emitter.beam.BeamConfig;
import com.lowdragmc.photon.client.gameobject.particle.IParticle;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.client.Camera;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

@OnlyIn(value=Dist.CLIENT)
public class BeamParticle
implements IParticle {
    protected float r = 1.0f;
    protected float g = 1.0f;
    protected float b = 1.0f;
    protected float a = 1.0f;
    protected float ro = 1.0f;
    protected float go = 1.0f;
    protected float bo = 1.0f;
    protected float ao = 1.0f;
    protected int light = -1;
    protected float emit;
    protected int delay;
    protected boolean isRemoved;
    protected BeamConfig config;
    protected IParticleEmitter emitter;
    protected ConcurrentHashMap<Object, Float> memRandom = new ConcurrentHashMap();
    public RandomSource randomSource;

    public BeamParticle(IParticleEmitter emitter, BeamConfig config, RandomSource randomSource) {
        this.emitter = emitter;
        this.config = config;
        this.randomSource = randomSource;
        this.setup();
    }

    public void setup() {
        this.setDelay(this.config.getStartDelay());
        this.update();
        this.updateOrigin();
    }

    @Override
    public void tick() {
        if (this.delay > 0) {
            --this.delay;
            return;
        }
        this.updateOrigin();
        this.update();
    }

    protected void updateOrigin() {
        this.ro = this.r;
        this.go = this.g;
        this.bo = this.b;
        this.ao = this.a;
    }

    protected void update() {
        this.updateChanges();
    }

    protected void updateChanges() {
        this.updateColor();
        this.updateLight();
    }

    protected void updateColor() {
        int color = this.config.getColor().get(this.getT(), () -> Float.valueOf(this.getMemRandom("color"))).intValue();
        this.r = ColorUtils.red((int)color);
        this.g = ColorUtils.green((int)color);
        this.b = ColorUtils.blue((int)color);
        this.a = ColorUtils.alpha((int)color);
    }

    protected void updateLight() {
        if (this.config.lights.isEnable() || this.config.renderer.isBloomEffect()) {
            return;
        }
        this.light = this.getLightColor();
    }

    public int getRealLight(float partialTicks) {
        if (this.config.renderer.isBloomEffect()) {
            return 0xF000F0;
        }
        if (this.config.lights.isEnable()) {
            return this.config.lights.getLight(this, partialTicks);
        }
        return this.light;
    }

    public int getLightColor() {
        Vector3f pos = this.getWorldPos();
        BlockPos blockPos = new BlockPos((int)pos.x, (int)pos.y, (int)pos.z);
        return this.emitter.getLightColor(blockPos);
    }

    public Vector3f getWorldPos() {
        return this.emitter.transform().position();
    }

    public Vector4f getRealColor(float partialTicks) {
        Vector4f emitterColor = this.emitter.getRGBAColor();
        float a = Mth.m_14179_((float)partialTicks, (float)this.ao, (float)this.a);
        float r = Mth.m_14179_((float)partialTicks, (float)this.ro, (float)this.r);
        float g = Mth.m_14179_((float)partialTicks, (float)this.go, (float)this.g);
        float b = Mth.m_14179_((float)partialTicks, (float)this.bo, (float)this.b);
        return emitterColor.mul(r, g, b, a);
    }

    public Vector4f getRealUVs(float partialTicks) {
        if (this.config.uvAnimation.isEnable()) {
            return this.config.uvAnimation.getUVs(this, partialTicks);
        }
        return new Vector4f(0.0f, 0.0f, 1.0f, 1.0f);
    }

    protected float getRealWidth(float pPartialTicks) {
        return this.config.getWidth().get(this.getT(pPartialTicks), () -> Float.valueOf(this.getMemRandom("width"))).floatValue();
    }

    protected float getRealEmit(float pPartialTicks) {
        return this.config.getEmitRate().get(this.getT(pPartialTicks), () -> Float.valueOf(this.getMemRandom("emit"))).floatValue();
    }

    @Override
    public void render(@Nonnull VertexConsumer pBuffer, @Nonnull Camera camera, float partialTicks) {
        if (this.delay <= 0 && this.emitter.isVisible()) {
            Vector3f cameraPos = camera.m_90583_().m_252839_();
            Vector3f from = this.getWorldPos();
            Vector3f end = new Vector3f((Vector3fc)from).add((Vector3fc)this.emitter.transform().localToWorldMatrix().transformDirection((Vector3fc)this.config.getEnd(), new Vector3f()));
            float offset = -this.getRealEmit(partialTicks);
            Vector4f uvs = this.getRealUVs(partialTicks);
            float u0 = uvs.x + offset;
            float u1 = uvs.z + offset;
            float v0 = uvs.y;
            float v1 = uvs.w;
            float beamHeight = this.getRealWidth(partialTicks);
            int light = this.getRealLight(partialTicks);
            Vector4f color = this.getRealColor(partialTicks);
            float r = color.x;
            float g = color.y;
            float b = color.z;
            float a = color.w;
            Vector3f direction = new Vector3f((Vector3fc)end).sub((Vector3fc)from);
            Vector3f toO = new Vector3f((Vector3fc)from).sub((Vector3fc)cameraPos);
            Vector3f n = new Vector3f((Vector3fc)toO).cross((Vector3fc)direction).normalize().mul(beamHeight);
            Vector3f p0 = new Vector3f((Vector3fc)from).add((Vector3fc)n).sub((Vector3fc)cameraPos);
            Vector3f p1 = new Vector3f((Vector3fc)from).add((Vector3fc)n.mul(-1.0f)).sub((Vector3fc)cameraPos);
            Vector3f p3 = new Vector3f((Vector3fc)end).add((Vector3fc)n).sub((Vector3fc)cameraPos);
            Vector3f p4 = new Vector3f((Vector3fc)end).add((Vector3fc)n.mul(-1.0f)).sub((Vector3fc)cameraPos);
            pBuffer.m_5483_((double)p1.x, (double)p1.y, (double)p1.z).m_7421_(u0, v0).m_85950_(r, g, b, a).m_85969_(light).m_5752_();
            pBuffer.m_5483_((double)p0.x, (double)p0.y, (double)p0.z).m_7421_(u0, v1).m_85950_(r, g, b, a).m_85969_(light).m_5752_();
            pBuffer.m_5483_((double)p4.x, (double)p4.y, (double)p4.z).m_7421_(u1, v1).m_85950_(r, g, b, a).m_85969_(light).m_5752_();
            pBuffer.m_5483_((double)p3.x, (double)p3.y, (double)p3.z).m_7421_(u1, v0).m_85950_(r, g, b, a).m_85969_(light).m_5752_();
        }
    }

    @Override
    public PhotonParticleRenderType getRenderType() {
        return this.config.particleRenderType;
    }

    @Override
    public float getT() {
        return this.emitter.getT();
    }

    @Override
    public float getT(float partialTicks) {
        return this.emitter.getT(partialTicks);
    }

    @Override
    public float getMemRandom(Object object) {
        return this.getMemRandom(object, RandomSource::m_188501_);
    }

    @Override
    public float getMemRandom(Object object, Function<RandomSource, Float> randomFunc) {
        Float value = this.memRandom.get(object);
        if (value == null) {
            return this.memRandom.computeIfAbsent(object, o -> (Float)randomFunc.apply(this.randomSource)).floatValue();
        }
        return value.floatValue();
    }

    public void setEmit(float emit) {
        this.emit = emit;
    }

    public float getEmit() {
        return this.emit;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setRemoved(boolean isRemoved) {
        this.isRemoved = isRemoved;
    }

    @Override
    public boolean isRemoved() {
        return this.isRemoved;
    }

    public IParticleEmitter getEmitter() {
        return this.emitter;
    }

    public ConcurrentHashMap<Object, Float> getMemRandom() {
        return this.memRandom;
    }

    @Override
    public RandomSource getRandomSource() {
        return this.randomSource;
    }
}

