/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.gameobject.emitter.particle;

import com.google.common.collect.Queues;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegisterClient;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.runtime.ConfiguratorParser;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.photon.client.gameobject.emitter.Emitter;
import com.lowdragmc.photon.client.gameobject.emitter.IParticleEmitter;
import com.lowdragmc.photon.client.gameobject.emitter.ParticleQueueRenderType;
import com.lowdragmc.photon.client.gameobject.emitter.PhotonParticleRenderType;
import com.lowdragmc.photon.client.gameobject.emitter.particle.ParticleConfig;
import com.lowdragmc.photon.client.gameobject.particle.IParticle;
import com.lowdragmc.photon.client.gameobject.particle.TileParticle;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Queue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Camera;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.phys.AABB;

@ParametersAreNonnullByDefault
@LDLRegisterClient(name="particle", group="emitter")
public class ParticleEmitter
extends Emitter {
    public static int VERSION = 2;
    @Persisted(subPersisted=true)
    public final ParticleConfig config;
    protected final Map<PhotonParticleRenderType, Queue<IParticle>> particles = new LinkedHashMap<PhotonParticleRenderType, Queue<IParticle>>();
    public final Queue<IParticle> waitToAdded = Queues.newArrayDeque();

    public ParticleEmitter() {
        this(new ParticleConfig());
    }

    protected ParticleEmitter(ParticleConfig config) {
        this.config = config;
    }

    @Override
    public ParticleEmitter shallowCopy() {
        return new ParticleEmitter(this.config);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        tag.m_128405_("_version", VERSION);
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        int version;
        int n = version = tag.m_128441_("_version") ? tag.m_128451_("_version") : 0;
        if (version < 1) {
            CompoundTag configTag = tag;
            tag = new CompoundTag();
            tag.m_128365_("config", (Tag)configTag);
            tag.m_128359_("name", configTag.m_128461_("name"));
        }
        super.deserializeNBT(tag);
    }

    public void buildConfigurator(ConfiguratorGroup father) {
        super.buildConfigurator(father);
        ConfiguratorParser.createConfigurators((ConfiguratorGroup)father, new HashMap(), this.config.getClass(), (Object)this.config);
    }

    protected TileParticle createNewParticle() {
        return new TileParticle(this, this.config, this.getThreadSafeRandomSource());
    }

    @Override
    public void update() {
        int available = this.config.maxParticles - this.getParticleAmount();
        if (!this.f_107220_ && this.getParticleAmount() < this.config.maxParticles) {
            available = Math.min(this.config.emission.getEmissionCount(this.f_107224_, this.t, this.getRandomSource()), available);
            for (int i = 0; i < available; ++i) {
                this.emitParticle(this.createNewParticle());
            }
        }
        if (!this.waitToAdded.isEmpty()) {
            for (IParticle p2 : this.waitToAdded) {
                this.particles.computeIfAbsent(p2.getRenderType(), type -> new ArrayDeque(this.config.maxParticles)).add(p2);
            }
            this.waitToAdded.clear();
        }
        for (Queue<IParticle> queue : this.particles.values()) {
            if (!(!this.config.parallelUpdate || this.config.physics.isEnable() && this.config.physics.isHasCollision())) {
                queue.removeIf(p -> !p.isAlive());
                queue.parallelStream().forEach(IParticle::tick);
                continue;
            }
            Iterator iter = queue.iterator();
            while (iter.hasNext()) {
                IParticle particle = (IParticle)iter.next();
                if (!particle.isAlive()) {
                    iter.remove();
                    continue;
                }
                particle.tick();
            }
        }
        super.update();
    }

    @Override
    public boolean isLooping() {
        return this.config.isLooping();
    }

    public void emitParticle(IParticle particle) {
        this.waitToAdded.add(particle);
    }

    public int m_107273_() {
        return this.config.duration;
    }

    @Override
    protected void updateOrigin() {
        super.updateOrigin();
        this.m_107257_(this.config.duration);
    }

    @Override
    public void reset() {
        super.reset();
        this.particles.clear();
    }

    @Override
    public void m_5744_(@Nonnull VertexConsumer buffer, Camera camera, float pPartialTicks) {
        super.m_5744_(buffer, camera, pPartialTicks);
        if (!ParticleQueueRenderType.INSTANCE.isRenderingQueue() && this.delay <= 0 && this.isVisible() && PhotonParticleRenderType.checkLayer(this.config.renderer.getLayer()) && (!this.config.renderer.getCull().isEnable() || PhotonParticleRenderType.checkFrustum(this.config.renderer.getCull().getCullAABB(this, pPartialTicks)))) {
            for (Map.Entry<PhotonParticleRenderType, Queue<IParticle>> entry : this.particles.entrySet()) {
                PhotonParticleRenderType type = entry.getKey();
                if (type == ParticleRenderType.f_107434_) continue;
                Queue<IParticle> queue = entry.getValue();
                if (type == ParticleQueueRenderType.INSTANCE) {
                    for (IParticle emitter : queue) {
                        emitter.render(buffer, camera, pPartialTicks);
                    }
                    continue;
                }
                if (queue.isEmpty()) continue;
                ParticleQueueRenderType.INSTANCE.pipeQueue(type, queue, camera, pPartialTicks);
            }
        }
    }

    @Override
    public int getParticleAmount() {
        int sum = 0;
        for (Map.Entry<PhotonParticleRenderType, Queue<IParticle>> entry : this.getParticles().entrySet()) {
            if (entry.getKey() == ParticleQueueRenderType.INSTANCE) {
                for (IParticle particle : entry.getValue()) {
                    sum += ((IParticleEmitter)((Object)particle)).getParticleAmount();
                }
            }
            sum += entry.getValue().size();
        }
        return sum + this.waitToAdded.size();
    }

    @Override
    @Nullable
    public AABB getCullBox(float partialTicks) {
        return this.config.renderer.getCull().isEnable() ? this.config.renderer.getCull().getCullAABB(this, partialTicks) : null;
    }

    @Override
    public void remove(boolean force) {
        super.remove(force);
        if (force) {
            this.particles.clear();
        }
    }

    public Map<PhotonParticleRenderType, Queue<IParticle>> getParticles() {
        return this.particles;
    }
}

