/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.gameobject.emitter.data.shape;

import com.lowdragmc.lowdraglib.client.bakedpipeline.IQuadTransformer;
import com.lowdragmc.lowdraglib.client.model.ModelFactory;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.gui.editor.configurator.WrapperConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.DialogWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.ITagSerializable;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class MeshData
implements ITagSerializable<CompoundTag>,
IConfigurable {
    public String meshName = "";
    public final List<Vector3f> vertices = new ArrayList<Vector3f>();
    public final List<Edge> edges = new ArrayList<Edge>();
    public final List<Triangle> triangles = new ArrayList<Triangle>();
    protected double edgeSumLength;
    protected double triangleSumArea;

    public MeshData() {
    }

    public MeshData(ResourceLocation modelLocation) {
        this.loadFromModel(modelLocation);
    }

    public void clear() {
        this.vertices.clear();
        this.edges.clear();
        this.triangles.clear();
        this.edgeSumLength = 0.0;
        this.triangleSumArea = 0.0;
        this.meshName = "";
    }

    public void loadFromModel(ResourceLocation modelLocation) {
        RandomSource random = RandomSource.m_216327_();
        BakedModel bakedModel = ModelFactory.getUnBakedModel((ResourceLocation)modelLocation).m_7611_(ModelFactory.getModeBaker(), Material::m_119204_, (ModelState)BlockModelRotation.X0_Y0, modelLocation);
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(bakedModel.m_213637_(null, null, random));
        for (Direction side : Direction.values()) {
            quads.addAll(bakedModel.m_213637_(null, side, random));
        }
        this.loadFromQuads(quads);
    }

    public void loadFromQuads(List<BakedQuad> quads) {
        this.clear();
        double sumLength = 0.0;
        double sumArea = 0.0;
        for (BakedQuad quad : quads) {
            int[] vertices = quad.m_111303_();
            Vector3f[] points = new Vector3f[4];
            for (int vertexIndex = 0; vertexIndex < 4; ++vertexIndex) {
                int offset = vertexIndex * IQuadTransformer.STRIDE + IQuadTransformer.POSITION;
                points[vertexIndex] = new Vector3f(Float.intBitsToFloat(vertices[offset]) - 0.5f, Float.intBitsToFloat(vertices[offset + 1]) - 0.5f, Float.intBitsToFloat(vertices[offset + 2]) - 0.5f);
                this.vertices.add(points[vertexIndex]);
            }
            sumLength += this.addEdge(points[0], points[1]);
            sumLength += this.addEdge(points[1], points[2]);
            sumLength += this.addEdge(points[2], points[3]);
            sumLength += this.addEdge(points[3], points[0]);
            sumLength += this.addEdge(points[1], points[3]);
            sumArea += this.addTriangle(points[0], points[1], points[2]);
            sumArea += this.addTriangle(points[2], points[3], points[0]);
        }
        this.edgeSumLength = sumLength;
        this.triangleSumArea = sumArea;
    }

    @Nullable
    public Vector3f getRandomVertex(float t) {
        if (this.vertices.isEmpty()) {
            return null;
        }
        return this.vertices.get((int)((float)this.vertices.size() * t));
    }

    @Nullable
    public Edge getRandomEdge(float t) {
        if (this.edges.isEmpty()) {
            return null;
        }
        double l = (double)t * this.edgeSumLength;
        double cl = 0.0;
        for (Edge edge : this.edges) {
            if (l <= edge.length + cl) {
                return edge;
            }
            cl += edge.length;
        }
        return this.edges.get(this.edges.size() - 1);
    }

    @Nullable
    public Triangle getRandomTriangle(float t) {
        if (this.triangles.isEmpty()) {
            return null;
        }
        double a = (double)t * this.triangleSumArea;
        double ca = 0.0;
        for (Triangle triangle : this.triangles) {
            if (a <= triangle.area + ca) {
                return triangle;
            }
            ca += triangle.area;
        }
        return this.triangles.get(this.triangles.size() - 1);
    }

    private double addEdge(Vector3f a, Vector3f b) {
        Edge ab = new Edge(a, b);
        if (ab.length > 0.0) {
            this.edges.add(ab);
        }
        return ab.length;
    }

    private double addTriangle(Vector3f a, Vector3f b, Vector3f c) {
        Triangle abc = new Triangle(a, b, c);
        if (abc.area > 0.0) {
            this.triangles.add(abc);
        }
        return abc.area;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        ListTag list = new ListTag();
        for (Vector3f vertex : this.vertices) {
            this.saveVector3(list, vertex);
        }
        tag.m_128365_("vertices", (Tag)list);
        list = new ListTag();
        for (Edge edge : this.edges) {
            this.saveVector3(list, edge.a);
            this.saveVector3(list, edge.b);
        }
        tag.m_128365_("edges", (Tag)list);
        list = new ListTag();
        for (Triangle triangle : this.triangles) {
            this.saveVector3(list, triangle.a);
            this.saveVector3(list, triangle.b);
            this.saveVector3(list, triangle.c);
        }
        tag.m_128365_("triangles", (Tag)list);
        tag.m_128350_("sl", (float)this.edgeSumLength);
        tag.m_128350_("sa", (float)this.triangleSumArea);
        tag.m_128359_("meshName", this.meshName);
        return tag;
    }

    private void saveVector3(ListTag list, Vector3f vec) {
        list.add((Object)FloatTag.m_128566_((float)vec.x));
        list.add((Object)FloatTag.m_128566_((float)vec.y));
        list.add((Object)FloatTag.m_128566_((float)vec.z));
    }

    private Vector3f loadVector3(ListTag list, int index) {
        return new Vector3f(list.m_128775_(index), list.m_128775_(index + 1), list.m_128775_(index + 2));
    }

    public void deserializeNBT(CompoundTag tag) {
        int i;
        this.clear();
        ListTag list = tag.m_128437_("vertices", 5);
        for (i = 0; i < list.size(); i += 3) {
            this.vertices.add(this.loadVector3(list, i));
        }
        list = tag.m_128437_("edges", 5);
        for (i = 0; i < list.size(); i += 6) {
            this.edges.add(new Edge(this.loadVector3(list, i), this.loadVector3(list, i + 3)));
        }
        list = tag.m_128437_("triangles", 5);
        for (i = 0; i < list.size(); i += 9) {
            this.triangles.add(new Triangle(this.loadVector3(list, i), this.loadVector3(list, i + 3), this.loadVector3(list, i + 6)));
        }
        this.edgeSumLength = tag.m_128457_("sl");
        this.triangleSumArea = tag.m_128457_("sa");
        this.meshName = tag.m_128461_("meshName");
    }

    public void buildConfigurator(ConfiguratorGroup father) {
        WrapperConfigurator wrapper = new WrapperConfigurator("", (Widget)new ButtonWidget(0, 0, 200, 10, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ColorPattern.T_GRAY.rectTexture().setRadius(5.0f), new TextTexture("meshName").setType(TextTexture.TextType.ROLL_ALWAYS).setWidth(200)}), cd -> {
            File path = new File(Editor.INSTANCE.getWorkSpace(), "assets/ldlib/models");
            DialogWidget.showFileDialog((WidgetGroup)Editor.INSTANCE, (String)"select a model", (File)path, (boolean)true, (Predicate)DialogWidget.suffixFilter((String[])new String[]{".json"}), r -> {
                if (r != null && r.isFile()) {
                    String lastName = this.meshName;
                    ResourceLocation modelLocation = new ResourceLocation("ldlib:" + r.getPath().replace(path.getPath(), "").substring(1).replace(".json", "").replace('\\', '/'));
                    this.loadFromModel(modelLocation);
                    this.meshName = lastName;
                }
            });
        }));
        wrapper.setTips(new String[]{"click to select a minecraft model file."});
        father.addConfigurators(new Configurator[]{wrapper});
    }

    public double getEdgeSumLength() {
        return this.edgeSumLength;
    }

    public double getTriangleSumArea() {
        return this.triangleSumArea;
    }

    public static class Edge {
        public final Vector3f a;
        public final Vector3f b;
        public final double length;

        public Edge(Vector3f a, Vector3f b) {
            this.a = a;
            this.b = b;
            this.length = new Vector3f((Vector3fc)a).sub((Vector3fc)b).length();
        }
    }

    public static class Triangle {
        public final Vector3f a;
        public final Vector3f b;
        public final Vector3f c;
        public final double area;

        public Triangle(Vector3f a, Vector3f b, Vector3f c) {
            this.a = a;
            this.b = b;
            this.c = c;
            float nx = (b.y - a.y) * (c.z - a.z) - (b.z - a.z) * (c.y - a.y);
            float ny = (b.z - a.z) * (c.x - a.x) - (b.x - a.x) * (c.z - a.z);
            float nz = (b.x - a.x) * (c.y - a.y) - (b.y - a.y) * (c.x - a.x);
            this.area = 0.5 * Math.sqrt(nx * nx + ny * ny + nz * nz);
        }
    }
}

