/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.gameobject.emitter.data.shape;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.utils.Vector3fHelper;
import com.lowdragmc.photon.client.gameobject.emitter.IParticleEmitter;
import com.lowdragmc.photon.client.gameobject.emitter.data.shape.IShape;
import com.lowdragmc.photon.client.gameobject.particle.TileParticle;
import net.minecraft.util.RandomSource;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@LDLRegister(name="cylinder", group="shape")
public class Cylinder
implements IShape {
    @Configurable
    @NumberRange(range={0.0, 1000.0})
    private float radius = 0.5f;
    @Configurable
    @NumberRange(range={0.0, 1.0})
    private float radiusThickness = 1.0f;
    @Configurable
    @NumberRange(range={0.0, 360.0}, wheel=10.0)
    private float arc = 360.0f;

    @Override
    public void nextPosVel(TileParticle particle, IParticleEmitter emitter, Vector3f position, Vector3f rotation, Vector3f scale) {
        RandomSource random = particle.getRandomSource();
        float outer = this.radius;
        float inner = (1.0f - this.radiusThickness) * this.radius;
        float origin = inner * inner;
        float bound = outer * outer;
        double r = outer == inner ? (double)outer : Math.sqrt((double)origin + random.m_188500_() * (double)(bound - origin));
        double theta = (double)(this.arc * ((float)Math.PI * 2)) * random.m_188500_() / 360.0;
        Vector3f pos = new Vector3f((float)(r * Math.cos(theta)), random.m_188501_() * scale.y - scale.y / 2.0f, (float)(r * Math.sin(theta))).mul((Vector3fc)scale);
        particle.setLocalPos(Vector3fHelper.rotateYXY((Vector3f)new Vector3f((Vector3fc)pos), (Vector3f)rotation).add((Vector3fc)position).add((Vector3fc)particle.getLocalPos()), true);
        particle.setInternalVelocity(Vector3fHelper.rotateYXY((Vector3f)new Vector3f((Vector3fc)pos).normalize().mul(0.05f), (Vector3f)rotation));
    }

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public float getRadiusThickness() {
        return this.radiusThickness;
    }

    public void setRadiusThickness(float radiusThickness) {
        this.radiusThickness = radiusThickness;
    }

    public float getArc() {
        return this.arc;
    }

    public void setArc(float arc) {
        this.arc = arc;
    }
}

