/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.gameobject.emitter.data.shape;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.utils.Vector3fHelper;
import com.lowdragmc.photon.client.gameobject.emitter.IParticleEmitter;
import com.lowdragmc.photon.client.gameobject.emitter.data.shape.IShape;
import com.lowdragmc.photon.client.gameobject.particle.TileParticle;
import net.minecraft.util.RandomSource;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@LDLRegister(name="cone", group="shape")
public class Cone
implements IShape {
    @Configurable
    @NumberRange(range={0.0, 90.0}, wheel=10.0)
    private float angle = 25.0f;
    @Configurable
    @NumberRange(range={0.0, 1000.0})
    private float radius = 0.5f;
    @Configurable
    @NumberRange(range={0.0, 1.0})
    private float radiusThickness = 1.0f;
    @Configurable
    @NumberRange(range={0.0, 360.0}, wheel=10.0)
    private float arc = 360.0f;

    @Override
    public void nextPosVel(TileParticle particle, IParticleEmitter emitter, Vector3f position, Vector3f rotation, Vector3f scale) {
        RandomSource random = particle.getRandomSource();
        float outer = this.radius;
        float inner = (1.0f - this.radiusThickness) * this.radius;
        float origin = inner * inner;
        float bound = outer * outer;
        double r = outer == inner ? (double)outer : Math.sqrt((double)origin + random.m_188500_() * (double)(bound - origin));
        double theta = (double)(this.arc * ((float)Math.PI * 2)) * random.m_188500_() / 360.0;
        Vector3f pos = new Vector3f((float)(r * Math.cos(theta)), 0.0f, (float)(r * Math.sin(theta))).mul((Vector3fc)scale);
        Vector3f speed = new Vector3f(0.0f, 1.0f, 0.0f).rotateAxis((float)(r / (double)this.radius * Math.toRadians(this.angle)), 0.0f, 0.0f, -1.0f).rotateAxis((float)theta, 0.0f, -1.0f, 0.0f);
        particle.setLocalPos(Vector3fHelper.rotateYXY((Vector3f)new Vector3f((Vector3fc)pos), (Vector3f)rotation).add((Vector3fc)position).add((Vector3fc)particle.getLocalPos()), true);
        particle.setInternalVelocity(Vector3fHelper.rotateYXY((Vector3f)speed.normalize().mul(0.05f), (Vector3f)rotation));
    }

    public float getAngle() {
        return this.angle;
    }

    public void setAngle(float angle) {
        this.angle = angle;
    }

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public float getRadiusThickness() {
        return this.radiusThickness;
    }

    public void setRadiusThickness(float radiusThickness) {
        this.radiusThickness = radiusThickness;
    }

    public float getArc() {
        return this.arc;
    }

    public void setArc(float arc) {
        this.arc = arc;
    }
}

