/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.gameobject.emitter.data.number.curve;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.texture.TransformTexture;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.ECBCurves;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

public class RandomCurveTexture
extends TransformTexture {
    private final ECBCurves curves0;
    private final ECBCurves curves1;
    private int color;
    private float width;

    public RandomCurveTexture(ECBCurves curves0, ECBCurves curves1) {
        this.color = ColorPattern.T_GREEN.color;
        this.width = 0.5f;
        this.curves0 = curves0;
        this.curves1 = curves1;
    }

    public RandomCurveTexture setColor(int color) {
        this.color = color;
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void drawInternal(GuiGraphics graphics, int mouseX, int mouseY, float x, float y, int width, int height) {
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        Matrix4f matrix = graphics.m_280168_().m_85850_().m_252922_();
        Function<Vec2, Vec2> getPointPosition = coord -> new Vec2(x + (float)width * coord.f_82470_, y + (float)height * (1.0f - coord.f_82471_));
        for (int i = 0; i < width; ++i) {
            float x0 = (float)i * 1.0f / (float)width;
            float x1 = (float)(i + 1) * 1.0f / (float)width;
            Vec2 p0 = getPointPosition.apply(new Vec2(x0, this.curves0.getCurveY(x0)));
            Vec2 p1 = getPointPosition.apply(new Vec2(x1, this.curves0.getCurveY(x1)));
            Vec2 p2 = getPointPosition.apply(new Vec2(x1, this.curves1.getCurveY(x1)));
            Vec2 p3 = getPointPosition.apply(new Vec2(x0, this.curves1.getCurveY(x0)));
            bufferBuilder.m_252986_(matrix, p0.f_82470_, p0.f_82471_, 0.0f).m_193479_(ColorPattern.T_RED.color).m_5752_();
            bufferBuilder.m_252986_(matrix, p1.f_82470_, p1.f_82471_, 0.0f).m_193479_(ColorPattern.T_RED.color).m_5752_();
            bufferBuilder.m_252986_(matrix, p2.f_82470_, p2.f_82471_, 0.0f).m_193479_(ColorPattern.T_RED.color).m_5752_();
            bufferBuilder.m_252986_(matrix, p3.f_82470_, p3.f_82471_, 0.0f).m_193479_(ColorPattern.T_RED.color).m_5752_();
            bufferBuilder.m_252986_(matrix, p3.f_82470_, p3.f_82471_, 0.0f).m_193479_(ColorPattern.T_RED.color).m_5752_();
            bufferBuilder.m_252986_(matrix, p2.f_82470_, p2.f_82471_, 0.0f).m_193479_(ColorPattern.T_RED.color).m_5752_();
            bufferBuilder.m_252986_(matrix, p1.f_82470_, p1.f_82471_, 0.0f).m_193479_(ColorPattern.T_RED.color).m_5752_();
            bufferBuilder.m_252986_(matrix, p0.f_82470_, p0.f_82471_, 0.0f).m_193479_(ColorPattern.T_RED.color).m_5752_();
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        this.renderLines(graphics, this.curves0, x, y, width, height);
        this.renderLines(graphics, this.curves1, x, y, width, height);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderLines(GuiGraphics graphics, ECBCurves curves, float x, float y, int width, int height) {
        ArrayList<Vec2> points = new ArrayList<Vec2>();
        for (int i = 0; i < width; ++i) {
            float coordX = (float)i * 1.0f / (float)width;
            points.add(new Vec2(coordX, curves.getCurveY(coordX)));
        }
        points.add(new Vec2(1.0f, curves.getCurveY(1.0f)));
        DrawerHelper.drawLines((GuiGraphics)graphics, points.stream().map(coord -> new Vec2(x + (float)width * coord.f_82470_, y + (float)height * (1.0f - coord.f_82471_))).toList(), (int)this.color, (int)this.color, (float)this.width);
    }

    public void setWidth(float width) {
        this.width = width;
    }
}

