/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.gameobject.emitter.data.number.curve;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.texture.ColorRectTexture;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.gui.util.TreeBuilder;
import com.lowdragmc.lowdraglib.gui.widget.MenuWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import com.lowdragmc.lowdraglib.utils.curve.ExplicitCubicBezierCurve2;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.ECBCurves;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class CurveLineWidget
extends WidgetGroup {
    public final ECBCurves curves;
    protected boolean lockControlPoint = true;
    protected int selectedPoint = -1;
    protected boolean renderGrid = true;
    protected Size gridSize = new Size(2, 2);
    protected Consumer<ECBCurves> onUpdate;
    protected Function<Vec2, Component> hoverTips;
    private boolean isDraggingPoint;
    private boolean isDraggingLeftControlPoint;
    private boolean isDraggingRightControlPoint;
    private long lastClickTick;

    public CurveLineWidget(int x, int y, int width, int height, ECBCurves curves) {
        super(x, y, width, height);
        this.curves = curves;
    }

    public Vec2 getPointPosition(Vec2 coord) {
        Size size = this.getSize();
        Position position = this.getPosition();
        return new Vec2((float)position.x + (float)size.width * coord.f_82470_, (float)position.y + (float)size.height * (1.0f - coord.f_82471_));
    }

    public Vec2 getPointCoordinate(Vec2 pos) {
        Size size = this.getSize();
        Position position = this.getPosition();
        return new Vec2((pos.f_82470_ - (float)position.x) / (float)size.width, 1.0f - (pos.f_82471_ - (float)position.y) / (float)size.height);
    }

    public Vec2 getPointCoordinate(int index) {
        if (index < this.curves.size()) {
            return ((ExplicitCubicBezierCurve2)this.curves.get((int)index)).p0;
        }
        if (index > 0) {
            return ((ExplicitCubicBezierCurve2)this.curves.get((int)(index - 1))).p1;
        }
        return null;
    }

    public void setPointCoordinate(int index, Vec2 coord) {
        Vec2 offset;
        if (index < this.curves.size()) {
            offset = new Vec2(coord.f_82470_ - ((ExplicitCubicBezierCurve2)this.curves.get((int)index)).p0.f_82470_, coord.f_82471_ - ((ExplicitCubicBezierCurve2)this.curves.get((int)index)).p0.f_82471_);
            ((ExplicitCubicBezierCurve2)this.curves.get((int)index)).p0 = coord;
            ((ExplicitCubicBezierCurve2)this.curves.get((int)index)).c0 = ((ExplicitCubicBezierCurve2)this.curves.get((int)index)).c0.m_165910_(offset);
        }
        if (index > 0) {
            offset = new Vec2(coord.f_82470_ - ((ExplicitCubicBezierCurve2)this.curves.get((int)(index - 1))).p1.f_82470_, coord.f_82471_ - ((ExplicitCubicBezierCurve2)this.curves.get((int)(index - 1))).p1.f_82471_);
            ((ExplicitCubicBezierCurve2)this.curves.get((int)(index - 1))).p1 = coord;
            ((ExplicitCubicBezierCurve2)this.curves.get((int)(index - 1))).c1 = ((ExplicitCubicBezierCurve2)this.curves.get((int)(index - 1))).c1.m_165910_(offset);
        }
    }

    public void setLeftControlPointCoordinate(int index, Vec2 coord) {
        if (index > 0) {
            ((ExplicitCubicBezierCurve2)this.curves.get((int)(index - 1))).c1 = coord;
        }
    }

    public void setRightControlPointCoordinate(int index, Vec2 coord) {
        if (index < this.curves.size()) {
            ((ExplicitCubicBezierCurve2)this.curves.get((int)index)).c0 = coord;
        }
    }

    protected void notifyChanged() {
        if (this.onUpdate != null) {
            this.onUpdate.accept(this.curves);
        }
    }

    protected void openMenu(int mouseX, int mouseY) {
        TreeBuilder.Menu menu = TreeBuilder.Menu.start().leaf((IGuiTexture)(this.lockControlPoint ? Icons.CHECK : IGuiTexture.EMPTY), "Lock Controll Points", () -> {
            this.lockControlPoint = !this.lockControlPoint;
        }).branch("Grid", m -> m.leaf("2\u00d72", () -> this.setGridSize(new Size(2, 2))).leaf("6\u00d72", () -> this.setGridSize(new Size(6, 2))).leaf("6\u00d74", () -> this.setGridSize(new Size(6, 4))));
        if (this.selectedPoint != -1 && this.curves.size() > 1) {
            menu.leaf("Remove", () -> {
                if (this.selectedPoint == 0) {
                    this.curves.remove(0);
                } else if (this.selectedPoint > 0 && this.selectedPoint < this.curves.size()) {
                    ((ExplicitCubicBezierCurve2)this.curves.get((int)(this.selectedPoint - 1))).p1 = ((ExplicitCubicBezierCurve2)this.curves.get((int)this.selectedPoint)).p1;
                    ((ExplicitCubicBezierCurve2)this.curves.get((int)(this.selectedPoint - 1))).c1 = ((ExplicitCubicBezierCurve2)this.curves.get((int)this.selectedPoint)).c0;
                    this.curves.remove(this.selectedPoint);
                } else if (this.selectedPoint >= this.curves.size()) {
                    this.curves.remove(this.curves.size() - 1);
                }
                this.selectedPoint = -1;
                this.notifyChanged();
            });
            MenuWidget widget = new MenuWidget(mouseX - this.getPosition().x, mouseY - this.getPosition().y, 14, menu.build()).setNodeTexture(new IGuiTexture(){

                @OnlyIn(value=Dist.CLIENT)
                public void draw(GuiGraphics graphics, int mouseX, int mouseY, float x, float y, int width, int height) {
                    ColorPattern.BLACK.rectTexture().draw(graphics, mouseX, mouseY, x, y, width, height);
                    Icons.RIGHT.draw(graphics, mouseX, mouseY, x + (float)width - (float)height + 3.0f, y + 3.0f, height - 6, height - 6);
                }
            }).setLeafTexture((IGuiTexture)ColorPattern.BLACK.rectTexture()).setNodeHoverTexture((IGuiTexture)ColorPattern.T_GRAY.rectTexture()).setCrossLinePredicate(TreeBuilder.Menu::isCrossLine).setKeyIconSupplier(TreeBuilder.Menu::getIcon).setKeyNameSupplier(TreeBuilder.Menu::getName).setOnNodeClicked(TreeBuilder.Menu::handle);
            this.waitToAdded(widget.setBackground(new IGuiTexture[]{new ColorRectTexture(-12828346), ColorPattern.GRAY.borderTexture(1)}));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (CurveLineWidget.isMouseOver((int)(this.getPosition().x - 2), (int)(this.getPosition().y - 2), (int)(this.getSize().width + 4), (int)(this.getSize().height + 4), (double)mouseX, (double)mouseY)) {
            if (button == 1) {
                this.openMenu((int)mouseX, (int)mouseY);
            } else {
                long clickTick = this.gui.getTickCount();
                for (int i = 0; i < this.curves.size(); ++i) {
                    Vec2 pos;
                    ExplicitCubicBezierCurve2 curve = (ExplicitCubicBezierCurve2)this.curves.get(i);
                    if (i == 0) {
                        pos = this.getPointPosition(curve.p0);
                        if (CurveLineWidget.isMouseOver((int)((int)(pos.f_82470_ - 2.0f)), (int)((int)(pos.f_82471_ - 2.0f)), (int)4, (int)4, (double)mouseX, (double)mouseY)) {
                            this.selectedPoint = 0;
                            this.isDraggingPoint = true;
                            return true;
                        }
                    }
                    pos = this.getPointPosition(curve.p1);
                    if (!CurveLineWidget.isMouseOver((int)((int)(pos.f_82470_ - 2.0f)), (int)((int)(pos.f_82471_ - 2.0f)), (int)4, (int)4, (double)mouseX, (double)mouseY)) continue;
                    this.selectedPoint = i + 1;
                    this.isDraggingPoint = true;
                    return true;
                }
                if (this.selectedPoint >= 0) {
                    if (this.selectedPoint > 0) {
                        Vec2 pos = this.getPointPosition(((ExplicitCubicBezierCurve2)this.curves.get((int)(this.selectedPoint - 1))).c1);
                        if (CurveLineWidget.isMouseOver((int)((int)(pos.f_82470_ - 2.0f)), (int)((int)(pos.f_82471_ - 2.0f)), (int)4, (int)4, (double)mouseX, (double)mouseY)) {
                            this.isDraggingLeftControlPoint = true;
                            return true;
                        }
                    }
                    if (this.selectedPoint < this.curves.size()) {
                        Vec2 pos = this.getPointPosition(((ExplicitCubicBezierCurve2)this.curves.get((int)this.selectedPoint)).c0);
                        if (CurveLineWidget.isMouseOver((int)((int)(pos.f_82470_ - 2.0f)), (int)((int)(pos.f_82471_ - 2.0f)), (int)4, (int)4, (double)mouseX, (double)mouseY)) {
                            this.isDraggingRightControlPoint = true;
                            return true;
                        }
                    }
                }
                if (clickTick - this.lastClickTick < 12L && this.isMouseOverElement(mouseX, mouseY)) {
                    this.lastClickTick = 0L;
                    float x = (float)((mouseX - (double)this.getPosition().x) / (double)this.getSize().width);
                    float y = ((ExplicitCubicBezierCurve2)this.curves.get((int)0)).p0.f_82471_;
                    boolean found = x < ((ExplicitCubicBezierCurve2)this.curves.get((int)0)).p0.f_82470_;
                    int index = 0;
                    if (!found) {
                        for (ExplicitCubicBezierCurve2 curve : this.curves) {
                            ++index;
                            if (!(x >= curve.p0.f_82470_) || !(x <= curve.p1.f_82470_)) continue;
                            y = curve.getPoint((float)((x - curve.p0.f_82470_) / (curve.p1.f_82470_ - curve.p0.f_82470_))).f_82471_;
                            found = true;
                            break;
                        }
                    }
                    if (!found) {
                        ++index;
                        y = ((ExplicitCubicBezierCurve2)this.curves.get((int)(this.curves.size() - 1))).p1.f_82471_;
                    }
                    Vec2 position = this.getPointPosition(new Vec2(x, y));
                    if (CurveLineWidget.isMouseOver((int)((int)(position.f_82470_ - 2.0f)), (int)((int)(position.f_82471_ - 2.0f)), (int)4, (int)4, (double)mouseX, (double)mouseY)) {
                        if (index == 0) {
                            Vec2 right = ((ExplicitCubicBezierCurve2)this.curves.get((int)0)).p0;
                            Vec2 rightCP = ((ExplicitCubicBezierCurve2)this.curves.get((int)index)).c0;
                            this.curves.add(0, new ExplicitCubicBezierCurve2(new Vec2(x, y), new Vec2(x + 0.1f, y), new Vec2(right.f_82470_ + (right.f_82470_ - rightCP.f_82470_), right.f_82471_ + (right.f_82471_ - rightCP.f_82471_)), right));
                        } else if (index > this.curves.size()) {
                            Vec2 left = ((ExplicitCubicBezierCurve2)this.curves.get((int)(this.curves.size() - 1))).p1;
                            Vec2 leftCP = ((ExplicitCubicBezierCurve2)this.curves.get((int)(this.curves.size() - 1))).c1;
                            this.curves.add(new ExplicitCubicBezierCurve2(left, new Vec2(left.f_82470_ + (left.f_82470_ - leftCP.f_82470_), left.f_82471_ + (left.f_82471_ - leftCP.f_82471_)), new Vec2(x - 0.1f, y), new Vec2(x, y)));
                        } else {
                            ExplicitCubicBezierCurve2 curve;
                            curve = (ExplicitCubicBezierCurve2)this.curves.get(index - 1);
                            this.curves.add(index, new ExplicitCubicBezierCurve2(new Vec2(x, y), new Vec2(x + 0.1f, y), curve.c1, curve.p1));
                            curve.c1 = new Vec2(x - 0.1f, y);
                            curve.p1 = new Vec2(x, y);
                        }
                        this.notifyChanged();
                    }
                } else {
                    this.lastClickTick = clickTick;
                }
            }
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.isDraggingPoint = false;
        this.isDraggingLeftControlPoint = false;
        this.isDraggingRightControlPoint = false;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        Size size = this.getSize();
        Position position = this.getPosition();
        if (this.selectedPoint >= 0) {
            Vec2 coord;
            if (this.isDraggingPoint) {
                float minX = position.x;
                float maxX = position.x + size.width;
                if (this.selectedPoint > 0) {
                    minX = Math.max(minX, this.getPointPosition((Vec2)this.getPointCoordinate((int)(this.selectedPoint - 1))).f_82470_);
                }
                if (this.selectedPoint < this.curves.size()) {
                    maxX = Math.min(maxX, this.getPointPosition((Vec2)this.getPointCoordinate((int)(this.selectedPoint + 1))).f_82470_);
                }
                coord = this.getPointCoordinate(new Vec2((float)Mth.m_14008_((double)mouseX, (double)minX, (double)maxX), (float)Mth.m_14008_((double)mouseY, (double)position.y, (double)(position.y + size.height))));
                this.setPointCoordinate(this.selectedPoint, coord);
                this.notifyChanged();
            }
            Vec2 point = this.getPointCoordinate(this.selectedPoint);
            Vec2 pointPos = this.getPointPosition(point);
            if (this.isDraggingLeftControlPoint) {
                coord = this.getPointCoordinate(new Vec2((float)Mth.m_14008_((double)mouseX, (double)position.x, (double)pointPos.f_82470_), (float)mouseY));
                this.setLeftControlPointCoordinate(this.selectedPoint, coord);
                if (this.lockControlPoint) {
                    this.setRightControlPointCoordinate(this.selectedPoint, new Vec2(point.f_82470_ + (point.f_82470_ - coord.f_82470_), point.f_82471_ + (point.f_82471_ - coord.f_82471_)));
                }
                this.notifyChanged();
            }
            if (this.isDraggingRightControlPoint) {
                coord = this.getPointCoordinate(new Vec2((float)Mth.m_14008_((double)mouseX, (double)pointPos.f_82470_, (double)(position.x + size.width)), (float)mouseY));
                this.setRightControlPointCoordinate(this.selectedPoint, coord);
                if (this.lockControlPoint) {
                    this.setLeftControlPointCoordinate(this.selectedPoint, new Vec2(point.f_82470_ + (point.f_82470_ - coord.f_82470_), point.f_82471_ + (point.f_82471_ - coord.f_82471_)));
                }
                this.notifyChanged();
            }
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawInBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        Size size;
        Position pos;
        if (this.backgroundTexture != null) {
            pos = this.getPosition();
            size = this.getSize();
            this.backgroundTexture.draw(graphics, mouseX, mouseY, (float)pos.x, (float)pos.y, size.width, size.height);
        }
        if (this.hoverTexture != null && this.isMouseOverElement(mouseX, mouseY)) {
            pos = this.getPosition();
            size = this.getSize();
            this.hoverTexture.draw(graphics, mouseX, mouseY, (float)pos.x, (float)pos.y, size.width, size.height);
        }
        if (this.renderGrid) {
            int i;
            pos = this.getPosition();
            size = this.getSize();
            for (i = 0; i < this.gridSize.width; ++i) {
                DrawerHelper.drawSolidRect((GuiGraphics)graphics, (int)(pos.x + i * this.getSize().width / this.gridSize.width), (int)pos.y, (int)1, (int)size.height, (int)ColorPattern.T_GRAY.color);
            }
            for (i = 0; i < this.gridSize.height; ++i) {
                DrawerHelper.drawSolidRect((GuiGraphics)graphics, (int)pos.x, (int)(pos.y + i * this.getSize().height / this.gridSize.height), (int)size.width, (int)1, (int)ColorPattern.T_GRAY.color);
            }
        }
        List points = this.curves.stream().flatMap(curve -> curve.getPoints(100).stream().map(this::getPointPosition).toList().stream()).collect(Collectors.toList());
        DrawerHelper.drawLines((GuiGraphics)graphics, points, (int)-1, (int)-1, (float)0.5f);
        Collections.reverse(points);
        DrawerHelper.drawLines((GuiGraphics)graphics, points, (int)-1, (int)-1, (float)0.5f);
        if (((ExplicitCubicBezierCurve2)this.curves.get((int)0)).p0.f_82470_ > 0.0f) {
            DrawerHelper.drawLines((GuiGraphics)graphics, List.of(this.getPointPosition(new Vec2(0.0f, ((ExplicitCubicBezierCurve2)this.curves.get((int)0)).p0.f_82471_)), this.getPointPosition(((ExplicitCubicBezierCurve2)this.curves.get((int)0)).p0)), (int)ColorPattern.T_RED.color, (int)ColorPattern.T_RED.color, (float)0.3f);
        }
        if (((ExplicitCubicBezierCurve2)this.curves.get((int)(this.curves.size() - 1))).p1.f_82470_ < 1.0f) {
            DrawerHelper.drawLines((GuiGraphics)graphics, List.of(this.getPointPosition(new Vec2(1.0f, ((ExplicitCubicBezierCurve2)this.curves.get((int)(this.curves.size() - 1))).p1.f_82471_)), this.getPointPosition(((ExplicitCubicBezierCurve2)this.curves.get((int)(this.curves.size() - 1))).p1)), (int)ColorPattern.T_RED.color, (int)ColorPattern.T_RED.color, (float)0.3f);
        }
        if (this.selectedPoint >= 0) {
            ExplicitCubicBezierCurve2 curve2;
            if (this.selectedPoint > 0) {
                curve2 = (ExplicitCubicBezierCurve2)this.curves.get(this.selectedPoint - 1);
                DrawerHelper.drawLines((GuiGraphics)graphics, List.of(this.getPointPosition(curve2.c1), this.getPointPosition(curve2.p1)), (int)ColorPattern.T_GREEN.color, (int)ColorPattern.T_GREEN.color, (float)0.3f);
                this.renderControlPoint(curve2.c1, graphics);
            }
            if (this.selectedPoint < this.curves.size()) {
                curve2 = (ExplicitCubicBezierCurve2)this.curves.get(this.selectedPoint);
                DrawerHelper.drawLines((GuiGraphics)graphics, List.of(this.getPointPosition(curve2.c0), this.getPointPosition(curve2.p0)), (int)ColorPattern.T_GREEN.color, (int)ColorPattern.T_GREEN.color, (float)0.3f);
                this.renderControlPoint(curve2.c0, graphics);
            }
        }
        for (int i = 0; i < this.curves.size(); ++i) {
            ExplicitCubicBezierCurve2 curve3 = (ExplicitCubicBezierCurve2)this.curves.get(i);
            if (i == 0) {
                this.renderPoint(curve3.p0, this.selectedPoint == 0, graphics, mouseX, mouseY);
            }
            this.renderPoint(curve3.p1, this.selectedPoint == i + 1, graphics, mouseX, mouseY);
        }
        for (Widget widget : this.widgets) {
            if (!widget.isVisible()) continue;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            if (widget.inAnimate()) {
                widget.getAnimation().drawInBackground(graphics, mouseX, mouseY, partialTicks);
                continue;
            }
            widget.drawInBackground(graphics, mouseX, mouseY, partialTicks);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawInForeground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawInForeground(graphics, mouseX, mouseY, partialTicks);
        if (this.gui != null && this.gui.getModularUIGui() != null && this.hoverTips != null) {
            for (int i = 0; i < this.curves.size(); ++i) {
                Vec2 position;
                ExplicitCubicBezierCurve2 curve = (ExplicitCubicBezierCurve2)this.curves.get(i);
                if (i == 0) {
                    position = this.getPointPosition(curve.p0);
                    if (CurveLineWidget.isMouseOver((int)((int)(position.f_82470_ - 2.0f)), (int)((int)(position.f_82471_ - 2.0f)), (int)4, (int)4, (double)mouseX, (double)mouseY)) {
                        this.gui.getModularUIGui().setHoverTooltip(List.of(this.hoverTips.apply(curve.p0)), ItemStack.f_41583_, null, null);
                        return;
                    }
                }
                position = this.getPointPosition(curve.p1);
                if (!CurveLineWidget.isMouseOver((int)((int)(position.f_82470_ - 2.0f)), (int)((int)(position.f_82471_ - 2.0f)), (int)4, (int)4, (double)mouseX, (double)mouseY)) continue;
                this.gui.getModularUIGui().setHoverTooltip(List.of(this.hoverTips.apply(curve.p0)), ItemStack.f_41583_, null, null);
                return;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void renderPoint(Vec2 point, boolean isSelected, @NotNull GuiGraphics graphics, int mouseX, int mouseY) {
        Vec2 position = this.getPointPosition(point);
        if (isSelected) {
            ColorPattern.RED.rectTexture().setRadius(2.0f).draw(graphics, mouseX, mouseY, position.f_82470_ - 2.0f, position.f_82471_ - 2.0f, 4, 4);
        } else {
            ColorPattern.GRAY.rectTexture().setRadius(2.0f).draw(graphics, mouseX, mouseY, position.f_82470_ - 2.0f, position.f_82471_ - 2.0f, 4, 4);
            if (CurveLineWidget.isMouseOver((int)((int)(position.f_82470_ - 2.0f)), (int)((int)(position.f_82471_ - 2.0f)), (int)4, (int)4, (double)mouseX, (double)mouseY)) {
                ColorPattern.WHITE.borderTexture(1).setRadius(2.0f).draw(graphics, mouseX, mouseY, position.f_82470_ - 2.0f, position.f_82471_ - 2.0f, 4, 4);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void renderControlPoint(Vec2 point, @NotNull GuiGraphics graphics) {
        Vec2 position = this.getPointPosition(point);
        ColorPattern.GREEN.rectTexture().setRadius(1.0f).draw(graphics, 0, 0, position.f_82470_ - 1.0f, position.f_82471_ - 1.0f, 2, 2);
    }

    public void setLockControlPoint(boolean lockControlPoint) {
        this.lockControlPoint = lockControlPoint;
    }

    public boolean isLockControlPoint() {
        return this.lockControlPoint;
    }

    public void setSelectedPoint(int selectedPoint) {
        this.selectedPoint = selectedPoint;
    }

    public int getSelectedPoint() {
        return this.selectedPoint;
    }

    public void setRenderGrid(boolean renderGrid) {
        this.renderGrid = renderGrid;
    }

    public void setGridSize(Size gridSize) {
        this.gridSize = gridSize;
    }

    public void setOnUpdate(Consumer<ECBCurves> onUpdate) {
        this.onUpdate = onUpdate;
    }

    public void setHoverTips(Function<Vec2, Component> hoverTips) {
        this.hoverTips = hoverTips;
    }
}

