/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.gameobject.emitter.data.number.color;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.texture.ColorBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.DialogWidget;
import com.lowdragmc.lowdraglib.gui.widget.GradientColorWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.ColorUtils;
import com.lowdragmc.lowdraglib.utils.GradientColor;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunction;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunctionConfig;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.color.RandomGradientColorTexture;
import com.lowdragmc.photon.gui.editor.GradientsResource;
import com.lowdragmc.photon.gui.editor.configurator.NumberFunctionConfigurator;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class RandomGradient
implements NumberFunction {
    private final GradientColor gradientColor0;
    private final GradientColor gradientColor1;

    public RandomGradient() {
        this.gradientColor0 = new GradientColor();
        this.gradientColor1 = new GradientColor();
    }

    public RandomGradient(int color) {
        this.gradientColor0 = new GradientColor(new int[]{color, color});
        this.gradientColor1 = new GradientColor(new int[]{color, color});
    }

    public RandomGradient(NumberFunctionConfig config) {
        this((int)config.defaultValue());
    }

    @Override
    public Number get(float t, Supplier<Float> lerp) {
        int color0 = this.gradientColor0.getColor(t);
        int color1 = this.gradientColor1.getColor(t);
        return ColorUtils.blendColor((int)color0, (int)color1, (float)lerp.get().floatValue());
    }

    @Override
    public NumberFunction copy() {
        RandomGradient copied = new RandomGradient();
        copied.deserializeNBT(this.serializeNBT());
        return copied;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RandomGradient) {
            RandomGradient gradient = (RandomGradient)obj;
            return this.gradientColor0.serializeNBT().equals((Object)gradient.gradientColor0.serializeNBT()) && this.gradientColor1.serializeNBT().equals((Object)gradient.gradientColor1.serializeNBT());
        }
        return super.equals(obj);
    }

    @Override
    public void createConfigurator(WidgetGroup group, NumberFunctionConfigurator configurator) {
        ColorBorderTexture background = ColorPattern.T_GRAY.borderTexture(1);
        group.addWidget(new ButtonWidget(0, 2, group.getSize().width, 10, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{background, new RandomGradientColorTexture(this.gradientColor0, this.gradientColor1)}), cd -> {
            if (Editor.INSTANCE != null) {
                Size size = new Size(315, 188);
                Position position = group.getPosition();
                int rightPlace = group.getGui().getScreenWidth() - size.width;
                GradientColorWidget gradientWidget0 = new GradientColorWidget(5, 0, 150, this.gradientColor0);
                gradientWidget0.setOnUpdate(g -> configurator.updateValue(this));
                GradientColorWidget gradientWidget1 = new GradientColorWidget(160, 0, 150, this.gradientColor1);
                gradientWidget1.setOnUpdate(g -> configurator.updateValue(this));
                DialogWidget dialog = Editor.INSTANCE.openDialog(new DialogWidget(Math.min(position.x, rightPlace), Math.max(0, position.y - size.height), size.width, size.height));
                dialog.setBackground(new IGuiTexture[]{new GuiTextureGroup(new IGuiTexture[]{ColorPattern.BLACK.rectTexture(), ColorPattern.T_WHITE.borderTexture(-1)})});
                dialog.setClickClose(true);
                dialog.addWidget((Widget)gradientWidget0);
                dialog.addWidget((Widget)gradientWidget1);
            }
        }).setDraggingConsumer(o -> {
            GradientsResource.Gradients g;
            return o instanceof GradientsResource.Gradients && (g = (GradientsResource.Gradients)o).isRandomGradient();
        }, o -> background.setColor(ColorPattern.GREEN.color), o -> background.setColor(ColorPattern.T_GRAY.color), o -> {
            if (o instanceof GradientsResource.Gradients) {
                GradientsResource.Gradients g = (GradientsResource.Gradients)o;
                if (g.gradient1 != null) {
                    this.gradientColor0.deserializeNBT(g.gradient0.serializeNBT());
                    this.gradientColor1.deserializeNBT(g.gradient1.serializeNBT());
                    configurator.updateValue(this);
                    background.setColor(ColorPattern.T_GRAY.color);
                }
            }
        }));
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("a", (Tag)this.gradientColor0.serializeNBT());
        tag.m_128365_("b", (Tag)this.gradientColor1.serializeNBT());
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.gradientColor0.deserializeNBT(tag.m_128469_("a"));
        this.gradientColor1.deserializeNBT(tag.m_128469_("b"));
    }

    public GradientColor getGradientColor0() {
        return this.gradientColor0;
    }

    public GradientColor getGradientColor1() {
        return this.gradientColor1;
    }
}

