/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.gameobject.emitter.data.number.color;

import com.lowdragmc.lowdraglib.gui.editor.configurator.ColorConfigurator;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.ColorUtils;
import com.lowdragmc.lowdraglib.utils.Size;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunction;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunctionConfig;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.RandomConstant;
import com.lowdragmc.photon.gui.editor.configurator.NumberFunctionConfigurator;
import java.util.function.Supplier;
import net.minecraft.util.RandomSource;

public class RandomColor
extends RandomConstant {
    public RandomColor() {
        this(-16777216, -1);
    }

    public RandomColor(Number a, Number b) {
        super(a, b, false);
    }

    public RandomColor(NumberFunctionConfig config) {
        super(config);
    }

    @Override
    public NumberFunction copy() {
        return new RandomColor(this.getA(), this.getB());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof RandomColor) {
            RandomColor randomColor = (RandomColor)obj;
            return this.getA().equals(randomColor.getA()) && this.getB().equals(randomColor.getB());
        }
        return super.equals(obj);
    }

    @Override
    public Number get(float t, Supplier<Float> lerp) {
        int colorA = this.getA().intValue();
        int colorB = this.getB().intValue();
        return ColorUtils.blendColor((int)colorA, (int)colorB, (float)lerp.get().floatValue());
    }

    private int randomColor(RandomSource randomSource, int minA, int maxA, int minR, int maxR, int minG, int maxG, int minB, int maxB) {
        return minR + randomSource.m_188503_(maxA + 1 - minA) << 24 | minR + randomSource.m_188503_(maxR + 1 - minR) << 16 | minG + randomSource.m_188503_(maxG + 1 - minG) << 8 | minB + randomSource.m_188503_(maxB + 1 - minB);
    }

    private int randomColor(RandomSource randomSource, int colorA, int colorB) {
        return this.randomColor(randomSource, Math.min(ColorUtils.alphaI((int)colorA), ColorUtils.alphaI((int)colorB)), Math.max(ColorUtils.alphaI((int)colorA), ColorUtils.alphaI((int)colorB)), Math.min(ColorUtils.redI((int)colorA), ColorUtils.redI((int)colorB)), Math.max(ColorUtils.redI((int)colorA), ColorUtils.redI((int)colorB)), Math.min(ColorUtils.greenI((int)colorA), ColorUtils.greenI((int)colorB)), Math.max(ColorUtils.greenI((int)colorA), ColorUtils.greenI((int)colorB)), Math.min(ColorUtils.blueI((int)colorA), ColorUtils.blueI((int)colorB)), Math.max(ColorUtils.blueI((int)colorA), ColorUtils.blueI((int)colorB)));
    }

    @Override
    public void createConfigurator(WidgetGroup group, NumberFunctionConfigurator configurator) {
        Size size = group.getSize();
        WidgetGroup aGroup = new WidgetGroup(0, 0, size.width / 2, size.height);
        WidgetGroup bGroup = new WidgetGroup(size.width / 2, 0, size.width / 2, size.height);
        group.addWidget((Widget)aGroup);
        group.addWidget((Widget)bGroup);
        this.setupNumberConfigurator(size, aGroup, new ColorConfigurator("", () -> this.getA().intValue(), number -> {
            this.setA((Number)number);
            configurator.updateValue(this);
        }, (Number)this.getA().intValue(), true), configurator);
        this.setupNumberConfigurator(size, bGroup, new ColorConfigurator("", () -> this.getB().intValue(), number -> {
            this.setB((Number)number);
            configurator.updateValue(this);
        }, (Number)this.getB().intValue(), true), configurator);
    }

    private void setupNumberConfigurator(Size size, WidgetGroup group, ColorConfigurator widget, NumberFunctionConfigurator configurator) {
        group.addWidget((Widget)widget);
        widget.setConfiguratorContainer(configurator.getConfiguratorContainer());
        widget.init(size.width / 2);
    }
}

