/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.gameobject.emitter.data.number;

import com.lowdragmc.lowdraglib.gui.editor.configurator.NumberConfigurator;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.Size;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunction;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunctionConfig;
import com.lowdragmc.photon.gui.editor.configurator.NumberFunctionConfigurator;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;

public class RandomConstant
implements NumberFunction {
    private Number a;
    private Number b;
    private boolean isDecimals;

    public RandomConstant() {
        this.a = 0;
        this.b = 0;
    }

    public RandomConstant(Number a, Number b, boolean isDecimals) {
        this.a = a;
        this.b = b;
        this.isDecimals = isDecimals;
    }

    public RandomConstant(NumberFunctionConfig config) {
        this(Float.valueOf(config.defaultValue()), Float.valueOf(config.defaultValue()), config.isDecimals());
    }

    @Override
    public Number get(float t, Supplier<Float> lerp) {
        float max;
        float min = Math.min(this.a.floatValue(), this.b.floatValue());
        if (min == (max = Math.max(this.a.floatValue(), this.b.floatValue()))) {
            return Float.valueOf(max);
        }
        if (this.isDecimals) {
            return Float.valueOf(min + lerp.get().floatValue() * (max - min));
        }
        return (int)(min + lerp.get().floatValue() * (max + 1.0f - min));
    }

    @Override
    public NumberFunction copy() {
        return new RandomConstant(this.a, this.b, this.isDecimals);
    }

    public boolean equals(Object obj) {
        if (obj instanceof RandomConstant) {
            RandomConstant constant = (RandomConstant)obj;
            return this.a.equals(constant.a) && this.b.equals(constant.b) && this.isDecimals == constant.isDecimals;
        }
        return super.equals(obj);
    }

    @Override
    public void createConfigurator(WidgetGroup group, NumberFunctionConfigurator configurator) {
        WidgetGroup bGroup;
        WidgetGroup aGroup;
        int width;
        Size size = group.getSize();
        if (size.width > 60) {
            width = size.width / 2;
            aGroup = new WidgetGroup(0, 0, width, size.height);
            bGroup = new WidgetGroup(width, 0, width, size.height);
        } else {
            width = size.width;
            aGroup = new WidgetGroup(0, 0, width, size.height);
            bGroup = new WidgetGroup(0, 15, width, size.height);
            group.setSize(new Size(size.width, size.height + 15));
        }
        group.addWidget((Widget)aGroup);
        group.addWidget((Widget)bGroup);
        this.setupNumberConfigurator(configurator, width, aGroup, new NumberConfigurator("", () -> Float.valueOf(this.isDecimals ? this.a.floatValue() : (float)this.a.intValue()), number -> {
            this.setA((Number)number);
            configurator.updateValue(this);
        }, this.a, true));
        this.setupNumberConfigurator(configurator, width, bGroup, new NumberConfigurator("", () -> Float.valueOf(this.isDecimals ? this.b.floatValue() : (float)this.b.intValue()), number -> {
            this.setB((Number)number);
            configurator.updateValue(this);
        }, this.b, true));
    }

    private void setupNumberConfigurator(NumberFunctionConfigurator configurator, int width, WidgetGroup group, NumberConfigurator widget) {
        group.addWidget((Widget)widget.setRange((Number)Float.valueOf(configurator.getConfig().min()), (Number)Float.valueOf(configurator.getConfig().max())).setWheel((Number)Float.valueOf(configurator.getConfig().isDecimals() ? configurator.getConfig().wheelDur() : (float)Math.max(1, (int)configurator.getConfig().wheelDur()))));
        widget.setConfiguratorContainer(configurator.getConfiguratorContainer());
        widget.init(width);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("isDecimals", this.isDecimals);
        if (this.a instanceof Float || this.a instanceof Double) {
            tag.m_128350_("a", this.a.floatValue());
        } else {
            tag.m_128405_("a", this.a.intValue());
        }
        if (this.b instanceof Float || this.b instanceof Double) {
            tag.m_128350_("b", this.b.floatValue());
        } else {
            tag.m_128405_("b", this.b.intValue());
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.isDecimals = nbt.m_128471_("isDecimals");
        this.a = nbt.m_128425_("a", 3) ? (Number)nbt.m_128451_("a") : (Number)Float.valueOf(nbt.m_128457_("a"));
        this.b = nbt.m_128425_("b", 3) ? (Number)nbt.m_128451_("b") : (Number)Float.valueOf(nbt.m_128457_("b"));
    }

    public void setA(Number a) {
        this.a = a;
    }

    public void setB(Number b) {
        this.b = b;
    }

    public Number getA() {
        return this.a;
    }

    public Number getB() {
        return this.b;
    }

    public void setDecimals(boolean isDecimals) {
        this.isDecimals = isDecimals;
    }

    public boolean isDecimals() {
        return this.isDecimals;
    }
}

