/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.gameobject.emitter.data.material;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BlendMode {
    @Configurable
    private boolean enableBlend;
    @Configurable
    private GlStateManager.SourceFactor srcColorFactor;
    @Configurable
    private GlStateManager.DestFactor dstColorFactor;
    @Configurable
    private GlStateManager.SourceFactor srcAlphaFactor;
    @Configurable
    private GlStateManager.DestFactor dstAlphaFactor;
    @Configurable
    private BlendFuc blendFunc;

    private BlendMode(boolean enableBlend, GlStateManager.SourceFactor srcColorFactor, GlStateManager.DestFactor dstColorFactor, GlStateManager.SourceFactor srcAlphaFactor, GlStateManager.DestFactor dstAlphaFactor, BlendFuc blendFunc) {
        this.srcColorFactor = srcColorFactor;
        this.dstColorFactor = dstColorFactor;
        this.srcAlphaFactor = srcAlphaFactor;
        this.dstAlphaFactor = dstAlphaFactor;
        this.enableBlend = enableBlend;
        this.blendFunc = blendFunc;
    }

    public BlendMode() {
        this(true, GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO, BlendFuc.ADD);
    }

    public BlendMode(GlStateManager.SourceFactor srcFactor, GlStateManager.DestFactor dstFactor, BlendFuc blendFunc) {
        this(true, srcFactor, dstFactor, srcFactor, dstFactor, blendFunc);
    }

    public BlendMode(GlStateManager.SourceFactor srcColorFactor, GlStateManager.DestFactor dstColorFactor, GlStateManager.SourceFactor srcAlphaFactor, GlStateManager.DestFactor dstAlphaFactor, BlendFuc blendFunc) {
        this(true, srcColorFactor, dstColorFactor, srcAlphaFactor, dstAlphaFactor, blendFunc);
    }

    public void apply() {
        if (!this.enableBlend) {
            RenderSystem.disableBlend();
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.blendEquation((int)this.blendFunc.op);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)this.srcColorFactor, (GlStateManager.DestFactor)this.dstColorFactor, (GlStateManager.SourceFactor)this.srcAlphaFactor, (GlStateManager.DestFactor)this.dstAlphaFactor);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BlendMode)) {
            return false;
        }
        BlendMode blendMode = (BlendMode)object;
        if (this.blendFunc != blendMode.blendFunc) {
            return false;
        }
        if (this.dstAlphaFactor != blendMode.dstAlphaFactor) {
            return false;
        }
        if (this.dstColorFactor != blendMode.dstColorFactor) {
            return false;
        }
        if (this.enableBlend != blendMode.enableBlend) {
            return false;
        }
        if (this.srcAlphaFactor != blendMode.srcAlphaFactor) {
            return false;
        }
        return this.srcColorFactor == blendMode.srcColorFactor;
    }

    public int hashCode() {
        int i = this.srcColorFactor.value;
        i = 31 * i + this.srcAlphaFactor.value;
        i = 31 * i + this.dstColorFactor.value;
        i = 31 * i + this.dstAlphaFactor.value;
        i = 31 * i + this.blendFunc.op;
        i = 31 * i + (this.enableBlend ? 1 : 0);
        return i;
    }

    public boolean isEnableBlend() {
        return this.enableBlend;
    }

    public void setEnableBlend(boolean enableBlend) {
        this.enableBlend = enableBlend;
    }

    public GlStateManager.SourceFactor getSrcColorFactor() {
        return this.srcColorFactor;
    }

    public void setSrcColorFactor(GlStateManager.SourceFactor srcColorFactor) {
        this.srcColorFactor = srcColorFactor;
    }

    public GlStateManager.DestFactor getDstColorFactor() {
        return this.dstColorFactor;
    }

    public void setDstColorFactor(GlStateManager.DestFactor dstColorFactor) {
        this.dstColorFactor = dstColorFactor;
    }

    public GlStateManager.SourceFactor getSrcAlphaFactor() {
        return this.srcAlphaFactor;
    }

    public void setSrcAlphaFactor(GlStateManager.SourceFactor srcAlphaFactor) {
        this.srcAlphaFactor = srcAlphaFactor;
    }

    public GlStateManager.DestFactor getDstAlphaFactor() {
        return this.dstAlphaFactor;
    }

    public void setDstAlphaFactor(GlStateManager.DestFactor dstAlphaFactor) {
        this.dstAlphaFactor = dstAlphaFactor;
    }

    public BlendFuc getBlendFunc() {
        return this.blendFunc;
    }

    public void setBlendFunc(BlendFuc blendFunc) {
        this.blendFunc = blendFunc;
    }

    public static enum BlendFuc {
        ADD(32774),
        sub(32778),
        REVERSE_sub(32779),
        MIN(32775),
        MAX(32776);

        public final int op;

        private BlendFuc(int op) {
            this.op = op;
        }
    }
}

