/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.gameobject.emitter.data;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.utils.Range;
import com.lowdragmc.photon.client.gameobject.emitter.data.ToggleGroup;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.Constant;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunction;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunctionConfig;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.RandomConstant;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.Curve;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.CurveConfig;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.RandomCurve;
import com.lowdragmc.photon.client.gameobject.particle.IParticle;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector4f;

@OnlyIn(value=Dist.CLIENT)
public class UVAnimationSetting
extends ToggleGroup {
    @Configurable(tips={"photon.emitter.config.uvAnimation.tiles"})
    @NumberRange(range={1.0, 2.147483647E9})
    protected Range tiles = new Range((Number)1, (Number)1);
    @Configurable(tips={"photon.emitter.config.uvAnimation.animation"})
    protected Animation animation = Animation.WholeSheet;
    @Configurable(tips={"photon.emitter.config.uvAnimation.frameOverTime"})
    @NumberFunctionConfig(types={Constant.class, RandomConstant.class, Curve.class, RandomCurve.class}, min=0.0f, curveConfig=@CurveConfig(bound={0.0f, 4.0f}, xAxis="lifetime", yAxis="frame over time"))
    protected NumberFunction frameOverTime = NumberFunction.constant(0);
    @Configurable(tips={"photon.emitter.config.uvAnimation.startFrame"})
    @NumberFunctionConfig(types={Constant.class, RandomConstant.class}, min=0.0f)
    protected NumberFunction startFrame = NumberFunction.constant(0);
    @Configurable(tips={"photon.emitter.config.uvAnimation.cycle"})
    @NumberRange(range={0.0, 2.147483647E9}, wheel=1.0)
    protected float cycle = 1.0f;

    public Vector4f getUVs(IParticle particle, float partialTicks) {
        float v0;
        float u0;
        float t = particle.getT(partialTicks);
        float cellU = 1.0f / (float)this.tiles.getA().intValue();
        float cellV = 1.0f / (float)this.tiles.getB().intValue();
        float currentFrame = this.startFrame.get(t, () -> Float.valueOf(particle.getMemRandom("startFrame"))).floatValue();
        currentFrame += this.cycle * this.frameOverTime.get(t, () -> Float.valueOf(particle.getMemRandom("frameOverTime"))).floatValue();
        int cellSize = this.tiles.getA().intValue();
        if (this.animation == Animation.WholeSheet) {
            int X = (int)(currentFrame % (float)cellSize);
            int Y = (int)(currentFrame / (float)cellSize);
            u0 = (float)X * cellU;
            v0 = (float)Y * cellV;
        } else {
            int X = (int)(currentFrame % (float)cellSize);
            int Y = (int)(particle.getMemRandom("randomRow") * (float)this.tiles.getB().intValue());
            u0 = (float)X * cellU;
            v0 = (float)Y * cellV;
        }
        float u1 = u0 + cellU;
        float v1 = v0 + cellV;
        return new Vector4f(u0, v0, u1, v1);
    }

    public void setTiles(Range tiles) {
        this.tiles = tiles;
    }

    public Range getTiles() {
        return this.tiles;
    }

    public void setAnimation(Animation animation) {
        this.animation = animation;
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public void setFrameOverTime(NumberFunction frameOverTime) {
        this.frameOverTime = frameOverTime;
    }

    public NumberFunction getFrameOverTime() {
        return this.frameOverTime;
    }

    public void setStartFrame(NumberFunction startFrame) {
        this.startFrame = startFrame;
    }

    public NumberFunction getStartFrame() {
        return this.startFrame;
    }

    public void setCycle(float cycle) {
        this.cycle = cycle;
    }

    public float getCycle() {
        return this.cycle;
    }

    public static enum Animation {
        WholeSheet,
        SingleRow;

    }
}

