/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.gameobject.emitter.data;

import com.lowdragmc.lowdraglib.gui.editor.accessors.TypesAccessor;
import com.lowdragmc.lowdraglib.gui.editor.annotation.ConfigAccessor;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.gui.editor.configurator.SelectorConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.runtime.PersistedParser;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.syncdata.ITagSerializable;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.photon.client.fx.FX;
import com.lowdragmc.photon.client.fx.FXRuntime;
import com.lowdragmc.photon.client.gameobject.IFXObject;
import com.lowdragmc.photon.client.gameobject.emitter.IParticleEmitter;
import com.lowdragmc.photon.client.gameobject.emitter.data.ToggleGroup;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.Constant;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunction;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunctionConfig;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.RandomConstant;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.Curve;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.CurveConfig;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.RandomCurve;
import com.lowdragmc.photon.client.gameobject.particle.TileParticle;
import com.lowdragmc.photon.gui.editor.FXEditor;
import com.lowdragmc.photon.gui.editor.FXProject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class SubEmittersSetting
extends ToggleGroup
implements IConfigurable,
ITagSerializable<CompoundTag> {
    @Configurable(persisted=false)
    protected List<Emitter> emitters = new ArrayList<Emitter>();

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        PersistedParser.serializeNBT((CompoundTag)tag, this.getClass(), (Object)this);
        ListTag list = new ListTag();
        for (Emitter emitter : this.emitters) {
            CompoundTag element = new CompoundTag();
            PersistedParser.serializeNBT((CompoundTag)element, Emitter.class, (Object)emitter);
            list.add((Object)element);
        }
        tag.m_128365_("emitters", (Tag)list);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        PersistedParser.deserializeNBT((CompoundTag)tag, new HashMap(), this.getClass(), (Object)this);
        this.emitters.clear();
        ListTag list = tag.m_128437_("emitters", 10);
        for (Tag element : list) {
            if (!(element instanceof CompoundTag)) continue;
            CompoundTag nbt = (CompoundTag)element;
            Emitter emitter = new Emitter();
            try {
                PersistedParser.deserializeNBT((CompoundTag)nbt, new HashMap(), Emitter.class, (Object)emitter);
                this.emitters.add(emitter);
            }
            catch (Exception exception) {}
        }
    }

    public void triggerEvent(FX fx, TileParticle father, Event event) {
        for (Emitter candidate : this.emitters) {
            if (candidate.event != event) continue;
            candidate.spawnEmitter(fx, father);
        }
    }

    public void setEmitters(List<Emitter> emitters) {
        this.emitters = emitters;
    }

    public List<Emitter> getEmitters() {
        return this.emitters;
    }

    public static class Emitter
    implements IConfigurable {
        @Persisted
        protected String emitter = "";
        @Configurable(tips={"photon.emitter.config.sub_emitters.emitter.event"})
        protected Event event = Event.Birth;
        @Configurable(tips={"photon.emitter.config.sub_emitters.emitter.emit_probability"})
        @NumberFunctionConfig(types={Constant.class, RandomConstant.class, Curve.class, RandomCurve.class}, min=0.0f, max=1.0f, curveConfig=@CurveConfig(bound={0.0f, 1.0f}, xAxis="probability", yAxis="lifetime"))
        protected NumberFunction emitProbability = NumberFunction.constant(0);
        @Configurable(tips={"photon.emitter.config.sub_emitters.emitter.tick_interval"})
        @NumberRange(range={1.0, 2.147483647E9})
        protected int tickInterval = 1;
        @Configurable(tips={"photon.emitter.config.sub_emitters.emitter.inherit_color"})
        protected boolean inheritColor = false;
        @Configurable(tips={"photon.emitter.config.sub_emitters.emitter.inherit_size"})
        protected boolean inheritSize = false;
        @Configurable(tips={"photon.emitter.config.sub_emitters.emitter.inherit_rotation"})
        protected boolean inheritRotation = false;
        @Configurable(tips={"photon.emitter.config.sub_emitters.emitter.inherit_lifetime"})
        protected boolean inheritLifetime = false;
        @Configurable(tips={"photon.emitter.config.sub_emitters.emitter.inherit_duration"})
        protected boolean inheritDuration = false;

        public void spawnEmitter(FX fx, TileParticle father) {
            if (father.getAge() % this.tickInterval == 0 && father.getRandomSource().m_188501_() < this.emitProbability.get(father.getT(0.0f), () -> Float.valueOf(father.getMemRandom("sub_emitter_probability"))).floatValue()) {
                FXRuntime runtime = fx.createSubFXRuntime(this.emitter);
                if (runtime == null) {
                    return;
                }
                runtime.root.updatePos(father.getWorldPos());
                for (IFXObject value : runtime.objects.values()) {
                    if (!(value instanceof IParticleEmitter)) continue;
                    IParticleEmitter emitter = (IParticleEmitter)value;
                    if (this.inheritLifetime) {
                        emitter.setAge(father.getAge());
                    }
                    if (this.inheritDuration) {
                        emitter.self().m_107257_(father.getLifetime());
                    }
                    if (this.inheritColor) {
                        emitter.setRGBAColor(father.getRealColor(0.0f));
                    }
                    if (this.inheritSize) {
                        emitter.transform().scale(father.getRealSize(0.0f));
                    }
                    if (!this.inheritRotation) continue;
                    Vector3f xyz = father.getRealRotation(0.0f);
                    emitter.transform().rotation(new Quaternionf().rotationXYZ(xyz.x, xyz.y, xyz.z));
                }
                runtime.emmit(father.getEmitter().getEffect());
            }
        }

        public void buildConfigurator(ConfiguratorGroup father) {
            FXEditor editor;
            ArrayList<String> candidates = new ArrayList<String>();
            candidates.add("");
            Editor editor2 = Editor.INSTANCE;
            if (editor2 instanceof FXEditor && (editor2 = (editor = (FXEditor)editor2).getCurrentProject()) instanceof FXProject) {
                FXProject project = (FXProject)editor2;
                project.getFx().getSubFXs().forEach((k, v) -> candidates.add((String)k));
            }
            SelectorConfigurator emitterSelector = new SelectorConfigurator("emitter", () -> this.emitter, v -> {
                this.emitter = v;
            }, (Object)"", true, candidates, s -> s);
            emitterSelector.setTips(new String[]{"photon.emitter.config.sub_emitters.emitter.name"});
            father.addConfigurators(new Configurator[]{emitterSelector});
            super.buildConfigurator(father);
        }
    }

    public static enum Event {
        Birth,
        Death,
        Collision,
        FirstCollision,
        Tick;

    }

    @ConfigAccessor
    public static class EmitterAccessor
    extends TypesAccessor<Emitter> {
        public EmitterAccessor() {
            super(new Class[]{Emitter.class});
        }

        public Emitter defaultValue(Field field, Class<?> type) {
            return new Emitter();
        }

        public Configurator create(String name, Supplier<Emitter> supplier, Consumer<Emitter> consumer, boolean forceUpdate, Field field) {
            ConfiguratorGroup group = new ConfiguratorGroup("emitter", true);
            Emitter emitter = supplier.get();
            emitter = emitter == null ? new Emitter() : emitter;
            emitter.buildConfigurator(group);
            return group;
        }
    }
}

