/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.gameobject.emitter.data;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.gui.editor.configurator.SelectorConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.runtime.AnnotationDetector;
import com.lowdragmc.lowdraglib.syncdata.IPersistedSerializable;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.photon.client.gameobject.emitter.IParticleEmitter;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.Constant;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunction3;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunction3Config;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunctionConfig;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.RandomConstant;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.Curve;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.CurveConfig;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.RandomCurve;
import com.lowdragmc.photon.client.gameobject.emitter.data.shape.Cone;
import com.lowdragmc.photon.client.gameobject.emitter.data.shape.IShape;
import com.lowdragmc.photon.client.gameobject.particle.TileParticle;
import com.lowdragmc.photon.integration.PhotonLDLibPlugin;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@OnlyIn(value=Dist.CLIENT)
public class ShapeSetting
implements IConfigurable,
IPersistedSerializable {
    @Persisted
    private IShape shape = new Cone();
    @Configurable(tips={"photon.emitter.config.shape.position"})
    @NumberFunction3Config(allowSeperated=false, isSeperatedDefault=true, common=@NumberFunctionConfig(types={Constant.class, RandomConstant.class, Curve.class, RandomCurve.class}, min=-1000.0f, max=1000.0f, curveConfig=@CurveConfig(bound={-3.0f, 3.0f}, xAxis="duration", yAxis="position")))
    private NumberFunction3 position = new NumberFunction3(0, 0, 0);
    @Configurable(tips={"photon.emitter.config.shape.rotation"})
    @NumberFunction3Config(allowSeperated=false, isSeperatedDefault=true, common=@NumberFunctionConfig(types={Constant.class, RandomConstant.class, Curve.class, RandomCurve.class}, wheelDur=10.0f, min=-3.4028235E38f, max=3.4028235E38f, curveConfig=@CurveConfig(bound={-180.0f, 180.0f}, xAxis="duration", yAxis="rotation")))
    private NumberFunction3 rotation = new NumberFunction3(0, 0, 0);
    @Configurable(tips={"photon.emitter.config.shape.scale"})
    @NumberFunction3Config(allowSeperated=false, isSeperatedDefault=true, common=@NumberFunctionConfig(types={Constant.class, RandomConstant.class, Curve.class, RandomCurve.class}, min=0.0f, max=1000.0f, curveConfig=@CurveConfig(bound={0.0f, 3.0f}, xAxis="duration", yAxis="scale")))
    private NumberFunction3 scale = new NumberFunction3(1, 1, 1);

    public void deserializeNBT(CompoundTag tag) {
        super.deserializeNBT(tag);
        if (tag.m_128469_("position").m_128425_("x", 6)) {
            CompoundTag pos = tag.m_128469_("position");
            this.position = new NumberFunction3(pos.m_128459_("x"), pos.m_128459_("y"), pos.m_128459_("z"));
            CompoundTag rot = tag.m_128469_("rotation");
            this.rotation = new NumberFunction3(rot.m_128459_("x"), rot.m_128459_("y"), rot.m_128459_("z"));
            CompoundTag sca = tag.m_128469_("scale");
            this.scale = new NumberFunction3(sca.m_128459_("x"), sca.m_128459_("y"), sca.m_128459_("z"));
        }
    }

    public void setupParticle(TileParticle particle, IParticleEmitter emitter) {
        float t = emitter.getT();
        this.shape.nextPosVel(particle, emitter, this.position.get(t, () -> Float.valueOf(emitter.getMemRandom("shape_position"))), new Vector3f((Vector3fc)this.rotation.get(t, () -> Float.valueOf(emitter.getMemRandom("shape_rotation"))).mul((float)Math.PI / 180)), new Vector3f((Vector3fc)this.scale.get(t, () -> Float.valueOf(emitter.getMemRandom("shape_scale")))));
    }

    public void buildConfigurator(ConfiguratorGroup father) {
        super.buildConfigurator(father);
        ConfiguratorGroup group = new ConfiguratorGroup("", false);
        SelectorConfigurator selector = new SelectorConfigurator("Shape", () -> this.shape.name(), name -> {
            AnnotationDetector.Wrapper<LDLRegister, ? extends IShape> wrapper = PhotonLDLibPlugin.REGISTER_SHAPES.get(name);
            if (wrapper != null) {
                this.shape = (IShape)wrapper.creator().get();
                group.removeAllConfigurators();
                this.shape.buildConfigurator(group);
                father.computeLayout();
            }
        }, (Object)"Sphere", true, PhotonLDLibPlugin.REGISTER_SHAPES.keySet().stream().toList(), String::toString);
        selector.setMax(PhotonLDLibPlugin.REGISTER_SHAPES.size());
        father.addConfigurators(new Configurator[]{selector});
        group.setCanCollapse(false);
        this.shape.buildConfigurator(group);
        father.addConfigurators(new Configurator[]{group});
    }

    public IShape getShape() {
        return this.shape;
    }

    public NumberFunction3 getPosition() {
        return this.position;
    }

    public NumberFunction3 getRotation() {
        return this.rotation;
    }

    public NumberFunction3 getScale() {
        return this.scale;
    }

    public void setShape(IShape shape) {
        this.shape = shape;
    }

    public void setPosition(NumberFunction3 position) {
        this.position = position;
    }

    public void setRotation(NumberFunction3 rotation) {
        this.rotation = rotation;
    }

    public void setScale(NumberFunction3 scale) {
        this.scale = scale;
    }
}

