/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.gameobject.emitter.data;

import com.lowdragmc.lowdraglib.client.renderer.impl.IModelRenderer;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberColor;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.editor.configurator.BooleanConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorSelectorConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.syncdata.IPersistedSerializable;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.photon.client.gameobject.emitter.Emitter;
import com.lowdragmc.photon.client.gameobject.emitter.data.ToggleGroup;
import com.lowdragmc.photon.client.gameobject.particle.TileParticle;
import java.util.Arrays;
import net.minecraft.client.Camera;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class RendererSetting {
    @Configurable(tips={"photon.emitter.config.renderer.layer"})
    protected Layer layer = Layer.Translucent;
    @Configurable(tips={"photon.emitter.config.renderer.bloomEffect"})
    protected boolean bloomEffect = false;
    @Configurable(tips={"photon.emitter.config.renderer.bloomColor"})
    @NumberColor
    protected int bloomColor = -1;
    @Configurable(name="cull", subConfigurable=true, tips={"photon.emitter.config.renderer.cull"})
    protected final Cull cull = new Cull();

    public Layer getLayer() {
        return this.layer;
    }

    public boolean isBloomEffect() {
        return this.bloomEffect;
    }

    public Cull getCull() {
        return this.cull;
    }

    public void setLayer(Layer layer) {
        this.layer = layer;
    }

    public void setBloomEffect(boolean bloomEffect) {
        this.bloomEffect = bloomEffect;
    }

    public void setBloomColor(int bloomColor) {
        this.bloomColor = bloomColor;
    }

    public int getBloomColor() {
        return this.bloomColor;
    }

    public static enum Layer {
        Opaque,
        Translucent;

    }

    public static class Cull
    extends ToggleGroup {
        @Configurable
        @NumberRange(range={-10000.0, 10000.0})
        protected Vector3f from = new Vector3f(-0.5f, -0.5f, -0.5f);
        @Configurable
        @NumberRange(range={-10000.0, 10000.0})
        protected Vector3f to = new Vector3f(0.5f, 0.5f, 0.5f);

        public AABB getCullAABB(Emitter particle, float partialTicks) {
            Vector3f pos = particle.transform().position();
            return new AABB((double)this.from.x, (double)this.from.y, (double)this.from.z, (double)this.to.x, (double)this.to.y, (double)this.to.z).m_82386_((double)pos.x, (double)pos.y, (double)pos.z);
        }

        public void setFrom(Vector3f from) {
            this.from = from;
        }

        public Vector3f getFrom() {
            return this.from;
        }

        public void setTo(Vector3f to) {
            this.to = to;
        }

        public Vector3f getTo() {
            return this.to;
        }
    }

    public static class Particle
    extends RendererSetting
    implements IConfigurable,
    IPersistedSerializable {
        @Persisted
        protected Mode renderMode = Mode.Billboard;
        @Nullable
        protected IModelRenderer model;
        @Persisted
        protected boolean shade = true;
        @Persisted
        protected boolean useBlockUV = true;

        public void buildConfigurator(ConfiguratorGroup father) {
            ConfiguratorSelectorConfigurator configurator = new ConfiguratorSelectorConfigurator("renderMode", false, this::getRenderMode, this::setRenderMode, (Object)Mode.Billboard, true, Arrays.stream(Mode.values()).toList(), Enum::name, (mode, container) -> {
                if (mode == Mode.Model) {
                    this.getModel().buildConfigurator((ConfiguratorGroup)container);
                    BooleanConfigurator shadeConfigurator = new BooleanConfigurator("shade", this::isShade, this::setShade, Boolean.valueOf(true), true);
                    shadeConfigurator.setTips(new String[]{"photon.emitter.config.renderer.renderMode.model.shade"});
                    container.addConfigurators(new Configurator[]{shadeConfigurator});
                    BooleanConfigurator useBlockUVConfigurator = new BooleanConfigurator("useBlockUV", this::isUseBlockUV, this::setUseBlockUV, Boolean.valueOf(true), true);
                    shadeConfigurator.setTips(new String[]{"photon.emitter.config.renderer.renderMode.model.useBlockUV"});
                    container.addConfigurators(new Configurator[]{useBlockUVConfigurator});
                }
            });
            configurator.setTips(new String[]{"photon.emitter.config.renderer.renderMode"});
            father.addConfigurators(new Configurator[]{configurator});
            super.buildConfigurator(father);
        }

        public IModelRenderer getModel() {
            if (this.model == null) {
                this.model = new IModelRenderer(new ResourceLocation("block/dirt"));
            }
            return this.model;
        }

        public void deserializeNBT(CompoundTag tag) {
            super.deserializeNBT(tag);
            if (this.renderMode == Mode.Model) {
                if (this.model == null) {
                    this.model = new IModelRenderer(new ResourceLocation("block/dirt"));
                }
                this.model.deserializeNBT(tag.m_128469_("model"));
            }
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = super.serializeNBT();
            if (this.renderMode == Mode.Model && this.model != null) {
                tag.m_128365_("model", (Tag)this.getModel().serializeNBT());
            }
            return tag;
        }

        public Mode getRenderMode() {
            return this.renderMode;
        }

        public boolean isShade() {
            return this.shade;
        }

        public boolean isUseBlockUV() {
            return this.useBlockUV;
        }

        public void setRenderMode(Mode renderMode) {
            this.renderMode = renderMode;
        }

        public void setModel(@Nullable IModelRenderer model) {
            this.model = model;
        }

        public void setShade(boolean shade) {
            this.shade = shade;
        }

        public void setUseBlockUV(boolean useBlockUV) {
            this.useBlockUV = useBlockUV;
        }

        public static enum Mode {
            Billboard((TriFunction<TileParticle, Camera, Float, Quaternionf>)((TriFunction)(p, c, t) -> c.m_253121_())),
            Horizontal(0.0f, 90.0f),
            Vertical(0.0f, 0.0f),
            VerticalBillboard((TriFunction<TileParticle, Camera, Float, Quaternionf>)((TriFunction)(p, c, t) -> {
                Quaternionf quaternion = new Quaternionf();
                quaternion.rotateY((float)Math.toRadians(-c.m_90590_()));
                return quaternion;
            })),
            Model((TriFunction<TileParticle, Camera, Float, Quaternionf>)((TriFunction)(p, c, t) -> new Quaternionf()));

            public final TriFunction<TileParticle, Camera, Float, Quaternionf> quaternion;

            private Mode(TriFunction<TileParticle, Camera, Float, Quaternionf> quaternion) {
                this.quaternion = quaternion;
            }

            private Mode(Quaternionf quaternion) {
                this.quaternion = (p, c, t) -> quaternion;
            }

            private Mode(float yRot, float xRot) {
                Quaternionf quaternion = new Quaternionf();
                quaternion.rotateY((float)Math.toRadians(-yRot));
                quaternion.rotateX((float)Math.toRadians(xRot));
                this.quaternion = (p, c, t) -> quaternion;
            }
        }
    }
}

