/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.gameobject.emitter.data;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.photon.client.gameobject.emitter.data.ToggleGroup;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.Constant;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunction;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunctionConfig;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.RandomConstant;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.Curve;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.CurveConfig;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.RandomCurve;
import com.lowdragmc.photon.client.gameobject.particle.IParticle;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PhysicsSetting
extends ToggleGroup {
    @Configurable(tips={"photon.emitter.config.physics.hasCollision"})
    protected boolean hasCollision = true;
    @Configurable(tips={"photon.emitter.config.physics.removedWhenCollided"})
    protected boolean removedWhenCollided = false;
    @Configurable(tips={"photon.emitter.config.physics.friction"})
    @NumberFunctionConfig(types={Constant.class, RandomConstant.class, Curve.class, RandomCurve.class}, min=0.0f, max=1.0f, defaultValue=1.0f, curveConfig=@CurveConfig(xAxis="duration", yAxis="friction"))
    protected NumberFunction friction = NumberFunction.constant(1);
    @Configurable(tips={"photon.emitter.config.physics.gravity"})
    @NumberFunctionConfig(types={Constant.class, RandomConstant.class, Curve.class, RandomCurve.class}, curveConfig=@CurveConfig(bound={0.0f, 1.0f}, xAxis="duration", yAxis="gravity"))
    protected NumberFunction gravity = NumberFunction.constant(0);
    @Configurable(tips={"photon.emitter.config.physics.bounceChance"})
    @NumberFunctionConfig(types={Constant.class, RandomConstant.class, Curve.class, RandomCurve.class}, min=0.0f, max=1.0f, defaultValue=1.0f, curveConfig=@CurveConfig(xAxis="duration", yAxis="bounce chance"))
    protected NumberFunction bounceChance = NumberFunction.constant(1);
    @Configurable(tips={"photon.emitter.config.physics.bounceRate"})
    @NumberFunctionConfig(types={Constant.class, RandomConstant.class, Curve.class, RandomCurve.class}, min=0.0f, defaultValue=1.0f, curveConfig=@CurveConfig(bound={0.0f, 1.0f}, xAxis="duration", yAxis="bounce rate"))
    protected NumberFunction bounceRate = NumberFunction.constant(1);
    @Configurable(tips={"photon.emitter.config.physics.bounceSpreadRate"})
    @NumberFunctionConfig(types={Constant.class, RandomConstant.class, Curve.class, RandomCurve.class}, min=0.0f, curveConfig=@CurveConfig(bound={0.0f, 1.0f}, xAxis="duration", yAxis="spread"))
    protected NumberFunction bounceSpreadRate = NumberFunction.constant(0);

    public float getFriction(IParticle particle) {
        return this.friction.get(particle.getT(), () -> Float.valueOf(particle.getMemRandom("friction"))).floatValue();
    }

    public float getGravity(IParticle particle) {
        return this.gravity.get(particle.getT(), () -> Float.valueOf(particle.getMemRandom("gravity"))).floatValue();
    }

    public float getBounceChance(IParticle particle) {
        return this.bounceChance.get(particle.getT(), () -> Float.valueOf(particle.getMemRandom("bounceChance"))).floatValue();
    }

    public float getBounceRate(IParticle particle) {
        return this.bounceRate.get(particle.getT(), () -> Float.valueOf(particle.getMemRandom("bounceRate"))).floatValue();
    }

    public float getBounceSpreadRate(IParticle particle) {
        return this.bounceSpreadRate.get(particle.getT(), () -> Float.valueOf(particle.getMemRandom("bounceSpreadRate"))).floatValue();
    }

    public void setHasCollision(boolean hasCollision) {
        this.hasCollision = hasCollision;
    }

    public void setRemovedWhenCollided(boolean removedWhenCollided) {
        this.removedWhenCollided = removedWhenCollided;
    }

    public void setFriction(NumberFunction friction) {
        this.friction = friction;
    }

    public void setGravity(NumberFunction gravity) {
        this.gravity = gravity;
    }

    public void setBounceChance(NumberFunction bounceChance) {
        this.bounceChance = bounceChance;
    }

    public void setBounceRate(NumberFunction bounceRate) {
        this.bounceRate = bounceRate;
    }

    public void setBounceSpreadRate(NumberFunction bounceSpreadRate) {
        this.bounceSpreadRate = bounceSpreadRate;
    }

    public boolean isHasCollision() {
        return this.hasCollision;
    }

    public boolean isRemovedWhenCollided() {
        return this.removedWhenCollided;
    }

    public NumberFunction getFriction() {
        return this.friction;
    }

    public NumberFunction getGravity() {
        return this.gravity;
    }

    public NumberFunction getBounceChance() {
        return this.bounceChance;
    }

    public NumberFunction getBounceRate() {
        return this.bounceRate;
    }

    public NumberFunction getBounceSpreadRate() {
        return this.bounceSpreadRate;
    }
}

